/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort.actions;

import java.util.List;
import net.sf.jasperreports.components.sort.FieldFilter;
import net.sf.jasperreports.components.sort.actions.FilterData;
import net.sf.jasperreports.engine.DatasetFilter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.util.JacksonUtil;
import net.sf.jasperreports.web.commands.Command;

public class FilterCommand
implements Command {
    private static final long serialVersionUID = 10200L;
    public static final String DATASET_FILTER_PROPERTY = "net.sf.jasperreports.filters";
    private JasperReportsContext jasperReportsContext;
    protected JRDesignDataset dataset;
    protected FilterData filterData;
    private String oldSerializedFilters;
    private String newSerializedFilters;

    public FilterCommand(JasperReportsContext jasperReportsContext, JRDesignDataset dataset, FilterData filterData) {
        this.jasperReportsContext = jasperReportsContext;
        this.dataset = dataset;
        this.filterData = filterData;
    }

    @Override
    public void execute() {
        String serializedFilters = "[]";
        JRPropertiesMap propertiesMap = this.dataset.getPropertiesMap();
        if (propertiesMap.getProperty(DATASET_FILTER_PROPERTY) != null) {
            serializedFilters = propertiesMap.getProperty(DATASET_FILTER_PROPERTY);
        }
        this.oldSerializedFilters = serializedFilters;
        JacksonUtil jacksonUtil = JacksonUtil.getInstance(this.jasperReportsContext);
        List<FieldFilter> existingFilters = jacksonUtil.loadList(serializedFilters, FieldFilter.class);
        if (!this.filterData.isClearFilter()) {
            boolean addNewFilter = false;
            if (existingFilters.size() == 0) {
                addNewFilter = true;
            } else {
                FieldFilter filterForCurrentField = null;
                for (DatasetFilter datasetFilter : existingFilters) {
                    if (!((FieldFilter)datasetFilter).getField().equals(this.filterData.getFieldName())) continue;
                    filterForCurrentField = (FieldFilter)datasetFilter;
                    break;
                }
                if (filterForCurrentField != null) {
                    filterForCurrentField.setFilterTypeOperator(this.filterData.getFilterTypeOperator());
                    filterForCurrentField.setFilterValueEnd(this.filterData.getFieldValueEnd());
                    filterForCurrentField.setFilterValueStart(this.filterData.getFieldValueStart());
                    filterForCurrentField.setFilterPattern(this.filterData.getFilterPattern());
                    filterForCurrentField.setLocaleCode(this.filterData.getLocaleCode());
                    filterForCurrentField.setTimeZoneId(this.filterData.getTimeZoneId());
                    filterForCurrentField.setIsValid(null);
                    filterForCurrentField.setIsField(this.filterData.getIsField());
                } else {
                    addNewFilter = true;
                }
            }
            if (addNewFilter) {
                FieldFilter newFilterField = new FieldFilter(this.filterData.getFieldName(), this.filterData.getFieldValueStart(), this.filterData.getFieldValueEnd(), this.filterData.getFilterType(), this.filterData.getFilterTypeOperator());
                newFilterField.setFilterPattern(this.filterData.getFilterPattern());
                newFilterField.setLocaleCode(this.filterData.getLocaleCode());
                newFilterField.setTimeZoneId(this.filterData.getTimeZoneId());
                newFilterField.setIsField(this.filterData.getIsField());
                existingFilters.add(newFilterField);
            }
        } else {
            FieldFilter filterToRemove = null;
            for (DatasetFilter datasetFilter : existingFilters) {
                if (!((FieldFilter)datasetFilter).getField().equals(this.filterData.getFieldName())) continue;
                filterToRemove = (FieldFilter)datasetFilter;
                break;
            }
            if (filterToRemove != null) {
                existingFilters.remove(filterToRemove);
            }
        }
        this.newSerializedFilters = jacksonUtil.getJsonString(existingFilters);
        propertiesMap.setProperty(DATASET_FILTER_PROPERTY, this.newSerializedFilters);
    }

    @Override
    public void undo() {
        this.dataset.getPropertiesMap().setProperty(DATASET_FILTER_PROPERTY, this.oldSerializedFilters);
    }

    @Override
    public void redo() {
        this.dataset.getPropertiesMap().setProperty(DATASET_FILTER_PROPERTY, this.newSerializedFilters);
    }
}

