/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.exceptions;

import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.util.Env;

public class NoUOMConversionException
extends AdempiereException {
    public static final String AD_Message = "NoUOMConversion";
    private static final long serialVersionUID = -4868882017576097089L;

    public NoUOMConversionException(int M_Product_ID, int C_UOM_ID, int C_UOM_To_ID) {
        super(NoUOMConversionException.buildMessage(M_Product_ID, C_UOM_ID, C_UOM_To_ID));
    }

    private static String buildMessage(int M_Product_ID, int C_UOM_ID, int C_UOM_To_ID) {
        StringBuilder sb = new StringBuilder("@NoUOMConversion@ - ");
        sb.append("@M_Product_ID@:");
        MProduct product = MProduct.get(Env.getCtx(), M_Product_ID);
        if (product != null) {
            sb.append(product.getValue()).append("_").append(product.getName());
        }
        if (C_UOM_ID > 0 || product == null) {
            sb.append("  @C_UOM_ID@:");
            MUOM uom = MUOM.get(Env.getCtx(), C_UOM_ID);
            if (uom != null) {
                sb.append(uom.getUOMSymbol());
            }
        }
        sb.append("  @C_UOM_To_ID@:");
        MUOM uomTo = MUOM.get(Env.getCtx(), C_UOM_To_ID);
        if (uomTo != null) {
            sb.append(uomTo.getUOMSymbol());
        }
        return sb.toString();
    }
}

