/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.util.Locale;
import java.util.TimeZone;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;

public class ExecutionCarryOver {
    private final Execution _exec = Executions.getCurrent();
    private Locale _locale;
    private TimeZone _timeZone;

    public ExecutionCarryOver(Desktop desktop) {
        if (this._exec == null || this._exec.getDesktop() != desktop) {
            throw new IllegalStateException("Wrong execution: " + this._exec);
        }
        this._locale = Locales.getCurrent();
        this._timeZone = TimeZones.getCurrent();
    }

    public void carryOver() {
        ExecutionsCtrl.setCurrent(this._exec);
        ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)this._exec);
        execCtrl.onActivate();
        if (Locales.getThreadLocal() == null) {
            Locales.setThreadLocal((Locale)this._locale);
        } else {
            this._locale = null;
        }
        if (TimeZones.getThreadLocal() == null) {
            TimeZones.setThreadLocal((TimeZone)this._timeZone);
        } else {
            this._timeZone = null;
        }
        Page page = this._exec.getDesktop().getFirstPage();
        if (page != null) {
            execCtrl.setCurrentPage(page);
        }
    }

    public void cleanup() {
        ((ExecutionCtrl)((Object)this._exec)).onDeactivate();
        ExecutionsCtrl.setCurrent(null);
        if (this._locale != null) {
            Locales.setThreadLocal(null);
        }
        if (this._timeZone != null) {
            TimeZones.setThreadLocal(null);
        }
    }
}

