/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;

public class MessageFormatWrapper {
    public static String format(String pattern, Locale locale, Object ... arguments) {
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(locale);
        messageFormat.applyPattern(pattern);
        Format[] formats = messageFormat.getFormats();
        for (int i = 0; i < formats.length; ++i) {
            Format format = formats[i];
            if (!(format instanceof DateFormat)) continue;
            messageFormat.setFormat(i, new DateFormatWrapper(format));
        }
        return messageFormat.format(arguments);
    }

    private static class DateFormatWrapper
    extends Format {
        private static final long serialVersionUID = 1L;
        private final Format format;

        private DateFormatWrapper(Format format) {
            this.format = format;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            if (obj instanceof TemporalAccessor) {
                Instant instant;
                TemporalAccessor ta = (TemporalAccessor)obj;
                if (obj instanceof LocalDate) {
                    LocalDate date = (LocalDate)obj;
                    instant = date.atStartOfDay(ZoneId.systemDefault()).toInstant();
                } else if (obj instanceof LocalDateTime) {
                    LocalDateTime dateTime = (LocalDateTime)obj;
                    instant = dateTime.atZone(ZoneId.systemDefault()).toInstant();
                } else if (obj instanceof ZonedDateTime) {
                    ZonedDateTime dateTime = (ZonedDateTime)obj;
                    instant = dateTime.toInstant();
                } else {
                    instant = Instant.from(ta);
                }
                obj = Date.from(instant);
            }
            return this.format.format(obj, toAppendTo, pos);
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return this.format.parseObject(source, pos);
        }
    }
}

