/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event;

import java.lang.reflect.Method;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.ForwardEvent;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.sys.ComponentsCtrl;

public abstract class GenericEventListener<T extends Event>
implements SerializableEventListener<T> {
    @Override
    public void onEvent(Event evt) throws Exception {
        Object controller = this.getController();
        Method mtd = ComponentsCtrl.getEventMethod(controller.getClass(), evt.getName());
        if (mtd != null) {
            if (mtd.getParameterTypes().length == 0) {
                mtd.invoke(controller, new Object[0]);
            } else if (evt instanceof ForwardEvent) {
                Class<?> paramcls = mtd.getParameterTypes()[0];
                if (ForwardEvent.class.isAssignableFrom(paramcls) || Event.class.equals(paramcls)) {
                    mtd.invoke(controller, evt);
                } else {
                    while ((evt = ((ForwardEvent)evt).getOrigin()) instanceof ForwardEvent) {
                    }
                    mtd.invoke(controller, evt);
                }
            } else {
                mtd.invoke(controller, evt);
            }
        }
    }

    public void bindComponent(Component comp) {
        Method[] metds = this.getController().getClass().getMethods();
        for (int i = 0; i < metds.length; ++i) {
            String evtnm = metds[i].getName();
            if (!Events.isValid(evtnm)) continue;
            comp.addEventListener(evtnm, this);
        }
    }

    public void unbindComponent(Component comp) {
        Method[] metds = this.getController().getClass().getMethods();
        for (int i = 0; i < metds.length; ++i) {
            String evtnm = metds[i].getName();
            if (!Events.isValid(evtnm)) continue;
            comp.removeEventListener(evtnm, this);
        }
    }

    protected Object getController() {
        return this;
    }
}

