/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.security.jaspi;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.ee8.nested.Authentication;
import org.eclipse.jetty.ee8.nested.SessionHandler;
import org.eclipse.jetty.ee8.security.Authenticator;
import org.eclipse.jetty.ee8.security.ServerAuthException;
import org.eclipse.jetty.ee8.security.UserAuthentication;
import org.eclipse.jetty.ee8.security.WrappedAuthConfiguration;
import org.eclipse.jetty.ee8.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.ee8.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.ee8.security.authentication.SessionAuthentication;
import org.eclipse.jetty.ee8.security.jaspi.JaspiMessageInfo;
import org.eclipse.jetty.ee8.security.jaspi.ServletCallbackHandler;
import org.eclipse.jetty.security.EmptyLoginService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.server.Request;

public class JaspiAuthenticator
extends LoginAuthenticator {
    private final Subject _serviceSubject;
    private final String _appContext;
    private final boolean _allowLazyAuthentication;
    private final AuthConfigFactory _authConfigFactory = AuthConfigFactory.getFactory();
    private Map _authProperties;
    private IdentityService _identityService;
    private ServletCallbackHandler _callbackHandler;
    private ServerAuthConfig _authConfig;

    public JaspiAuthenticator(Subject serviceSubject, String appContext, boolean allowLazyAuthentication) {
        this._serviceSubject = serviceSubject;
        this._appContext = appContext;
        this._allowLazyAuthentication = allowLazyAuthentication;
    }

    @Deprecated
    public JaspiAuthenticator(ServerAuthConfig authConfig, Map authProperties, ServletCallbackHandler callbackHandler, Subject serviceSubject, boolean allowLazyAuthentication, IdentityService identityService) {
        if (callbackHandler == null) {
            throw new NullPointerException("No CallbackHandler");
        }
        if (authConfig == null) {
            throw new NullPointerException("No AuthConfig");
        }
        this._authProperties = authProperties;
        this._callbackHandler = callbackHandler;
        this._serviceSubject = serviceSubject;
        this._allowLazyAuthentication = allowLazyAuthentication;
        this._identityService = identityService;
        this._appContext = null;
        this._authConfig = authConfig;
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        LoginService loginService = configuration.getLoginService();
        if (loginService == null) {
            configuration = new JaspiAuthConfiguration((Authenticator.AuthConfiguration)configuration);
            loginService = configuration.getLoginService();
        }
        super.setConfiguration(configuration);
        if (this._authConfig == null) {
            this._identityService = configuration.getIdentityService();
            this._callbackHandler = new ServletCallbackHandler(loginService);
            this._authProperties = new HashMap();
            for (String key : configuration.getInitParameterNames()) {
                this._authProperties.put(key, configuration.getInitParameter(key));
            }
        }
    }

    private ServerAuthConfig getAuthConfig() throws AuthException {
        if (this._authConfig != null) {
            return this._authConfig;
        }
        RegistrationListener listener = (layer, appContext) -> {
            this._authConfig = null;
        };
        AuthConfigProvider authConfigProvider = this._authConfigFactory.getConfigProvider("HttpServlet", this._appContext, listener);
        if (authConfigProvider == null) {
            this._authConfigFactory.detachListener(listener, "HttpServlet", this._appContext);
            return null;
        }
        this._authConfig = authConfigProvider.getServerAuthConfig("HttpServlet", this._appContext, (CallbackHandler)this._callbackHandler);
        return this._authConfig;
    }

    public String getAuthMethod() {
        return "JASPI";
    }

    public UserIdentity login(String username, Object password, ServletRequest request) {
        org.eclipse.jetty.ee8.nested.Request baseRequest = org.eclipse.jetty.ee8.nested.Request.getBaseRequest((ServletRequest)request);
        if (baseRequest == null) {
            return null;
        }
        UserIdentity user = this._loginService.login(username, password, (Request)baseRequest.getCoreRequest(), SessionHandler.ServletSessionApi.getOrCreateSession((ServletRequest)request));
        if (user != null) {
            this.renewSession((HttpServletRequest)request, null);
            HttpSession session = ((HttpServletRequest)request).getSession(true);
            if (session != null) {
                SessionAuthentication sessionAuth = new SessionAuthentication(this.getAuthMethod(), user, password);
                session.setAttribute("org.eclipse.jetty.security.UserIdentity", (Object)sessionAuth);
            }
        }
        return user;
    }

    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        JaspiMessageInfo info = new JaspiMessageInfo(request, response, mandatory);
        request.setAttribute("org.eclipse.jetty.security.jaspi.info", (Object)info);
        Authentication a = this.validateRequest(info);
        if (this._allowLazyAuthentication && !info.isAuthMandatory() && a == Authentication.UNAUTHENTICATED) {
            a = new DeferredAuthentication((LoginAuthenticator)this);
        }
        return a;
    }

    public Authentication validateRequest(JaspiMessageInfo messageInfo) throws ServerAuthException {
        try {
            Subject clientSubject;
            ServerAuthConfig authConfig = this.getAuthConfig();
            if (authConfig == null) {
                throw new ServerAuthException("No ServerAuthConfig");
            }
            String authContextId = authConfig.getAuthContextID((MessageInfo)messageInfo);
            ServerAuthContext authContext = authConfig.getAuthContext(authContextId, this._serviceSubject, this._authProperties);
            AuthStatus authStatus = authContext.validateRequest((MessageInfo)messageInfo, clientSubject = new Subject(), this._serviceSubject);
            if (authStatus == AuthStatus.SEND_CONTINUE) {
                return Authentication.SEND_CONTINUE;
            }
            if (authStatus == AuthStatus.SEND_FAILURE) {
                return Authentication.SEND_FAILURE;
            }
            if (authStatus == AuthStatus.SUCCESS) {
                SessionAuthentication cached;
                UserIdentity userIdentity;
                Set<UserIdentity> ids = clientSubject.getPrivateCredentials(UserIdentity.class);
                if (ids.size() > 0) {
                    userIdentity = ids.iterator().next();
                } else {
                    GroupPrincipalCallback groupPrincipalCallback;
                    CallerPrincipalCallback principalCallback = this._callbackHandler.getThreadCallerPrincipalCallback();
                    if (principalCallback == null) {
                        return Authentication.UNAUTHENTICATED;
                    }
                    Principal principal = principalCallback.getPrincipal();
                    if (principal == null) {
                        String principalName = principalCallback.getName();
                        Set<Principal> principals = principalCallback.getSubject().getPrincipals();
                        for (Principal p : principals) {
                            if (!p.getName().equals(principalName)) continue;
                            principal = p;
                            break;
                        }
                        if (principal == null) {
                            return Authentication.UNAUTHENTICATED;
                        }
                    }
                    String[] groups = (groupPrincipalCallback = this._callbackHandler.getThreadGroupPrincipalCallback()) == null ? null : groupPrincipalCallback.getGroups();
                    userIdentity = this._identityService.newUserIdentity(clientSubject, principal, groups);
                }
                HttpSession session = ((HttpServletRequest)messageInfo.getRequestMessage()).getSession(false);
                SessionAuthentication sessionAuthentication = cached = session == null ? null : (SessionAuthentication)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
                if (cached != null) {
                    return cached;
                }
                return new UserAuthentication(this.getAuthMethod(), userIdentity);
            }
            if (authStatus == AuthStatus.SEND_SUCCESS) {
                return Authentication.SEND_SUCCESS;
            }
            if (authStatus == AuthStatus.FAILURE) {
                HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
                response.sendError(403);
                return Authentication.SEND_FAILURE;
            }
            throw new IllegalStateException("No AuthStatus returned");
        }
        catch (IOException | AuthException e) {
            throw new ServerAuthException(e);
        }
    }

    public boolean secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        JaspiMessageInfo info = (JaspiMessageInfo)req.getAttribute("org.eclipse.jetty.security.jaspi.info");
        if (info == null) {
            throw new NullPointerException("MessageInfo from request missing: " + String.valueOf(req));
        }
        return this.secureResponse(info, (Authentication)validatedUser);
    }

    public boolean secureResponse(JaspiMessageInfo messageInfo, Authentication validatedUser) throws ServerAuthException {
        try {
            ServerAuthConfig authConfig = this.getAuthConfig();
            if (authConfig == null) {
                throw new NullPointerException("no ServerAuthConfig found for context");
            }
            String authContextId = authConfig.getAuthContextID((MessageInfo)messageInfo);
            ServerAuthContext authContext = authConfig.getAuthContext(authContextId, this._serviceSubject, this._authProperties);
            AuthStatus status = authContext.secureResponse((MessageInfo)messageInfo, this._serviceSubject);
            return AuthStatus.SEND_SUCCESS.equals(status);
        }
        catch (AuthException e) {
            throw new ServerAuthException((Throwable)e);
        }
    }

    private static class JaspiAuthConfiguration
    extends WrappedAuthConfiguration {
        private final LoginService loginService = new EmptyLoginService();

        public JaspiAuthConfiguration(Authenticator.AuthConfiguration configuration) {
            super(configuration);
        }

        public LoginService getLoginService() {
            return this.loginService;
        }
    }
}

