/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.websocket.javax.common.messages;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.util.List;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import org.eclipse.jetty.ee8.websocket.javax.common.JavaxWebSocketFrameHandlerFactory;
import org.eclipse.jetty.ee8.websocket.javax.common.decoders.RegisteredDecoder;
import org.eclipse.jetty.ee8.websocket.javax.common.messages.AbstractDecodedMessageSink;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.exception.CloseException;
import org.eclipse.jetty.websocket.core.messages.ByteBufferMessageSink;
import org.eclipse.jetty.websocket.core.messages.MessageSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecodedBinaryMessageSink<T>
extends AbstractDecodedMessageSink.Basic<Decoder.Binary<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(DecodedBinaryMessageSink.class);

    public DecodedBinaryMessageSink(CoreSession session, MethodHandle methodHandle, List<RegisteredDecoder> decoders) {
        super(session, methodHandle, decoders);
    }

    @Override
    MessageSink newMessageSink(CoreSession coreSession) throws Exception {
        MethodHandle methodHandle = JavaxWebSocketFrameHandlerFactory.getServerMethodHandleLookup().findVirtual(DecodedBinaryMessageSink.class, "onWholeMessage", MethodType.methodType(Void.TYPE, ByteBuffer.class)).bindTo(this);
        return new ByteBufferMessageSink(coreSession, methodHandle, true);
    }

    public void onWholeMessage(ByteBuffer wholeMessage) {
        for (Decoder.Binary decoder : this._decoders) {
            if (!decoder.willDecode(wholeMessage)) continue;
            try {
                Object obj = decoder.decode(wholeMessage);
                this.invoke(obj);
                return;
            }
            catch (DecodeException e) {
                throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Unable to decode", (Throwable)e);
            }
        }
        LOG.warn("Message lost, willDecode() has returned false for all decoders in the decoder list.");
    }
}

