/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.plus.webapp;

import java.io.Closeable;
import java.net.URL;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.eclipse.jetty.ee8.nested.ContextHandler;
import org.eclipse.jetty.ee8.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.ee8.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee8.webapp.FragmentConfiguration;
import org.eclipse.jetty.ee8.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.ee8.webapp.MetaInfConfiguration;
import org.eclipse.jetty.ee8.webapp.WebAppClassLoader;
import org.eclipse.jetty.ee8.webapp.WebAppContext;
import org.eclipse.jetty.ee8.webapp.WebXmlConfiguration;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.plus.jndi.NamingEntry;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.jndi.NamingDump;
import org.eclipse.jetty.util.jndi.NamingUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(EnvConfiguration.class);
    private static final String JETTY_ENV_BINDINGS = "org.eclipse.jetty.jndi.EnvConfiguration";
    private static final String JETTY_ENV_XML = "jetty-env.xml";
    private static final String JETTY_EE_ENV_XML = "jetty-ee8-env.xml";
    private Resource jettyEnvXmlResource;
    private NamingDump _dumper;
    private ResourceFactory.Closeable _resourceFactory;

    public EnvConfiguration() {
        this.addDependencies(new Class[]{WebXmlConfiguration.class, MetaInfConfiguration.class, FragmentConfiguration.class});
        this.addDependents(new Class[]{PlusConfiguration.class, JettyWebXmlConfiguration.class});
        this.protectAndExpose(new String[]{"org.eclipse.jetty.jndi."});
    }

    public void setJettyEnvResource(Resource resource) {
        this.jettyEnvXmlResource = resource;
    }

    public void setJettyEnvXml(URL url) {
        this.jettyEnvXmlResource = this._resourceFactory.newResource(url);
    }

    public void preConfigure(WebAppContext context) throws Exception {
        this._resourceFactory = ResourceFactory.closeable();
        this.createEnvContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(WebAppContext context) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created java:comp/env for webapp {}", (Object)context.getContextPath());
        }
        if (this.jettyEnvXmlResource == null) {
            this.jettyEnvXmlResource = this.resolveJettyEnvXml(context.getWebInf());
        }
        if (this.jettyEnvXmlResource != null) {
            Set boundNamesBefore = NamingUtil.flattenBindings((Context)new InitialContext(), (String)"").keySet();
            try {
                XmlConfiguration configuration = new XmlConfiguration(this.jettyEnvXmlResource);
                configuration.setJettyStandardIdsAndProperties((Object)context.getServer(), null);
                WebAppClassLoader.runWithServerClassAccess(() -> {
                    configuration.configure((Object)context);
                    return null;
                });
            }
            finally {
                Set boundNamesAfter = NamingUtil.flattenBindings((Context)new InitialContext(), (String)"").keySet();
                boundNamesAfter.removeAll(boundNamesBefore);
                context.setAttribute(JETTY_ENV_BINDINGS, boundNamesAfter);
            }
        }
        this.bindEnvEntries(context);
        this._dumper = new NamingDump(context.getClassLoader(), "java:comp");
        context.addBean((Object)this._dumper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deconfigure(WebAppContext context) throws Exception {
        context.removeBean((Object)this._dumper);
        this._dumper = null;
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(context.getClassLoader());
        try {
            InitialContext ic = new InitialContext();
            Context compCtx = (Context)ic.lookup("java:comp");
            compCtx.destroySubcontext("env");
            Set jettyEnvBoundNames = (Set)context.getAttribute(JETTY_ENV_BINDINGS);
            context.setAttribute(JETTY_ENV_BINDINGS, null);
            if (jettyEnvBoundNames != null) {
                for (String name : jettyEnvBoundNames) {
                    NamingUtil.unbind((Context)ic, (String)name, (boolean)true);
                }
            }
        }
        catch (NameNotFoundException e) {
            LOG.warn("Unable to destroy InitialContext", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            IO.close((Closeable)this._resourceFactory);
            this._resourceFactory = null;
        }
    }

    public void destroy(WebAppContext context) throws Exception {
        try {
            NamingEntryUtil.destroyContextForScope((Object)context);
        }
        catch (NameNotFoundException e) {
            LOG.trace("IGNORED", (Throwable)e);
            LOG.debug("No jndi entries scoped to webapp {}", (Object)context);
        }
        catch (NamingException e) {
            LOG.debug("Error unbinding jndi entries scoped to webapp {}", (Object)context, (Object)e);
        }
    }

    public void bindEnvEntries(WebAppContext context) throws NamingException {
        InitialContext ic = new InitialContext();
        Context envCtx = (Context)ic.lookup("java:comp/env");
        LOG.debug("Binding env entries from the jvm scope");
        this.doBindings(envCtx, null);
        LOG.debug("Binding env entries from the server scope");
        this.doBindings(envCtx, context.getServer());
        LOG.debug("Binding env entries from environment {} scope", (Object)ContextHandler.ENVIRONMENT.getName());
        this.doBindings(envCtx, ContextHandler.ENVIRONMENT.getName());
        LOG.debug("Binding env entries from the context scope");
        this.doBindings(envCtx, context);
    }

    private void doBindings(Context envCtx, Object scope) throws NamingException {
        for (EnvEntry ee : NamingEntryUtil.lookupNamingEntries((Object)scope, EnvEntry.class)) {
            ee.bindToENC(ee.getJndiName());
            Name namingEntryName = NamingEntryUtil.makeNamingEntryName(null, (NamingEntry)ee);
            NamingUtil.bind((Context)envCtx, (String)namingEntryName.toString(), (Object)ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createEnvContext(WebAppContext wac) throws NamingException {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wac.getClassLoader());
        try {
            InitialContext context = new InitialContext();
            Context compCtx = (Context)context.lookup("java:comp");
            compCtx.createSubcontext("env");
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private Resource resolveJettyEnvXml(Resource webInf) {
        try {
            if (webInf == null || !webInf.isDirectory()) {
                return null;
            }
            Resource xmlResource = webInf.resolve(JETTY_EE_ENV_XML);
            if (!Resources.missing((Resource)xmlResource)) {
                return xmlResource;
            }
            xmlResource = webInf.resolve(JETTY_ENV_XML);
            if (!Resources.missing((Resource)xmlResource)) {
                return xmlResource;
            }
            return null;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error resolving", (Throwable)e);
            }
            return null;
        }
    }
}

