/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.AbstractWrappedOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.local.LocalDestination;
import org.apache.cxf.transport.local.LocalTransportFactory;
import org.apache.cxf.workqueue.SynchronousExecutor;

public class LocalConduit
extends AbstractConduit {
    public static final String IN_CONDUIT = LocalConduit.class.getName() + ".inConduit";
    public static final String RESPONSE_CONDUIT = LocalConduit.class.getName() + ".inConduit";
    public static final String IN_EXCHANGE = LocalConduit.class.getName() + ".inExchange";
    public static final String DIRECT_DISPATCH = LocalConduit.class.getName() + ".directDispatch";
    public static final String MESSAGE_FILTER_PROPERTIES = LocalTransportFactory.MESSAGE_FILTER_PROPERTIES;
    private static final Logger LOG = LogUtils.getL7dLogger(LocalConduit.class);
    private LocalDestination destination;
    private LocalTransportFactory transportFactory;

    public LocalConduit(LocalTransportFactory transportFactory, LocalDestination destination) {
        super(destination.getAddress());
        this.destination = destination;
        this.transportFactory = transportFactory;
    }

    public void prepare(Message message) throws IOException {
        if (!MessageUtils.getContextualBoolean((Message)message, (String)DIRECT_DISPATCH)) {
            this.dispatchViaPipe(message);
        } else {
            CachedOutputStream stream = new CachedOutputStream();
            message.setContent(OutputStream.class, (Object)stream);
            message.put(CachedOutputStream.class, (Object)stream);
            stream.holdTempFile();
        }
    }

    public void close(Message message) throws IOException {
        if (MessageUtils.getContextualBoolean((Message)message, (String)DIRECT_DISPATCH) && !Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.message.inbound"))) {
            this.dispatchDirect(message);
        }
        super.close(message);
    }

    private void dispatchDirect(Message message) throws IOException {
        if (this.destination.getMessageObserver() == null) {
            throw new IllegalStateException("Local destination does not have a MessageObserver on address " + this.destination.getAddress().getAddress().getValue());
        }
        MessageImpl copy = new MessageImpl();
        copy.put(IN_CONDUIT, (Object)this);
        copy.setDestination((Destination)this.destination);
        this.transportFactory.copy(message, (Message)copy);
        MessageImpl.copyContent((Message)message, (Message)copy);
        OutputStream out = (OutputStream)message.getContent(OutputStream.class);
        out.flush();
        out.close();
        CachedOutputStream stream = (CachedOutputStream)message.get(CachedOutputStream.class);
        copy.setContent(InputStream.class, (Object)stream.getInputStream());
        copy.removeContent(CachedOutputStream.class);
        stream.releaseTempFileHold();
        ExchangeImpl ex = new ExchangeImpl();
        ex.setInMessage((Message)copy);
        ex.put(IN_EXCHANGE, (Object)message.getExchange());
        ex.put(DIRECT_DISPATCH, (Object)true);
        ex.setDestination((Destination)this.destination);
        this.destination.getMessageObserver().onMessage((Message)copy);
    }

    private void dispatchViaPipe(Message message) throws IOException {
        LocalConduit conduit = this;
        Exchange exchange = message.getExchange();
        if (this.destination.getMessageObserver() == null) {
            throw new IllegalStateException("Local destination does not have a MessageObserver on address " + this.destination.getAddress().getAddress().getValue());
        }
        LocalConduitOutputStream cout = new LocalConduitOutputStream(conduit, exchange, message);
        message.setContent(OutputStream.class, (Object)cout);
    }

    protected Logger getLogger() {
        return LOG;
    }

    private final class LocalConduitOutputStream
    extends AbstractWrappedOutputStream {
        private final LocalConduit conduit;
        private final Exchange exchange;
        private final Message message;

        private LocalConduitOutputStream(LocalConduit conduit, Exchange exchange, Message message) {
            this.conduit = conduit;
            this.exchange = exchange;
            this.message = message;
        }

        public void close() throws IOException {
            if (!this.written) {
                this.dispatchToService(true);
            }
            super.close();
        }

        protected void onFirstWrite() throws IOException {
            this.dispatchToService(false);
        }

        protected void dispatchToService(boolean empty) throws IOException {
            Executor ex;
            final MessageImpl inMsg = new MessageImpl();
            LocalConduit.this.transportFactory.copy(this.message, (Message)inMsg);
            if (!empty) {
                PipedInputStream stream = new PipedInputStream();
                this.wrappedStream = new PipedOutputStream(stream);
                inMsg.setContent(InputStream.class, (Object)stream);
            }
            inMsg.setDestination((Destination)LocalConduit.this.destination);
            inMsg.put(IN_CONDUIT, (Object)this.conduit);
            Runnable receiver = new Runnable(){

                @Override
                public void run() {
                    block5: {
                        ExchangeImpl ex = new ExchangeImpl();
                        ex.put(Bus.class, (Object)LocalConduit.this.destination.getBus());
                        ex.setInMessage((Message)inMsg);
                        inMsg.setExchange((Exchange)ex);
                        ex.put(IN_EXCHANGE, (Object)LocalConduitOutputStream.this.exchange);
                        try {
                            LocalConduit.this.destination.getMessageObserver().onMessage((Message)inMsg);
                        }
                        catch (Throwable t) {
                            Message m = inMsg.getExchange().getOutFaultMessage();
                            if (m == null) {
                                m = inMsg.getExchange().getOutMessage();
                            }
                            if (m == null) break block5;
                            try {
                                m.put((Object)Message.RESPONSE_CODE, (Object)500);
                                m.put((Object)Message.PROTOCOL_HEADERS, new HashMap());
                                m.getExchange().put((Object)Message.RESPONSE_CODE, (Object)500);
                                ((OutputStream)m.getContent(OutputStream.class)).close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
            };
            Executor executor = ex = this.message.getExchange() != null ? (Executor)this.message.getExchange().get(Executor.class) : null;
            if (ex == null || SynchronousExecutor.isA((Executor)ex)) {
                ex = LocalConduit.this.transportFactory.getExecutor(LocalConduit.this.destination.getBus());
                if (ex != null) {
                    ex.execute(receiver);
                } else {
                    new Thread(receiver).start();
                }
            } else {
                ex.execute(receiver);
            }
        }
    }
}

