/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl.imexp;

import io.keikai.range.impl.imexp.IndexedRGB;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPane;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetView;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetViews;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPaneState;
import org.zkoss.poi.hssf.record.FullColorExt;
import org.zkoss.poi.hssf.usermodel.HSSFCellStyle;
import org.zkoss.poi.hssf.usermodel.HSSFFont;
import org.zkoss.poi.hssf.usermodel.HSSFPalette;
import org.zkoss.poi.hssf.usermodel.HSSFSheet;
import org.zkoss.poi.hssf.usermodel.HSSFSheetHelper;
import org.zkoss.poi.hssf.usermodel.HSSFWorkbook;
import org.zkoss.poi.hssf.util.HSSFColor;
import org.zkoss.poi.hssf.util.HSSFColorExt;
import org.zkoss.poi.hssf.util.PaneInformation;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.Color;
import org.zkoss.poi.ss.usermodel.Font;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.ss.usermodel.Workbook;
import org.zkoss.poi.xssf.model.ThemesTable;
import org.zkoss.poi.xssf.usermodel.XSSFCellStyle;
import org.zkoss.poi.xssf.usermodel.XSSFColor;
import org.zkoss.poi.xssf.usermodel.XSSFFont;
import org.zkoss.poi.xssf.usermodel.XSSFSheet;
import org.zkoss.poi.xssf.usermodel.XSSFWorkbook;

public final class BookHelper {
    public static final String AUTO_COLOR = "AUTO_COLOR";
    public static final int SORT_NORMAL_DEFAULT = 0;
    public static final int SORT_TEXT_AS_NUMBERS = 1;
    public static final int SORT_HEADER_NO = 0;
    public static final int SORT_HEADER_YES = 1;

    public static int getRowFreeze(Sheet sheet) {
        if (BookHelper.isFreezePane(sheet)) {
            PaneInformation pi = sheet.getPaneInformation();
            short fr = pi != null ? pi.getHorizontalSplitPosition() : (short)0;
            return fr > 0 ? fr : (short)0;
        }
        return 0;
    }

    public static int getColumnFreeze(Sheet sheet) {
        if (BookHelper.isFreezePane(sheet)) {
            PaneInformation pi = sheet.getPaneInformation();
            short fc = pi != null ? pi.getVerticalSplitPosition() : (short)0;
            return fc > 0 ? fc : (short)0;
        }
        return 0;
    }

    public static boolean isFreezePane(Sheet sheet) {
        CTPane pane;
        if (sheet instanceof HSSFSheet) {
            return new HSSFSheetHelper((HSSFSheet)sheet).getInternalSheet().getWindowTwo().getFreezePanes();
        }
        CTWorksheet ctsheet = ((XSSFSheet)sheet).getCTWorksheet();
        CTSheetViews views = ctsheet != null ? ctsheet.getSheetViews() : null;
        List viewList = views != null ? views.getSheetViewList() : null;
        CTSheetView view = viewList != null && !viewList.isEmpty() ? (CTSheetView)viewList.get(0) : null;
        CTPane cTPane = pane = view != null ? view.getPane() : null;
        if (pane == null) {
            return false;
        }
        return pane.getState() == STPaneState.FROZEN || pane.getState() == STPaneState.FROZEN_SPLIT;
    }

    public static String getFontHTMLColor(Workbook book, Font font) {
        String colorCode = null;
        if (font instanceof XSSFFont) {
            XSSFFont f = (XSSFFont)font;
            XSSFColor color = f.getXSSFColor();
            colorCode = BookHelper.colorToHTML(book, (Color)color);
        } else {
            HSSFColor color = BookHelper.getHSSFFontColor((HSSFWorkbook)book, (HSSFFont)font);
            colorCode = BookHelper.colorToHTML(book, (Color)color);
        }
        if (AUTO_COLOR.equals(colorCode)) {
            colorCode = "#000000";
        }
        return colorCode;
    }

    private static HSSFColor getHSSFFontColor(HSSFWorkbook book, HSSFFont font) {
        short index = font.getColor() == Short.MAX_VALUE ? (short)64 : (short)font.getColor();
        HSSFPalette palette = book.getCustomPalette();
        if (palette != null) {
            return palette.getColor(index);
        }
        Map indexHash = HSSFColor.getIndexHash();
        return (HSSFColor)indexHash.get(index);
    }

    public static String colorToHTML(Workbook book, Color color) {
        if (book instanceof HSSFWorkbook) {
            return BookHelper.HSSFColorToHTML((HSSFWorkbook)book, (HSSFColor)color);
        }
        return BookHelper.XSSFColorToHTML((XSSFWorkbook)book, (XSSFColor)color);
    }

    public static String colorToBorderHTML(Workbook book, Color color) {
        String htmlColor = BookHelper.colorToHTML(book, color);
        if (AUTO_COLOR.equals(htmlColor)) {
            return "#000000";
        }
        return htmlColor;
    }

    public static String colorToForegroundHTML(Workbook book, Color color) {
        String htmlColor = BookHelper.colorToHTML(book, color);
        if (AUTO_COLOR.equals(htmlColor)) {
            return "#000000";
        }
        return htmlColor;
    }

    public static String colorToBackgroundHTML(Workbook book, Color color) {
        String htmlColor = BookHelper.colorToHTML(book, color);
        if (AUTO_COLOR.equals(htmlColor)) {
            return "#ffffff";
        }
        return htmlColor;
    }

    private static byte[] getRgbWithTint(byte[] rgb, double tint) {
        int k = rgb.length > 3 ? 1 : 0;
        byte red = rgb[k++];
        byte green = rgb[k++];
        byte blue = rgb[k++];
        double[] hsl = BookHelper.rgbToHsl(red, green, blue);
        double hue = hsl[0];
        double sat = hsl[1];
        double lum = BookHelper.tint(hsl[2], tint);
        return BookHelper.hslToRgb(hue, sat, lum);
    }

    private static double[] rgbToHsl(byte red, byte green, byte blue) {
        double r = (double)(red & 0xFF) / 255.0;
        double g = (double)(green & 0xFF) / 255.0;
        double b = (double)(blue & 0xFF) / 255.0;
        double max = Math.max(Math.max(r, g), b);
        double min = Math.min(Math.min(r, g), b);
        double h = 0.0;
        double s = 0.0;
        double l = (max + min) / 2.0;
        if (max == min) {
            s = 0.0;
            h = 0.0;
        } else {
            double d = max - min;
            double d2 = s = l > 0.5 ? d / (2.0 - max - min) : d / (max + min);
            if (max == r) {
                h = (g - b) / d + (g < b ? 6.0 : 0.0);
            } else if (max == g) {
                h = (b - r) / d + 2.0;
            } else if (max == b) {
                h = (r - g) / d + 4.0;
            }
            h /= 6.0;
        }
        return new double[]{h, s, l};
    }

    private static byte[] hslToRgb(double hue, double sat, double lum) {
        double r;
        double g;
        double b;
        if (sat == 0.0) {
            g = b = lum;
            r = b;
        } else {
            double q = lum < 0.5 ? lum * (1.0 + sat) : lum + sat - lum * sat;
            double p = 2.0 * lum - q;
            r = BookHelper.hue2rgb(p, q, hue + 0.3333333333333333);
            g = BookHelper.hue2rgb(p, q, hue);
            b = BookHelper.hue2rgb(p, q, hue - 0.3333333333333333);
        }
        byte red = (byte)(r * 255.0);
        byte green = (byte)(g * 255.0);
        byte blue = (byte)(b * 255.0);
        return new byte[]{red, green, blue};
    }

    private static double hue2rgb(double p, double q, double t) {
        if (t < 0.0) {
            t += 1.0;
        }
        if (t > 1.0) {
            t -= 1.0;
        }
        if (t < 0.16666666666666666) {
            return p + (q - p) * 6.0 * t;
        }
        if (t < 0.5) {
            return q;
        }
        if (t < 0.6666666666666666) {
            return p + (q - p) * (0.6666666666666666 - t) * 6.0;
        }
        return p;
    }

    private static double tint(double val, double tint) {
        return tint > 0.0 ? val * (1.0 - tint) + tint : val * (1.0 + tint);
    }

    private static String XSSFColorToHTML(XSSFWorkbook book, XSSFColor color) {
        if (color != null) {
            XSSFColor themecolor;
            ThemesTable theme;
            byte[] rgb;
            CTColor ctcolor = color.getCTColor();
            if (ctcolor.isSetIndexed() && (rgb = IndexedRGB.getRGB(color.getIndexed())) != null) {
                return "#" + BookHelper.toHex(rgb[0]) + BookHelper.toHex(rgb[1]) + BookHelper.toHex(rgb[2]);
            }
            if (ctcolor.isSetRgb()) {
                byte[] argb = ctcolor.isSetTint() ? BookHelper.getRgbWithTint(color.getRgb(), color.getTint()) : color.getRgb();
                return argb.length > 3 ? "#" + BookHelper.toHex(argb[1]) + BookHelper.toHex(argb[2]) + BookHelper.toHex(argb[3]) : "#" + BookHelper.toHex(argb[0]) + BookHelper.toHex(argb[1]) + BookHelper.toHex(argb[2]);
            }
            if (ctcolor.isSetTheme() && (theme = book.getTheme()) != null && (themecolor = theme.getThemeColor(color.getTheme())) != null) {
                if (ctcolor.isSetTint()) {
                    themecolor.setTint(ctcolor.getTint());
                }
                return BookHelper.XSSFColorToHTML(book, themecolor);
            }
        }
        return AUTO_COLOR;
    }

    private static String HSSFColorToHTML(HSSFWorkbook book, HSSFColor color) {
        return color == null || HSSFColor.AUTOMATIC.getInstance().equals(color) ? AUTO_COLOR : (color.isIndex() ? BookHelper.HSSFColorIndexToHTML(book, color.getIndex()) : BookHelper.HSSFColorToHTML((HSSFColorExt)color));
    }

    private static String HSSFColorToHTML(HSSFColorExt color) {
        short[] triplet = color.getTriplet();
        byte[] argb = new byte[3];
        for (int j = 0; j < 3; ++j) {
            argb[j] = (byte)triplet[j];
        }
        if (color.isTint()) {
            argb = BookHelper.getRgbWithTint(argb, color.getTint());
        }
        return "#" + BookHelper.toHex(argb[0]) + BookHelper.toHex(argb[1]) + BookHelper.toHex(argb[2]);
    }

    private static String HSSFColorIndexToHTML(HSSFWorkbook book, int index) {
        HSSFPalette palette = book.getCustomPalette();
        HSSFColor color = null;
        if (palette != null) {
            color = palette.getColor(index);
        }
        short[] triplet = null;
        if (color != null) {
            triplet = color.getTriplet();
        } else {
            Map colors = HSSFColor.getIndexHash();
            color = (HSSFColor)colors.get(index);
            if (color != null) {
                triplet = color.getTriplet();
            }
        }
        return triplet == null ? null : (HSSFColor.AUTOMATIC.getInstance().equals(color) ? AUTO_COLOR : BookHelper.tripletToHTML(triplet));
    }

    public static String toHex(int num) {
        String hex = Integer.toHexString(num &= 0xFF);
        return hex.length() == 1 ? "0" + hex : hex;
    }

    private static String tripletToHTML(short[] triplet) {
        return triplet == null ? null : "#" + BookHelper.toHex(triplet[0]) + BookHelper.toHex(triplet[1]) + BookHelper.toHex(triplet[2]);
    }

    public static void setLeftBorderColor(CellStyle style, Color color) {
        if (style instanceof HSSFCellStyle) {
            ((HSSFCellStyle)style).setLeftBorderColor((HSSFColor)color);
        } else {
            ((XSSFCellStyle)style).setLeftBorderColor((XSSFColor)color);
        }
    }

    public static void setRightBorderColor(CellStyle style, Color color) {
        if (style instanceof HSSFCellStyle) {
            ((HSSFCellStyle)style).setRightBorderColor((HSSFColor)color);
        } else {
            ((XSSFCellStyle)style).setRightBorderColor((XSSFColor)color);
        }
    }

    public static void setTopBorderColor(CellStyle style, Color color) {
        if (style instanceof HSSFCellStyle) {
            ((HSSFCellStyle)style).setTopBorderColor((HSSFColor)color);
        } else {
            ((XSSFCellStyle)style).setTopBorderColor((XSSFColor)color);
        }
    }

    public static void setBottomBorderColor(CellStyle style, Color color) {
        if (style instanceof HSSFCellStyle) {
            ((HSSFCellStyle)style).setBottomBorderColor((HSSFColor)color);
        } else {
            ((XSSFCellStyle)style).setBottomBorderColor((XSSFColor)color);
        }
    }

    public static Color HTMLToColor(Workbook book, String color) {
        if (book instanceof HSSFWorkbook) {
            return BookHelper.HTMLToHSSFColor((HSSFWorkbook)book, color);
        }
        return BookHelper.HTMLToXSSFColor((XSSFWorkbook)book, color);
    }

    private static Color HTMLToXSSFColor(XSSFWorkbook book, String color) {
        byte[] triplet = BookHelper.HTMLToTriplet(color);
        byte a = -1;
        byte r = triplet[0];
        byte g = triplet[1];
        byte b = triplet[2];
        return new XSSFColor(new byte[]{a, r, g, b});
    }

    private static Color HTMLToHSSFColor(HSSFWorkbook book, String color) {
        HSSFColor pcolor;
        byte[] triplet = BookHelper.HTMLToTriplet(color);
        byte r = triplet[0];
        byte g = triplet[1];
        byte b = triplet[2];
        short red = (short)(r & 0xFF);
        short green = (short)(g & 0xFF);
        short blue = (short)(b & 0xFF);
        HSSFPalette palette = book.getCustomPalette();
        HSSFColor hSSFColor = pcolor = palette != null ? palette.findColor(r, g, b) : null;
        if (pcolor != null) {
            return pcolor;
        }
        Hashtable colors = HSSFColor.getRgbHash();
        HSSFColor tcolor = (HSSFColor)colors.get(new short[]{red, green, blue});
        if (tcolor != null) {
            return tcolor;
        }
        try {
            HSSFColor ncolor = palette.addColor(r, g, b);
            return ncolor;
        }
        catch (RuntimeException ex) {
            FullColorExt fullColor = new FullColorExt(red, green, blue);
            return new HSSFColorExt(fullColor);
        }
    }

    private static byte[] HTMLToTriplet(String color) {
        int offset = color.charAt(0) == '#' ? 1 : 0;
        short red = Short.parseShort(color.substring(offset + 0, offset + 2), 16);
        short green = Short.parseShort(color.substring(offset + 2, offset + 4), 16);
        short blue = Short.parseShort(color.substring(offset + 4, offset + 6), 16);
        byte r = (byte)(red & 0xFF);
        byte g = (byte)(green & 0xFF);
        byte b = (byte)(blue & 0xFF);
        return new byte[]{r, g, b};
    }

    public static void setFillForegroundColor(CellStyle newCellStyle, Color xlsColor) {
        if (newCellStyle instanceof HSSFCellStyle) {
            ((HSSFCellStyle)newCellStyle).setFillForegroundColor((HSSFColor)xlsColor);
        } else {
            ((XSSFCellStyle)newCellStyle).setFillForegroundColor((XSSFColor)xlsColor);
        }
    }

    public static void setFillBackgroundColor(CellStyle newCellStyle, Color xlsColor) {
        if (newCellStyle instanceof HSSFCellStyle) {
            ((HSSFCellStyle)newCellStyle).setFillBackgroundColor((HSSFColor)xlsColor);
        } else {
            ((XSSFCellStyle)newCellStyle).setFillBackgroundColor((XSSFColor)xlsColor);
        }
    }

    public static void setFontColor(Workbook book, Font font, Color color) {
        if (font instanceof HSSFFont) {
            if (color instanceof HSSFColorExt) {
                color = ((HSSFColorExt)color).getSimilarColor(((HSSFWorkbook)book).getCustomPalette());
            }
            ((HSSFFont)font).setColor(((HSSFColor)color).getIndex());
        } else {
            ((XSSFFont)font).setColor(null);
            ((XSSFFont)font).setColor((XSSFColor)color);
        }
    }
}

