/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hpsf;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.UnexpectedException;
import org.zkoss.poi.hpsf.DocumentSummaryInformation;
import org.zkoss.poi.hpsf.HPSFRuntimeException;
import org.zkoss.poi.hpsf.MarkUnsupportedException;
import org.zkoss.poi.hpsf.MutablePropertySet;
import org.zkoss.poi.hpsf.MutableSection;
import org.zkoss.poi.hpsf.NoPropertySetStreamException;
import org.zkoss.poi.hpsf.PropertySet;
import org.zkoss.poi.hpsf.SummaryInformation;
import org.zkoss.poi.hpsf.UnexpectedPropertySetTypeException;
import org.zkoss.poi.hpsf.wellknown.SectionIDMap;

public class PropertySetFactory {
    public static PropertySet create(InputStream stream) throws NoPropertySetStreamException, MarkUnsupportedException, UnsupportedEncodingException, IOException {
        PropertySet ps = new PropertySet(stream);
        try {
            if (ps.isSummaryInformation()) {
                return new SummaryInformation(ps);
            }
            if (ps.isDocumentSummaryInformation()) {
                return new DocumentSummaryInformation(ps);
            }
            return ps;
        }
        catch (UnexpectedPropertySetTypeException ex) {
            throw new UnexpectedException(ex.toString());
        }
    }

    public static SummaryInformation newSummaryInformation() {
        MutablePropertySet ps = new MutablePropertySet();
        MutableSection s = (MutableSection)ps.getFirstSection();
        s.setFormatID(SectionIDMap.SUMMARY_INFORMATION_ID);
        try {
            return new SummaryInformation((PropertySet)ps);
        }
        catch (UnexpectedPropertySetTypeException ex) {
            throw new HPSFRuntimeException(ex);
        }
    }

    public static DocumentSummaryInformation newDocumentSummaryInformation() {
        MutablePropertySet ps = new MutablePropertySet();
        MutableSection s = (MutableSection)ps.getFirstSection();
        s.setFormatID(SectionIDMap.DOCUMENT_SUMMARY_INFORMATION_ID[0]);
        try {
            return new DocumentSummaryInformation((PropertySet)ps);
        }
        catch (UnexpectedPropertySetTypeException ex) {
            throw new HPSFRuntimeException(ex);
        }
    }
}

