/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import javax.annotation.Nonnull;

public class MapTransform<T, R>
extends AbstractTransform {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private FunctionEx<? super T, ? extends R> mapFn;

    public MapTransform(@Nonnull String name, @Nonnull Transform upstream, @Nonnull FunctionEx<? super T, ? extends R> mapFn) {
        super(name, upstream);
        this.mapFn = mapFn;
    }

    public FunctionEx<? super T, ? extends R> mapFn() {
        return this.mapFn;
    }

    @Override
    public void addToDag(Planner p, PipelineImpl.Context context) {
        this.determineLocalParallelism(-1, context, p.isPreserveOrder());
        Planner.PlannerVertex pv = p.addVertex((Transform)this, this.name(), this.determinedLocalParallelism(), Processors.mapP(this.mapFn()));
        if (p.isPreserveOrder()) {
            p.addEdges((Transform)this, pv.v, Edge::isolated);
        } else {
            p.addEdges(this, pv.v);
        }
    }
}

