/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.tpc;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.annotation.Beta;
import java.util.Objects;
import javax.annotation.Nonnull;

@Beta
public class TpcSocketConfig {
    public static final int DEFAULT_RECEIVE_BUFFER_SIZE_KB = 128;
    public static final int DEFAULT_SEND_BUFFER_SIZE_KB = 128;
    private String portRange = "11000-21000";
    private int receiveBufferSizeKB = 128;
    private int sendBufferSizeKB = 128;

    @Nonnull
    public String getPortRange() {
        return this.portRange;
    }

    @Nonnull
    public TpcSocketConfig setPortRange(@Nonnull String portRange) {
        Preconditions.checkNotNull(portRange);
        if (!portRange.matches("\\d{1,5}-\\d{1,5}")) {
            throw new IllegalArgumentException("Invalid port range");
        }
        this.portRange = portRange;
        return this;
    }

    public int getReceiveBufferSizeKB() {
        return this.receiveBufferSizeKB;
    }

    @Nonnull
    public TpcSocketConfig setReceiveBufferSizeKB(int receiveBufferSizeKB) {
        this.receiveBufferSizeKB = Preconditions.checkPositive("receiveBufferSizeKB", receiveBufferSizeKB);
        return this;
    }

    public int getSendBufferSizeKB() {
        return this.sendBufferSizeKB;
    }

    @Nonnull
    public TpcSocketConfig setSendBufferSizeKB(int sendBufferSizeKB) {
        this.sendBufferSizeKB = Preconditions.checkPositive("sendBufferSizeKB", sendBufferSizeKB);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TpcSocketConfig that = (TpcSocketConfig)o;
        return this.receiveBufferSizeKB == that.receiveBufferSizeKB && this.sendBufferSizeKB == that.sendBufferSizeKB && this.portRange.equals(that.portRange);
    }

    public int hashCode() {
        return Objects.hash(this.portRange, this.receiveBufferSizeKB, this.sendBufferSizeKB);
    }

    public String toString() {
        return "TpcSocketConfig{portRange='" + this.portRange + '\'' + ", receiveBufferSizeKB=" + this.receiveBufferSizeKB + ", sendBufferSizeKB=" + this.sendBufferSizeKB + '}';
    }
}

