/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.compiere.model.Query;
import org.compiere.model.X_AD_UserDef_Info;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MUserDefInfo
extends X_AD_UserDef_Info {
    private static final long serialVersionUID = 5611033457579880793L;
    private static final Map<Integer, List<MUserDefInfo>> m_fullMap = new ConcurrentHashMap<Integer, List<MUserDefInfo>>();
    private static CCache<String, MUserDefInfo> s_cache = new CCache("AD_UserDef_Info", 3);

    public MUserDefInfo(Properties ctx, String AD_UserDef_Info_UU, String trxName) {
        super(ctx, AD_UserDef_Info_UU, trxName);
    }

    public MUserDefInfo(Properties ctx, int AD_UserDef_Info_ID, String trxName) {
        super(ctx, AD_UserDef_Info_ID, trxName);
    }

    public MUserDefInfo(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private static MUserDefInfo[] getAll(Properties ctx, int infowindow_ID) {
        List<MUserDefInfo> fullList = null;
        fullList = m_fullMap.get(Env.getAD_Client_ID(ctx));
        if (fullList == null) {
            fullList = new Query(ctx, "AD_UserDef_Info", null, null).setOnlyActiveRecords(true).setClient_ID().list();
            m_fullMap.put(Env.getAD_Client_ID(ctx), fullList);
        }
        if (fullList.size() == 0) {
            return null;
        }
        ArrayList<MUserDefInfo> list = new ArrayList<MUserDefInfo>();
        for (MUserDefInfo udw : fullList) {
            if (udw.getAD_InfoWindow_ID() != infowindow_ID || udw.getAD_Client_ID() != Env.getAD_Client_ID(ctx) || udw.getAD_Language() != null && !udw.getAD_Language().equals(Env.getAD_Language(ctx))) continue;
            list.add(udw);
        }
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new MUserDefInfo[list.size()]);
    }

    public static MUserDefInfo getBestMatch(Properties ctx, int infowindow_ID) {
        int AD_Org_ID = Env.getAD_Org_ID(ctx);
        int AD_Role_ID = Env.getAD_Role_ID(ctx);
        int AD_User_ID = Env.getAD_User_ID(ctx);
        String key = infowindow_ID + "_" + Env.getAD_Client_ID(ctx) + "_" + Env.getAD_Language(ctx) + "_" + AD_Org_ID + "_" + AD_Role_ID + "_" + AD_User_ID;
        if (s_cache.containsKey(key)) {
            return s_cache.get(key);
        }
        MUserDefInfo[] candidates = MUserDefInfo.getAll(ctx, infowindow_ID);
        if (candidates == null) {
            s_cache.put(key, null);
            return null;
        }
        int size = candidates.length;
        int[] weight = new int[size];
        int i2 = 0;
        while (i2 < size) {
            weight[i2] = 0;
            if (candidates[i2].getAD_User_ID() > 0) {
                weight[i2] = candidates[i2].getAD_User_ID() == AD_User_ID ? weight[i2] + 4 : -1;
            }
            if (weight[i2] > -1 && candidates[i2].getAD_Role_ID() > 0) {
                weight[i2] = candidates[i2].getAD_Role_ID() == AD_Role_ID ? weight[i2] + 2 : -1;
            }
            if (weight[i2] > -1 && candidates[i2].getAD_Org_ID() > 0) {
                weight[i2] = candidates[i2].getAD_Org_ID() == AD_Org_ID ? weight[i2] + 1 : -1;
            }
            if (weight[i2] > -1 && !Util.isEmpty(candidates[i2].getAD_Language())) {
                weight[i2] = Env.getAD_Language(ctx).equalsIgnoreCase(candidates[i2].getAD_Language()) ? weight[i2] + 8 : -1;
            }
            ++i2;
        }
        int maximum = weight[0];
        int maxindex = 0;
        int j = 0;
        while (j < weight.length) {
            if (weight[j] > maximum) {
                maximum = weight[j];
                maxindex = j;
            }
            ++j;
        }
        if (weight[maxindex] > -1) {
            MUserDefInfo retValue = null;
            retValue = candidates[maxindex];
            s_cache.put(key, retValue);
            return retValue;
        }
        s_cache.put(key, null);
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        m_fullMap.remove(this.getAD_Client_ID());
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        m_fullMap.remove(this.getAD_Client_ID());
        return true;
    }
}

