/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.format;

import java.util.Locale;
import org.zkoss.poi.ss.format.CellDateFormatter;
import org.zkoss.poi.ss.format.CellElapsedFormatter;
import org.zkoss.poi.ss.format.CellFormatter;
import org.zkoss.poi.ss.format.CellGeneralFormatter;
import org.zkoss.poi.ss.format.CellNumberFormatter;
import org.zkoss.poi.ss.format.CellTextFormatter;

public enum CellFormatType {
    GENERAL{

        @Override
        CellFormatter formatter(String pattern, Locale locale) {
            return new CellGeneralFormatter(locale);
        }

        @Override
        boolean isSpecial(char ch) {
            return false;
        }
    }
    ,
    NUMBER{

        @Override
        boolean isSpecial(char ch) {
            return false;
        }

        @Override
        CellFormatter formatter(String pattern, Locale locale) {
            return new CellNumberFormatter(pattern, locale);
        }
    }
    ,
    DATE{

        @Override
        boolean isSpecial(char ch) {
            return ch == '\'' || ch <= '\u007f' && Character.isLetter(ch);
        }

        @Override
        CellFormatter formatter(String pattern, Locale locale) {
            return new CellDateFormatter(pattern, locale);
        }
    }
    ,
    ELAPSED{

        @Override
        boolean isSpecial(char ch) {
            return false;
        }

        @Override
        CellFormatter formatter(String pattern, Locale locale) {
            return new CellElapsedFormatter(pattern, locale);
        }
    }
    ,
    TEXT{

        @Override
        boolean isSpecial(char ch) {
            return false;
        }

        @Override
        CellFormatter formatter(String pattern, Locale locale) {
            return new CellTextFormatter(pattern, locale);
        }
    };


    abstract boolean isSpecial(char var1);

    abstract CellFormatter formatter(String var1, Locale var2);
}

