/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hwpf.model;

import java.util.Collections;
import org.zkoss.poi.hwpf.model.CHPBinTable;
import org.zkoss.poi.hwpf.model.CHPFormattedDiskPage;
import org.zkoss.poi.hwpf.model.CHPX;
import org.zkoss.poi.hwpf.model.GenericPropertyNode;
import org.zkoss.poi.hwpf.model.PlexOfCps;
import org.zkoss.poi.hwpf.model.PropertyNode;
import org.zkoss.poi.hwpf.model.TextPieceTable;
import org.zkoss.poi.util.Internal;
import org.zkoss.poi.util.LittleEndian;

@Internal
public final class OldCHPBinTable
extends CHPBinTable {
    public OldCHPBinTable(byte[] documentStream, int offset, int size, int fcMin, TextPieceTable tpt) {
        PlexOfCps binTable = new PlexOfCps(documentStream, offset, size, 2);
        int length = binTable.length();
        for (int x = 0; x < length; ++x) {
            GenericPropertyNode node = binTable.getProperty(x);
            int pageNum = LittleEndian.getUShort(node.getBytes());
            int pageOffset = 512 * pageNum;
            CHPFormattedDiskPage cfkp = new CHPFormattedDiskPage(documentStream, pageOffset, tpt);
            for (CHPX chpx : cfkp.getCHPXs()) {
                if (chpx == null) continue;
                this._textRuns.add(chpx);
            }
        }
        Collections.sort(this._textRuns, PropertyNode.StartComparator.instance);
    }
}

