/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.util;

public class CrcUtil {
    private static int[] _cache;

    public static int calcCRC(int crc, byte[] bytes, int start, int len) {
        CrcUtil.initCRCCache();
        for (int j = 0; j < len; ++j) {
            byte b = bytes[j + start];
            crc = CrcUtil.calcCRC(crc, b);
        }
        return crc;
    }

    public static int calcCRC(int crc, byte b) {
        int index = crc >>> 24;
        crc <<= 8;
        return crc ^= _cache[index ^= b & 0xFF];
    }

    private static void initCRCCache() {
        if (_cache != null) {
            return;
        }
        _cache = new int[256];
        for (int j = 0; j < 256; ++j) {
            int value = j << 24;
            for (int bit = 0; bit < 8; ++bit) {
                if ((value & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                    value <<= 1;
                    value ^= 0xAF;
                    continue;
                }
                value <<= 1;
            }
            CrcUtil._cache[j] = value &= 0xFFFF;
        }
    }
}

