/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl;

import io.keikai.model.CellStyleHolder;
import io.keikai.model.InvalidModelOpException;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SColumn;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.range.SRange;
import io.keikai.range.impl.StyleUtil;
import java.util.HashSet;
import java.util.Iterator;

public class WholeStyleUtil {
    public static void setWholeStyle(SRange range, StyleApplyer applyer) {
        if (range.isWholeSheet()) {
            throw new InvalidModelOpException("don't allow to set style to whole sheet");
        }
        if (range.isWholeRow()) {
            WholeStyleUtil.setWholeRowCellStyle(range, applyer);
        } else if (range.isWholeColumn()) {
            WholeStyleUtil.setWholeColumnCellStyle(range, applyer);
        } else {
            for (int r = range.getRow(); r <= range.getLastRow(); ++r) {
                for (int c = range.getColumn(); c <= range.getLastColumn(); ++c) {
                    SCell cell = range.getSheet().getCell(r, c);
                    applyer.applyStyle(cell);
                }
            }
        }
    }

    public static void setWholeRowCellStyle(SRange range, StyleApplyer applyer) {
        SSheet sheet = range.getSheet();
        for (int r = range.getRow(); r <= range.getLastRow(); ++r) {
            SRow row = sheet.getRow(r);
            applyer.applyStyle(row);
            HashSet<Integer> cellProcessed = new HashSet<Integer>();
            Iterator<SCell> cells = sheet.getCellIterator(r);
            while (cells.hasNext()) {
                SCell cell = cells.next();
                if (cell.getCellStyle(true) != null || sheet.getColumn(cell.getColumnIndex()).getCellStyle(true) != null) {
                    applyer.applyStyle(cell);
                }
                cellProcessed.add(cell.getColumnIndex());
            }
            Iterator<SColumn> columns = sheet.getColumnIterator();
            while (columns.hasNext()) {
                SColumn column = columns.next();
                if (cellProcessed.contains(column.getIndex()) || column.getCellStyle(true) == null) continue;
                applyer.applyStyle(sheet.getCell(r, column.getIndex()));
            }
        }
    }

    public static void setWholeColumnCellStyle(SRange range, StyleApplyer applyer) {
        SSheet sheet = range.getSheet();
        for (int c = range.getColumn(); c <= range.getLastColumn(); ++c) {
            SColumn column = sheet.getColumn(c);
            applyer.applyStyle(column);
        }
        Iterator<SRow> rows = sheet.getRowIterator();
        while (rows.hasNext()) {
            SRow row = rows.next();
            for (int c = range.getColumn(); c <= range.getLastColumn(); ++c) {
                SCell cell = sheet.getCell(row.getIndex(), c);
                if (cell.getCellStyle(true) == null && row.getCellStyle(true) == null) continue;
                applyer.applyStyle(cell);
            }
        }
    }

    public static void setFillColor(final SRange wholeRange, final String htmlColor) {
        WholeStyleUtil.setWholeStyle(wholeRange, new StyleApplyer(){

            @Override
            public void applyStyle(CellStyleHolder holder) {
                StyleUtil.setFillColor(wholeRange.getSheet().getBook(), holder, htmlColor);
            }
        });
    }

    public static void setFillOptions(final SRange wholeRange, final String backColor, final String fillColor, final SFill.FillPattern pattern) {
        WholeStyleUtil.setWholeStyle(wholeRange, new StyleApplyer(){

            @Override
            public void applyStyle(CellStyleHolder holder) {
                StyleUtil.setFillOptions(wholeRange.getSheet().getBook(), holder, backColor, fillColor, pattern);
            }
        });
    }

    public static void setBackColor(final SRange wholeRange, final String htmlColor) {
        WholeStyleUtil.setWholeStyle(wholeRange, new StyleApplyer(){

            @Override
            public void applyStyle(CellStyleHolder holder) {
                StyleUtil.setBackColor(wholeRange.getSheet().getBook(), holder, htmlColor);
            }
        });
    }

    public static void setTextHAlign(final SRange wholeRange, final SCellStyle.Alignment hAlignment) {
        WholeStyleUtil.setWholeStyle(wholeRange, new StyleApplyer(){

            @Override
            public void applyStyle(CellStyleHolder holder) {
                StyleUtil.setTextHAlign(wholeRange.getSheet().getBook(), holder, hAlignment);
            }
        });
    }

    public static void setTextVAlign(final SRange wholeRange, final SCellStyle.VerticalAlignment vAlignment) {
        WholeStyleUtil.setWholeStyle(wholeRange, new StyleApplyer(){

            @Override
            public void applyStyle(CellStyleHolder holder) {
                StyleUtil.setTextVAlign(wholeRange.getSheet().getBook(), holder, vAlignment);
            }
        });
    }

    public static void setTextWrap(final SRange wholeRange, final boolean wraptext) {
        WholeStyleUtil.setWholeStyle(wholeRange, new StyleApplyer(){

            @Override
            public void applyStyle(CellStyleHolder holder) {
                StyleUtil.setTextWrap(wholeRange.getSheet().getBook(), holder, wraptext);
            }
        });
    }

    public static void setDataFormat(final SRange wholeRange, final String format) {
        WholeStyleUtil.setWholeStyle(wholeRange, new StyleApplyer(){

            @Override
            public void applyStyle(CellStyleHolder holder) {
                StyleUtil.setDataFormat(wholeRange.getSheet().getBook(), holder, format);
            }
        });
    }

    public static void setFontName(final SRange wholeRange, final String fontName) {
        WholeStyleUtil.setWholeStyle(wholeRange, new StyleApplyer(){

            @Override
            public void applyStyle(CellStyleHolder holder) {
                StyleUtil.setFontName(wholeRange.getSheet().getBook(), holder, fontName);
            }
        });
    }

    public static void setFontHeightPoints(final SRange wholeRange, final int fontHeightPoints) {
        WholeStyleUtil.setWholeStyle(wholeRange, new StyleApplyer(){

            @Override
            public void applyStyle(CellStyleHolder holder) {
                StyleUtil.setFontHeightPoints(wholeRange.getSheet().getBook(), holder, fontHeightPoints);
            }
        });
    }

    public static void setFontBoldWeight(final SRange wholeRange, final SFont.Boldweight fontBoldweight) {
        WholeStyleUtil.setWholeStyle(wholeRange, new StyleApplyer(){

            @Override
            public void applyStyle(CellStyleHolder holder) {
                StyleUtil.setFontBoldWeight(wholeRange.getSheet().getBook(), holder, fontBoldweight);
            }
        });
    }

    public static void setFontItalic(final SRange wholeRange, final boolean italic) {
        WholeStyleUtil.setWholeStyle(wholeRange, new StyleApplyer(){

            @Override
            public void applyStyle(CellStyleHolder holder) {
                StyleUtil.setFontItalic(wholeRange.getSheet().getBook(), holder, italic);
            }
        });
    }

    public static void setFontStrikethrough(final SRange wholeRange, final boolean strikeout) {
        WholeStyleUtil.setWholeStyle(wholeRange, new StyleApplyer(){

            @Override
            public void applyStyle(CellStyleHolder holder) {
                StyleUtil.setFontStrikethrough(wholeRange.getSheet().getBook(), holder, strikeout);
            }
        });
    }

    public static void setFontUnderline(final SRange wholeRange, final SFont.Underline fontUnderline) {
        WholeStyleUtil.setWholeStyle(wholeRange, new StyleApplyer(){

            @Override
            public void applyStyle(CellStyleHolder holder) {
                StyleUtil.setFontUnderline(wholeRange.getSheet().getBook(), holder, fontUnderline);
            }
        });
    }

    public static void setFontColor(final SRange wholeRange, final String htmlColor) {
        WholeStyleUtil.setWholeStyle(wholeRange, new StyleApplyer(){

            @Override
            public void applyStyle(CellStyleHolder holder) {
                StyleUtil.setFontColor(wholeRange.getSheet().getBook(), holder, htmlColor);
            }
        });
    }

    public static void setFontTypeOffset(final SRange wholeRange, final SFont.TypeOffset fontTypeOffset) {
        WholeStyleUtil.setWholeStyle(wholeRange, new StyleApplyer(){

            @Override
            public void applyStyle(CellStyleHolder holder) {
                StyleUtil.setFontTypeOffset(wholeRange.getSheet().getBook(), holder, fontTypeOffset);
            }
        });
    }

    public static void setTextRotation(final SRange wholeRange, final int rotation) {
        WholeStyleUtil.setWholeStyle(wholeRange, new StyleApplyer(){

            @Override
            public void applyStyle(CellStyleHolder holder) {
                StyleUtil.setTextRotation(wholeRange.getSheet().getBook(), holder, rotation);
            }
        });
    }

    public static void setTextIndentionOffset(final SRange wholeRange, final int offset) {
        WholeStyleUtil.setWholeStyle(wholeRange, new StyleApplyer(){

            @Override
            public void applyStyle(CellStyleHolder holder) {
                StyleUtil.setTextIndentionOffset(wholeRange.getSheet().getBook(), holder, offset);
            }
        });
    }

    public static void setTextIndention(final SRange wholeRange, final int indention) {
        WholeStyleUtil.setWholeStyle(wholeRange, new StyleApplyer(){

            @Override
            public void applyStyle(CellStyleHolder holder) {
                StyleUtil.setTextIndention(wholeRange.getSheet().getBook(), holder, indention);
            }
        });
    }

    public static interface StyleApplyer {
        public void applyStyle(CellStyleHolder var1);
    }
}

