


zss.ScrollPanel = zk.$extends(zk.Object, {
	
	dir: 'south',
	$init: function (sheet) {
		this.$supers('$init', []);
		var wgt = sheet._wgt,
			scrollPanel = sheet.$n('sp');
		
		this.id = scrollPanel.id;
		this.sheet = sheet;
		this.comp = scrollPanel;
		this.currentTop = this.currentLeft = this.timerCount = 0;
		this.leftWidth = 28;
		this.topHeight = 20;
		this.timerRunning = false;
		this.lastMove = "";
		scrollPanel.ctrl = this;
		
		var dtcmp = this.sheet.dp.comp,
			sccmp = this.comp;
		this.minLeft = this._getMaxScrollLeft(dtcmp, sccmp);
		this.minTop = this._getMaxScrollTop(dtcmp, sccmp);
		this.minHeight = dtcmp.offsetHeight;
		this.minWidth = dtcmp.offsetWidth;
		wgt.domListen_(scrollPanel, 'onScroll', this.proxy(this._doScrolling))
			.domListen_(scrollPanel, 'onMouseDown', this.proxy(this._doMousedown));
		
		jq(sheet.cp.$n()).on('mousewheel', this.proxy(this._doMouseWheel));
		jq(sheet.lp.$n()).on('mousewheel', this.proxy(this._doMouseWheel));
		jq(sheet.tp.$n()).on('mousewheel', this.proxy(this._doMouseWheel));
	},
	
	getDirection: function () {
		return this.dir;
	},
	reset: function (top, left) {
		var n = this.comp;
		n.scrollLeft = left;
		n.scrollTop = top;
		this.currentTop = top;
		this.currentLeft = left;
	},
	
	_resetIE9ScrollPosition: function () {
		if (this._visFlg) return; 
		
		var spcmp = this.comp,
			sl = spcmp.scrollLeft,
			st = spcmp.scrollTop,
			sl0 = this.currentLeft,
			st0 = this.currentTop;
		if (sl == 0 && st == 0 && (sl != sl0 || st != st0))
			this.reset(st0, sl0);
	},
	cleanup: function () {
		var sheet = this.sheet,
			wgt = sheet._wgt,
			n = sheet.$n('sp');
		
		jq(sheet.tp.$n()).off('mousewheel', this.proxy(this._doMouseWheel));
		jq(sheet.lp.$n()).off('mousewheel', this.proxy(this._doMouseWheel));
		jq(sheet.cp.$n()).off('mousewheel', this.proxy(this._doMouseWheel));
		
		wgt.domUnlisten_(n, 'onScroll', this.proxy(this._doScrolling))
			.domUnlisten_(n, 'onMouseDown', this.proxy(this._doMousedown));
		
		this.invalid = true;
		if(this.comp) this.comp.ctrl = null;
		this.comp = this.sheet = null;
	},
	
	_doMouseWheel: function (evt) {
		var event = evt.originalEvent,
			deltaX = event.wheelDeltaX,
			deltaY = event.wheelDeltaY ? event.wheelDeltaY / 120 : event.wheelDelta ? event.wheelDelta / 120 : -event.detail / 3,
			scrollPanel = jq(this.comp);
				
		if(deltaY && deltaY != 0)
			scrollPanel.scrollTop(scrollPanel.scrollTop() - (deltaY * 100));
		
		
		if(deltaX && deltaX != 0)
			scrollPanel.scrollLeft(scrollPanel.scrollLeft() - (deltaX / 120 * 100));
	},
	_doMousedown: function (evt) {
		var cmp = this.comp;
		if(evt.domTarget != cmp) return;
		var data = zkS._getMouseData(evt, cmp);
		
		
		var clickInHor = (data[1] < zk(cmp).offsetHeight() && data[1] > cmp.clientHeight);
			clickInVer = (data[0] < zk(cmp).offsetWidth() && data[0] > cmp.clientWidth);
		
		if( (clickInHor&&clickInVer) || (!clickInHor&&!clickInVer)) return;
		var sinfo = this.sheet.sinfo;
		sinfo.pinXY(data[0], data[1], clickInHor);
	},
	_doScrolling: function (evt) {
		
		
		if (!evt && zk.ie && zk.ie == 9) {
			this._resetIE9ScrollPosition();
		}
		var sheet = this.sheet,
			dtcmp = sheet.dp.comp,
			sccmp = this.comp,
			scleft = sccmp.scrollLeft,
			sctop = sccmp.scrollTop,
			moveHorizontal = (scleft != this.currentLeft),
			moveVertical = (sctop != this.currentTop),
			moveLeft = scleft < this.currentLeft,
			moveTop = sctop < this.currentTop;
		
		if (moveHorizontal) {
			this.dir = moveLeft ? 'west' : 'east';
		} else {
			this.dir = moveTop ? 'north' : 'south';
		}
		this.currentLeft = scleft;
		this.currentTop = sctop;
		sheet.tp._updateLeftPos(-this.currentLeft);
		sheet.lp._updateTopPos(-this.currentTop);
		if (this._visFlg) {
			
			this._visFlg = false;
		} else {
			
			var sinfo = sheet.sinfo;
			if (moveHorizontal) {
				if (!sinfo.visible || !sinfo.horizontal)
					sinfo.pinLocation(true);
				sinfo.showInfoOnDir(true);
			}
			
			if (moveVertical) {
				if (!sinfo.visible || sinfo.horizontal)
					sinfo.pinLocation(false);
				sinfo.showInfoOnDir(false);
			}
			if (moveVertical || moveHorizontal)
				this._trackScrolling(moveVertical);
		}
	},
	_trackScrolling: function (vertical) {
		if (vertical)
			this._fireOnVScroll();
		else
			this._fireOnHScroll();
	},
	_vscrollTimeoutId: null,
	_hscrollTimeoutId: null,
	_fireOnVScroll: function (time) {
		clearTimeout(this._vscrollTimeoutId);
		
		
		var self = this;
		this._vscrollTimeoutId = setTimeout(function () {
			self._doVScroll();
		}, time >= 0 ? time : 60);
	},
	_fireOnHScroll: function (time) {
		clearTimeout(this._hscrollTimeoutId);
		
		
		var self = this;
		this._vscrollTimeoutId = setTimeout(function () {
			self._doHScroll();
		}, time >= 0 ? time : 60);
	},
	_doVScroll: function () {
		this._doScroll(true);
	},
	_doHScroll: function () {
		this._doScroll(false);
	},
	_doScroll: function (vertical) {
		this.sheet.activeBlock.doScroll(vertical);
	},
	_getMaxScrollLeft: function (dtcmp, sccmp) {
		return (dtcmp.offsetWidth - sccmp.offsetWidth) + zss.Spreadsheet.scrollWidth;
	},
	_getMaxScrollTop: function (dtcmp, sccmp) {
		return (dtcmp.offsetHeight - sccmp.offsetHeight) + zss.Spreadsheet.scrollWidth;
	},
	
	scrollToVisible: function (row, col, cell, direction, pos) { 
																
		
		if(direction == undefined || direction == null) {
			direction = zss.SCROLL_DIR.BOTH; 
		}

		if (!pos) {
			pos = zss.SCROLL_POS.NONE;
		}
		
		
		
		var sheet = this.sheet;
		if (cell) {
			row = cell.r;
		    col = cell.c;
		}
		var cellLoc = this._getCellLocation(sheet,row,col);
		
		var spcmp = this.comp,
			block = sheet.activeBlock,
			w = cellLoc.width,
			h = cellLoc.height,
			l = cellLoc.left + sheet.leftWidth,
			t = cellLoc.top + sheet.topHeight,
			sl = spcmp.scrollLeft,
			st = spcmp.scrollTop,
			sw = spcmp.clientWidth,
			sh = spcmp.clientHeight,
			th = sheet.topHeight, 
			lw = sheet.leftWidth, 
			lsl = sl, 
			lst = st, 
			dirty = false,
			fzr = sheet.frozenRow, 
			fzc = sheet.frozenCol,
			fh = 0,
			fw = 0;
		
		
		var moveonfr = moveonfc = false;
		 
		if (zkS.t(col) && fzc > -1) {
			if (fzc < col)
				fw = sheet.custColWidth.getStartPixel(fzc + 1);
			else
				moveonfc = true;
		}
	
		if (zkS.t(row) && fzr > -1) {
			if (fzr < row)
				fh = sheet.custRowHeight.getStartPixel(fzr + 1);
			else
				moveonfr = true;
		}
		
		
		
		if (zkS.t(col) && !moveonfc) {
			
			if (( (sw - lw) < (w - fw)) || (l-lw) < (sl+fw) ) {  
				lsl = l-lw - fw;
				dirty = true;
			 } else if(sl + sw < l + w) {
				lsl = l + w - sw;
				dirty = true;
			}
		}
		if (zkS.t(row) && !moveonfr) {
			if (((sh - th < h - fh || t - th < st + fh) && pos != zss.SCROLL_POS.BOTTOM) ||
				pos == zss.SCROLL_POS.TOP) { 
				lst = t-th - fh;
				dirty = true;
			} else if (st + sh < t + h || pos == zss.SCROLL_POS.BOTTOM) {
				lst = t+h - sh;
				dirty = true;
			}
		}

		if (dirty) {
			this._visFlg = true;

			
			switch(direction) {
			case zss.SCROLL_DIR.HORIZONTAL :
					spcmp.scrollLeft = lsl;
					break;
			case zss.SCROLL_DIR.VERTICAL :
					spcmp.scrollTop = lst;
					break;
			case zss.SCROLL_DIR.BOTH :
					spcmp.scrollLeft = lsl;
					spcmp.scrollTop = lst;
					break;
			}
			
		}
	},
	_getCellLocation : function(sheet, row, column){
		var loc = {};
		loc.left = sheet.custColWidth.getStartPixel(column);
		loc.width = sheet.custColWidth.getSize(column);
		loc.top = sheet.custRowHeight.getStartPixel(row);
		loc.height = sheet.custRowHeight.getSize(row);
		return loc;
	}
});