/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hwpf.extractor;

import java.io.IOException;
import java.io.InputStream;
import org.zkoss.poi.POIOLE2TextExtractor;
import org.zkoss.poi.hwpf.HWPFOldDocument;
import org.zkoss.poi.hwpf.converter.WordToTextConverter;
import org.zkoss.poi.hwpf.extractor.WordExtractor;
import org.zkoss.poi.hwpf.usermodel.Range;
import org.zkoss.poi.poifs.filesystem.DirectoryNode;
import org.zkoss.poi.poifs.filesystem.POIFSFileSystem;

public final class Word6Extractor
extends POIOLE2TextExtractor {
    private POIFSFileSystem fs;
    private HWPFOldDocument doc;

    public Word6Extractor(InputStream is) throws IOException {
        this(new POIFSFileSystem(is));
    }

    public Word6Extractor(POIFSFileSystem fs) throws IOException {
        this(fs.getRoot());
    }

    @Deprecated
    public Word6Extractor(DirectoryNode dir, POIFSFileSystem fs) throws IOException {
        this(dir);
    }

    public Word6Extractor(DirectoryNode dir) throws IOException {
        this(new HWPFOldDocument(dir));
    }

    public Word6Extractor(HWPFOldDocument doc) {
        super(doc);
        this.doc = doc;
    }

    @Deprecated
    public String[] getParagraphText() {
        String[] ret;
        try {
            Range r = this.doc.getRange();
            ret = WordExtractor.getParagraphText(r);
        }
        catch (Exception e) {
            ret = new String[this.doc.getTextTable().getTextPieces().size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.doc.getTextTable().getTextPieces().get(i).getStringBuilder().toString();
                ret[i].replaceAll("\r", "\ufffe");
                ret[i].replaceAll("\ufffe", "\r\n");
            }
        }
        return ret;
    }

    @Override
    public String getText() {
        try {
            WordToTextConverter wordToTextConverter = new WordToTextConverter();
            wordToTextConverter.processDocument(this.doc);
            return wordToTextConverter.getText();
        }
        catch (Exception exc) {
            StringBuffer text = new StringBuffer();
            for (String t : this.getParagraphText()) {
                text.append(t);
            }
            return text.toString();
        }
    }
}

