/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hsmf.datatypes;

import java.util.Calendar;
import java.util.TimeZone;
import org.zkoss.poi.hsmf.datatypes.MAPIProperty;
import org.zkoss.poi.util.LittleEndian;

public class PropertyValue {
    private MAPIProperty property;
    private long flags;
    protected byte[] data;

    public PropertyValue(MAPIProperty property, long flags, byte[] data) {
        this.property = property;
        this.flags = flags;
        this.data = data;
    }

    public MAPIProperty getProperty() {
        return this.property;
    }

    public long getFlags() {
        return this.flags;
    }

    public Object getValue() {
        return this.data;
    }

    public void setRawValue(byte[] value) {
        this.data = value;
    }

    public String toString() {
        return this.property + " = " + this.getValue();
    }

    public static class TimePropertyValue
    extends PropertyValue {
        private static final long OFFSET = 11644473600000L;

        public TimePropertyValue(MAPIProperty property, long flags, byte[] data) {
            super(property, flags, data);
        }

        @Override
        public Calendar getValue() {
            long time = LittleEndian.getLong(this.data);
            time = time / 10L / 1000L - 11644473600000L;
            Calendar timeC = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            timeC.setTimeInMillis(time);
            return timeC;
        }

        public void setValue(Calendar value) {
            if (this.data.length != 8) {
                this.data = new byte[8];
            }
            long time = value.getTimeInMillis();
            time = (time + 11644473600000L) * 10L * 1000L;
            LittleEndian.putLong(this.data, 0, time);
        }
    }

    public static class LongLongPropertyValue
    extends PropertyValue {
        public LongLongPropertyValue(MAPIProperty property, long flags, byte[] data) {
            super(property, flags, data);
        }

        @Override
        public Long getValue() {
            return LittleEndian.getLong(this.data);
        }

        public void setValue(long value) {
            if (this.data.length != 8) {
                this.data = new byte[8];
            }
            LittleEndian.putLong(this.data, 0, value);
        }
    }
}

