/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.undo;

import io.keikai.api.AreaRef;
import io.keikai.api.CellOperationUtil;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.impl.RangeImpl;
import io.keikai.api.model.EditableCellStyle;
import io.keikai.api.model.Sheet;
import io.keikai.model.CellRegion;
import io.keikai.range.SRange;
import io.keikai.range.impl.PasteRangeImpl;
import io.keikai.ui.impl.undo.AbstractCellDataStyleAction;

public class PasteCellAction
extends AbstractCellDataStyleAction {
    private static final long serialVersionUID = 603418025542199316L;
    protected final int _destRow;
    protected final int _destColumn;
    protected final int _destLastRow;
    protected final int _destLastColumn;
    protected final int _reservedDestLastRow;
    protected final int _reservedDestLastColumn;
    protected final Sheet _destSheet;
    protected final boolean _destWholeColumn;
    protected final boolean _destWholeRow;
    private Range _pastedRange;

    public PasteCellAction(String label, Sheet sheet, int srcRow, int srcColumn, int srcLastRow, int srcLastColumn, boolean srcWholeColumn, boolean srcWholeRow, Sheet destSheet, int destRow, int destColumn, int destLastRow, int destLastColumn, boolean destWholeColumn, boolean destWholeRow) {
        super(label, sheet, srcRow, srcColumn, srcLastRow, srcLastColumn, srcWholeColumn, srcWholeRow, 7);
        this._destRow = destRow;
        this._destColumn = destColumn;
        this._destLastRow = destLastRow;
        this._destLastColumn = destLastColumn;
        int srcColNum = srcLastColumn - srcColumn;
        int srcRowNum = srcLastRow - srcRow;
        int destWidth = Math.max(destLastColumn - destColumn, srcColNum);
        int destHeight = Math.max(destLastRow - destRow, srcRowNum);
        this._reservedDestLastRow = this._destRow + destHeight;
        this._reservedDestLastColumn = this._destColumn + destWidth;
        this._destSheet = destSheet;
        this._destWholeColumn = destWholeColumn;
        this._destWholeRow = destWholeRow;
    }

    @Deprecated
    public PasteCellAction(String label, Sheet sheet, int srcRow, int srcColumn, int srcLastRow, int srcLastColumn, boolean srcWholeColumn, Sheet destSheet, int destRow, int destColumn, int destLastRow, int destLastColumn, boolean destWholeColumn) {
        this(label, sheet, srcRow, srcColumn, srcLastRow, srcLastColumn, srcWholeColumn, false, destSheet, destRow, destColumn, destLastRow, destLastColumn, destWholeColumn, false);
    }

    @Deprecated
    public PasteCellAction(String label, Sheet sheet, int srcRow, int srcColumn, int srcLastRow, int srcLastColumn, Sheet destSheet, int destRow, int destColumn, int destLastRow, int destLastColumn) {
        this(label, sheet, srcRow, srcColumn, srcLastRow, srcLastColumn, false, false, destSheet, destRow, destColumn, destLastRow, destLastColumn, false, false);
    }

    @Override
    protected boolean isSheetProtected() {
        return this.isAnyCellProtected(this._destSheet, this.computePastingRegion());
    }

    @Override
    public Sheet getUndoSheet() {
        return this._destSheet;
    }

    @Override
    public Sheet getRedoSheet() {
        return this._destSheet;
    }

    @Override
    protected int getReservedRow() {
        return this._destRow;
    }

    @Override
    protected int getReservedColumn() {
        return this._destColumn;
    }

    @Override
    protected int getReservedLastRow() {
        return this._reservedDestLastRow;
    }

    @Override
    protected int getReservedLastColumn() {
        return this._reservedDestLastColumn;
    }

    @Override
    protected Sheet getReservedSheet() {
        return this._destSheet;
    }

    @Override
    public AreaRef getUndoSelection() {
        return this._pastedRange == null ? new AreaRef(this._destRow, this._destColumn, this._destLastRow, this._destLastColumn) : new AreaRef(this._pastedRange.getRow(), this._pastedRange.getColumn(), this._pastedRange.getLastRow(), this._pastedRange.getLastColumn());
    }

    @Override
    public AreaRef getRedoSelection() {
        return this._pastedRange == null ? new AreaRef(this._destRow, this._destColumn, this._destLastRow, this._destLastColumn) : new AreaRef(this._pastedRange.getRow(), this._pastedRange.getColumn(), this._pastedRange.getLastRow(), this._pastedRange.getLastColumn());
    }

    @Override
    protected void applyAction() {
        RangeImpl src = new RangeImpl((SRange)new PasteRangeImpl(this._sheet.getInternalSheet(), this._row, this._column, this._lastRow, this._lastColumn, this._wholeRow, this._wholeColumn), this._sheet);
        RangeImpl dest = new RangeImpl((SRange)new PasteRangeImpl(this._destSheet.getInternalSheet(), this._destRow, this._destColumn, this._destLastRow, this._destLastColumn, this._wholeRow, this._destWholeColumn), this._destSheet);
        this._pastedRange = CellOperationUtil.paste(src, dest);
        if (this.isDstSheetProtected()) {
            EditableCellStyle recoveredStyle = this._pastedRange.getCellStyleHelper().createCellStyle(dest.getCellStyle());
            recoveredStyle.setLocked(false);
            this._pastedRange.setCellStyle(recoveredStyle);
        }
        CellOperationUtil.fitFontHeightPoints(Ranges.range(this._destSheet, dest.getRow(), dest.getColumn(), dest.getRow() + (this._lastRow - this._row), dest.getColumn() + (this._lastColumn - this._column)));
    }

    private CellRegion computePastingRegion() {
        CellRegion destinationRegion = new CellRegion(this._destRow, this._destColumn, this._destLastRow, this._destLastColumn);
        if (destinationRegion.isSingle()) {
            return new CellRegion(this._destRow, this._destColumn, this._destRow + (this._lastRow - this._row), this._destColumn + (this._lastColumn - this._column));
        }
        return destinationRegion;
    }

    protected boolean isDstSheetProtected() {
        try {
            return this._destSheet.isProtected();
        }
        catch (Exception exception) {
            return true;
        }
    }
}

