/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.task;

import com.hazelcast.cp.exception.CPSubsystemException;
import com.hazelcast.cp.exception.CannotReplicateException;
import com.hazelcast.cp.exception.NotLeaderException;
import com.hazelcast.cp.internal.raft.QueryPolicy;
import com.hazelcast.cp.internal.raft.command.RaftGroupCmd;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.RaftNodeImpl;
import com.hazelcast.cp.internal.raft.impl.RaftRole;
import com.hazelcast.cp.internal.raft.impl.state.QueryState;
import com.hazelcast.cp.internal.raft.impl.state.RaftState;
import com.hazelcast.cp.internal.raft.impl.task.ReplicateTask;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.UUID;

public class QueryTask
implements Runnable {
    private final RaftNodeImpl raftNode;
    private final Object operation;
    private final QueryPolicy queryPolicy;
    private final InternalCompletableFuture resultFuture;
    private final ILogger logger;

    public QueryTask(RaftNodeImpl raftNode, Object operation, QueryPolicy policy, InternalCompletableFuture resultFuture) {
        this.raftNode = raftNode;
        this.operation = operation;
        this.logger = raftNode.getLogger(this.getClass());
        this.queryPolicy = policy;
        this.resultFuture = resultFuture;
    }

    @Override
    public void run() {
        try {
            if (!this.verifyOperation()) {
                return;
            }
            if (!this.verifyRaftNodeStatus()) {
                return;
            }
            switch (this.queryPolicy) {
                case LEADER_LOCAL: {
                    this.handleLeaderLocalRead();
                    break;
                }
                case ANY_LOCAL: {
                    this.handleAnyLocalRead();
                    break;
                }
                case LINEARIZABLE: {
                    this.handleLinearizableRead();
                    break;
                }
                default: {
                    this.resultFuture.completeExceptionally(new IllegalArgumentException("Invalid query policy: " + (Object)((Object)this.queryPolicy)));
                    break;
                }
            }
        }
        catch (Throwable t) {
            this.logger.severe((Object)((Object)this.queryPolicy) + " query failed", t);
            RaftEndpoint leader = this.raftNode.getLeader();
            UUID leaderUuid = leader != null ? leader.getUuid() : null;
            this.resultFuture.completeExceptionally(new CPSubsystemException("Internal failure", t, leaderUuid));
        }
    }

    private void handleLeaderLocalRead() {
        RaftState state = this.raftNode.state();
        if (state.role() != RaftRole.LEADER) {
            this.resultFuture.completeExceptionally(new NotLeaderException(this.raftNode.getGroupId(), this.raftNode.getLocalMember(), state.leader()));
            return;
        }
        this.handleAnyLocalRead();
    }

    private void handleAnyLocalRead() {
        RaftState state = this.raftNode.state();
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Querying: " + this.operation + " with policy: " + (Object)((Object)this.queryPolicy) + " in term: " + state.term());
        }
        this.raftNode.runQuery(this.operation, this.resultFuture);
    }

    private void handleLinearizableRead() {
        if (!this.raftNode.isLinearizableReadOptimizationEnabled()) {
            new ReplicateTask(this.raftNode, this.operation, this.resultFuture).run();
            return;
        }
        RaftState state = this.raftNode.state();
        if (state.role() != RaftRole.LEADER) {
            this.resultFuture.completeExceptionally(new NotLeaderException(this.raftNode.getGroupId(), this.raftNode.getLocalMember(), state.leader()));
            return;
        }
        if (!this.raftNode.canQueryLinearizable()) {
            this.resultFuture.completeExceptionally(new CannotReplicateException(state.leader()));
            return;
        }
        long commitIndex = state.commitIndex();
        QueryState queryState = state.leaderState().queryState();
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Adding query at commit index: " + commitIndex + ", query round: " + queryState.queryRound());
        }
        if (queryState.addQuery(commitIndex, this.operation, this.resultFuture) == 1) {
            this.raftNode.broadcastAppendRequest();
        }
    }

    private boolean verifyOperation() {
        if (this.operation instanceof RaftGroupCmd) {
            this.resultFuture.completeExceptionally(new IllegalArgumentException("cannot run query: " + this.operation));
            return false;
        }
        return true;
    }

    private boolean verifyRaftNodeStatus() {
        switch (this.raftNode.getStatus()) {
            case INITIAL: {
                this.resultFuture.completeExceptionally(new CannotReplicateException(null));
                return false;
            }
            case TERMINATED: 
            case STEPPED_DOWN: {
                this.resultFuture.completeExceptionally(new NotLeaderException(this.raftNode.getGroupId(), this.raftNode.getLocalMember(), null));
                return false;
            }
        }
        return true;
    }
}

