/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.ui.zk.websocket;

import java.io.IOException;
import java.util.logging.Level;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.compiere.util.CLogger;
import org.compiere.util.Util;
import org.idempiere.ui.zk.websocket.WebSocketServerPush;

@ServerEndpoint(value="/serverpush/{dtid}")
public class ServerPushEndPoint {
    private Session session;
    private String dtid;

    @OnClose
    public void onClose(Session sess) throws IOException {
        if (this.session != null) {
            this.session = null;
            WebSocketServerPush.unregisterEndPoint(this.dtid);
        }
    }

    @OnOpen
    public void onOpen(Session sess, @PathParam(value="dtid") String dtid) throws IOException {
        if (!Util.isEmpty((String)dtid, (boolean)true) && WebSocketServerPush.isValidDesktopId(dtid)) {
            this.session = sess;
            this.dtid = dtid;
            WebSocketServerPush.registerEndPoint(dtid, this);
        }
    }

    @OnError
    public void onError(Session sess, Throwable throwable) {
        CLogger.getCLogger(this.getClass()).log(Level.WARNING, throwable.getMessage(), throwable);
    }

    @OnMessage
    public void onMessage(Session session, String message) {
        if (session == this.session && !Util.isEmpty((String)message) && message.equals("__ping__")) {
            try {
                session.getBasicRemote().sendText("__pong__");
            }
            catch (IOException | IllegalArgumentException e) {
                CLogger.getCLogger(this.getClass()).log(Level.WARNING, e.getMessage(), (Throwable)e);
            }
        }
    }

    public void echo() {
        if (this.session != null) {
            try {
                this.session.getBasicRemote().sendText("echo");
            }
            catch (IOException e) {
                CLogger.getCLogger(this.getClass()).log(Level.WARNING, e.getMessage(), (Throwable)e);
            }
        }
    }
}

