/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.List;
import java.util.Properties;
import org.adempiere.webui.component.ListCell;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.WListItemRenderer;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WebEditorFactory;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.info.InfoWindow;
import org.adempiere.webui.theme.ThemeManager;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.UUIDColumn;
import org.compiere.model.GridField;
import org.compiere.model.InfoColumnVO;
import org.compiere.model.MColumn;
import org.compiere.model.MStyle;
import org.compiere.util.DefaultEvaluatee;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.KeyNamePair;
import org.compiere.util.ValueNamePair;
import org.zkoss.zhtml.Text;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Span;

public class WInfoWindowListItemRenderer
extends WListItemRenderer {
    private InfoColumnVO[] gridDisplayedInfoColumns = null;
    private ColumnInfo[] gridDisplayedColumnInfos = null;
    private InfoWindow infoWindow = null;

    public WInfoWindowListItemRenderer(InfoWindow infoWindow) {
        this.infoWindow = infoWindow;
    }

    public WInfoWindowListItemRenderer(InfoWindow infoWindow, List<? extends String> columnNames) {
        super(columnNames);
        this.infoWindow = infoWindow;
    }

    public void setGridDisplaydInfoColumns(InfoColumnVO[] infoColumns, ColumnInfo[] columnInfos) {
        this.gridDisplayedInfoColumns = infoColumns;
        this.gridDisplayedColumnInfos = columnInfos;
    }

    @Override
    protected Listcell getCellComponent(WListbox table, Object field, final int rowIndex, final int columnIndex) {
        if (this.gridDisplayedInfoColumns == null || this.gridDisplayedColumnInfos == null) {
            return super.getCellComponent(table, field, rowIndex, columnIndex);
        }
        Listcell listcell = null;
        ListModelTable model = table.getModel();
        Object obj = model.get(rowIndex);
        InfoColumnVO infoColumn = this.gridDisplayedInfoColumns[columnIndex];
        if (infoColumn != null) {
            final GridField gridField = this.gridDisplayedColumnInfos[columnIndex].getGridField();
            final WEditor editor = WebEditorFactory.getEditor(gridField, false);
            if (model.isSelected(obj) && !infoColumn.isReadOnly() && columnIndex > 0) {
                ListCell listCell = new ListCell();
                Object value = table.getValueAt(rowIndex, columnIndex);
                if (value instanceof IDColumn) {
                    idc = (IDColumn)value;
                    value = idc.getRecord_ID();
                } else if (value instanceof UUIDColumn) {
                    idc = (UUIDColumn)value;
                    value = idc.getRecord_UU();
                } else if (value instanceof KeyNamePair) {
                    KeyNamePair knp = (KeyNamePair)value;
                    value = knp.getKey();
                } else if (value instanceof ValueNamePair) {
                    ValueNamePair vnp = (ValueNamePair)value;
                    value = vnp.getValue();
                }
                editor.setValue(value);
                editor.addValueChangeListener(new ValueChangeListener(){

                    @Override
                    public void valueChange(ValueChangeEvent evt) {
                        WInfoWindowListItemRenderer.this.infoWindow.onCellEditCallback(evt, rowIndex, columnIndex, editor, gridField);
                    }
                });
                listCell.appendChild(editor.getComponent());
                listcell = listCell;
            }
            if (listcell == null) {
                listcell = super.getCellComponent(table, field, rowIndex, columnIndex);
            }
            if (gridField.getAD_FieldStyle_ID() > 0) {
                MStyle style = MStyle.get((Properties)Env.getCtx(), (int)gridField.getAD_FieldStyle_ID());
                DefaultEvaluatee evaluatee = new DefaultEvaluatee((DefaultEvaluatee.DataProvider)new TableDataProvider(table, rowIndex));
                String styleStr = style.buildStyle(ThemeManager.getTheme(), (Evaluatee)evaluatee);
                if (style.isWrapWithSpan()) {
                    Span span = new Span();
                    span.appendChild((Component)new Text((String)listcell.getValue()));
                    listcell.setLabel(null);
                    listcell.appendChild((Component)span);
                    this.setStyle((HtmlBasedComponent)span, styleStr);
                } else {
                    this.setStyle((HtmlBasedComponent)listcell, styleStr);
                }
            }
        }
        if (listcell == null) {
            listcell = super.getCellComponent(table, field, rowIndex, columnIndex);
        }
        return listcell;
    }

    private void setStyle(HtmlBasedComponent component, String style) {
        if (style != null && style.startsWith("@sclass=")) {
            String sclass = style.substring("@sclass=".length());
            component.setSclass(sclass);
        } else if (style != null && style.startsWith("@zclass=")) {
            String zclass = style.substring("@zclass=".length());
            component.setZclass(zclass);
        } else {
            ZkCssHelper.appendStyle(component, style);
        }
    }

    private class TableDataProvider
    implements DefaultEvaluatee.DataProvider {
        private WListbox table;
        private int rowIndex;

        private TableDataProvider(WListbox table, int rowIndex) {
            this.table = table;
            this.rowIndex = rowIndex;
        }

        public Object getValue(String columnName) {
            String value = null;
            int idx = 0;
            InfoColumnVO[] infoColumnVOArray = WInfoWindowListItemRenderer.this.gridDisplayedInfoColumns;
            int n = WInfoWindowListItemRenderer.this.gridDisplayedInfoColumns.length;
            int n2 = 0;
            while (n2 < n) {
                InfoColumnVO ic = infoColumnVOArray[n2];
                if (ic != null && ic.getColumnName().equals(columnName)) {
                    value = String.valueOf(this.table.getValueAt(this.rowIndex, idx));
                    break;
                }
                ++idx;
                ++n2;
            }
            return value;
        }

        public Object getProperty(String propertyName) {
            return null;
        }

        public MColumn getColumn(String columnName) {
            return null;
        }

        public String getTrxName() {
            return null;
        }
    }
}

