/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.compiere.util.Trx;

public class TrxInfo
implements Serializable {
    private static final long serialVersionUID = 5884131137700945750L;
    private String displayName;
    private String trxName;
    private Date startTime;
    private String stackTrace;
    private boolean isActive;

    private TrxInfo() {
    }

    public static TrxInfo[] getOpenTransactions(boolean onlyActive) {
        Trx[] trxs;
        ArrayList<TrxInfo> list = new ArrayList<TrxInfo>();
        Trx[] trxArray = trxs = Trx.getOpenTransactions();
        int n = trxs.length;
        int n2 = 0;
        while (n2 < n) {
            Trx trx = trxArray[n2];
            if (trx != null && (!onlyActive || trx.isActive())) {
                TrxInfo ti = new TrxInfo();
                ti.displayName = trx.getDisplayName();
                ti.trxName = trx.getTrxName();
                ti.startTime = trx.getStartTime();
                ti.stackTrace = trx.getStrackTrace();
                ti.isActive = trx.isActive();
                list.add(ti);
            }
            ++n2;
        }
        return list.toArray(new TrxInfo[0]);
    }

    public static TrxInfo[] getOpenTransactions() {
        return TrxInfo.getOpenTransactions(false);
    }

    public static TrxInfo[] getActiveTransactions() {
        return TrxInfo.getOpenTransactions(true);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getTrxName() {
        return this.trxName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public boolean isActive() {
        return this.isActive;
    }
}

