/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.process.rpl.exp.ExportHelper;
import org.compiere.model.MClient;
import org.compiere.model.MOrg;
import org.compiere.model.MReplicationStrategy;
import org.compiere.model.MTable;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_ReplicationDocument;
import org.compiere.model.X_AD_ReplicationTable;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ExportModelValidator
implements ModelValidator {
    public static final String CTX_IsReplicationEnabled = "#IsReplicationEnabled";
    private static final CLogger log = CLogger.getCLogger(ExportModelValidator.class);
    private int m_AD_Client_ID = -1;
    List<String> modelTables = new ArrayList<String>();
    List<String> docTables = new ArrayList<String>();
    Hashtable<Integer, ExportHelper> helpers = new Hashtable();

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            if (log.isLoggable(Level.INFO)) {
                log.info(client.toString());
            }
        } else {
            log.warning("Export Model Validator cannot be used as a global validator, it needs to be defined in a per-tenant basis");
            return;
        }
        this.loadReplicationStrategy(engine);
    }

    public void loadReplicationStrategy(ModelValidationEngine engine) {
        MClient client = MClient.get((Properties)Env.getCtx(), (int)this.m_AD_Client_ID);
        String where = "AD_ReplicationStrategy_ID IN (SELECT AD_ReplicationStrategy_ID FROM AD_Client WHERE AD_Client_ID=? UNION SELECT AD_ReplicationStrategy_ID FROM AD_Org WHERE AD_Client_ID=?)";
        List rss = new Query(Env.getCtx(), "AD_ReplicationStrategy", where, null).setOnlyActiveRecords(true).setParameters(new Object[]{this.m_AD_Client_ID, this.m_AD_Client_ID}).list();
        for (MReplicationStrategy rplStrategy : rss) {
            String tableName;
            ExportHelper expClientHelper = new ExportHelper(client, rplStrategy);
            this.helpers.put(rplStrategy.getAD_ReplicationStrategy_ID(), expClientHelper);
            for (X_AD_ReplicationTable rplTable : rplStrategy.getReplicationTables()) {
                if (!"M".equals(rplTable.getReplicationType()) && !"B".equals(rplTable.getReplicationType()) && !"R".equals(rplTable.getReplicationType()) || this.modelTables.contains(tableName = MTable.getTableName((Properties)client.getCtx(), (int)rplTable.getAD_Table_ID()))) continue;
                engine.addModelChange(tableName, (ModelValidator)this);
                this.modelTables.add(tableName);
            }
            for (X_AD_ReplicationDocument rplDocument : rplStrategy.getReplicationDocuments()) {
                if (!"M".equals(rplDocument.getReplicationType()) && !"R".equals(rplDocument.getReplicationType()) || this.docTables.contains(tableName = MTable.getTableName((Properties)client.getCtx(), (int)rplDocument.getAD_Table_ID()))) continue;
                engine.addDocValidate(tableName, (ModelValidator)this);
                this.docTables.add(tableName);
            }
        }
    }

    public String modelChange(PO po, int type) throws Exception {
        X_AD_ReplicationTable replicationTable;
        ExportHelper expHelper;
        int rsID;
        if (log.isLoggable(Level.INFO)) {
            log.info("po.get_TableName() = " + po.get_TableName());
        }
        if ((rsID = this.getReplicationStrategy(po)) > 0 && (expHelper = this.helpers.get(rsID)) != null && (type == 5 || type == 4 || type == 3) && (replicationTable = MReplicationStrategy.getReplicationTable((Properties)po.getCtx(), (int)rsID, (int)po.get_Table_ID())) != null) {
            expHelper.exportRecord(po, 0, replicationTable.getReplicationType(), type);
        }
        return null;
    }

    public String docValidate(PO po, int type) {
        ExportHelper expHelper;
        if (log.isLoggable(Level.INFO)) {
            log.info("Replicate the Document = " + po.get_TableName() + " with Type = " + type);
        }
        String result = null;
        int rsID = this.getReplicationStrategy(po);
        if (rsID > 0 && (expHelper = this.helpers.get(rsID)) != null) {
            try {
                if (type == 9 || type == 11 || type == 13 || type == 10 || type == 12) {
                    X_AD_ReplicationDocument replicationDocument = null;
                    int C_DocType_ID = po.get_ValueAsInt("C_DocType_ID");
                    replicationDocument = C_DocType_ID > 0 ? MReplicationStrategy.getReplicationDocument((Properties)po.getCtx(), (int)rsID, (int)po.get_Table_ID(), (int)C_DocType_ID) : MReplicationStrategy.getReplicationDocument((Properties)po.getCtx(), (int)rsID, (int)po.get_Table_ID());
                    if (replicationDocument != null) {
                        expHelper.exportRecord(po, 1, replicationDocument.getReplicationType(), type);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = e.toString();
            }
        }
        return result;
    }

    private int getReplicationStrategy(PO po) {
        int rsID = -1;
        int orgID = po.getAD_Org_ID();
        if (orgID > 0) {
            rsID = MOrg.get((Properties)po.getCtx(), (int)orgID).getAD_ReplicationStrategy_ID();
        }
        if (rsID <= 0) {
            int clientID = po.getAD_Client_ID();
            rsID = MClient.get((Properties)Env.getCtx(), (int)clientID).getAD_ReplicationStrategy_ID();
        }
        return rsID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        Env.setContext((Properties)Env.getCtx(), (String)CTX_IsReplicationEnabled, (boolean)true);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ExportModelValidator.class.getName());
        return sb.toString();
    }
}

