/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.io.File;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.pipo2.PackIn;
import org.adempiere.pipo2.Zipper;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MProcessPara;
import org.compiere.model.X_AD_Package_Imp_Proc;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.tools.FileUtil;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class PackInProcess
extends SvrProcess {
    private static final CLogger log = CLogger.getCLogger(PackInProcess.class);
    private boolean m_UpdateDictionary = false;
    private String m_packageDirectory = null;
    public int p_PackIn_ID = 0;
    private String packageName = null;
    private String packageVersion = null;

    protected void prepare() {
        this.p_PackIn_ID = this.getRecord_ID();
        ProcessInfoParameter[] params = this.getParameter();
        if (params != null && params.length > 0) {
            ProcessInfoParameter[] processInfoParameterArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessInfoParameter param = processInfoParameterArray[n2];
                if ("Name".equals(param.getParameterName())) {
                    this.packageName = param.getParameter().toString();
                } else if ("Version".equals(param.getParameterName())) {
                    this.packageVersion = param.getParameter().toString();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)param);
                }
                ++n2;
            }
        }
    }

    protected String doIt() throws Exception {
        String msg;
        MAttachment attachment;
        boolean success;
        String targetDirName;
        File targetDir;
        X_AD_Package_Imp_Proc adPackageImp = new X_AD_Package_Imp_Proc(this.getCtx(), this.p_PackIn_ID, null);
        String packageDirectory = adPackageImp.getAD_Package_Dir();
        if (packageDirectory == null || packageDirectory.trim().length() == 0) {
            packageDirectory = System.getProperty("java.io.tmpdir");
        }
        if ((targetDir = new File(targetDirName = packageDirectory + File.separator + "packin" + Env.getContext((Properties)this.getCtx(), (String)"#AD_User_ID"))).exists() && !FileUtil.deleteFolderRecursive((File)targetDir)) {
            throw new AdempiereSystemError("Could not delete folder " + targetDirName + ", please check permissions");
        }
        if (!targetDir.exists() && !(success = targetDir.mkdirs())) {
            log.warning("Failed to create target directory. " + targetDirName);
        }
        if ((attachment = adPackageImp.getAttachment()) == null) {
            return "Please attach the pack out archive before running the process";
        }
        MAttachmentEntry entry = attachment.getEntry(0);
        if (entry == null) {
            return "Please attach the pack out archive before running the process";
        }
        File zipFilepath = entry.getFile();
        if (log.isLoggable(Level.INFO)) {
            log.info("zipFilepath->" + String.valueOf(zipFilepath));
        }
        String parentDir = Zipper.getParentDir(zipFilepath);
        Zipper.unpackFile(zipFilepath, targetDir);
        String dict_file = packageDirectory + File.separator + "packin" + Env.getContext((Properties)this.getCtx(), (String)"#AD_User_ID") + File.separator + parentDir + File.separator + "dict" + File.separator + "PackOut.xml";
        if (log.isLoggable(Level.INFO)) {
            log.info("dict file->" + dict_file);
        }
        this.m_UpdateDictionary = adPackageImp.isAD_Override_Dict();
        this.m_packageDirectory = packageDirectory + File.separator + "packin" + Env.getContext((Properties)this.getCtx(), (String)"#AD_User_ID") + File.separator + parentDir + File.separator;
        PackIn packIn = new PackIn();
        packIn.setPackageDirectory(this.m_packageDirectory);
        packIn.setPackageName(adPackageImp.getName());
        packIn.setPackageVersion(this.packageVersion);
        packIn.setUpdateDictionary(this.m_UpdateDictionary);
        packIn.getNotifier().setFileName(zipFilepath.getName());
        packIn.setAD_Package_Imp_Proc(adPackageImp);
        try {
            try {
                msg = packIn.importXML(dict_file, this.getCtx(), this.get_TrxName());
                adPackageImp.setDateProcessed(new Timestamp(System.currentTimeMillis()));
                adPackageImp.setP_Msg(msg);
                adPackageImp.saveEx();
                this.commitEx();
            }
            catch (Exception e) {
                adPackageImp.setP_Msg(e.getLocalizedMessage());
                packIn.getNotifier().addFailureLine(e.getLocalizedMessage());
                packIn.setSuccess(false);
                log.log(Level.SEVERE, "importXML:", (Throwable)e);
                throw e;
            }
        }
        finally {
            adPackageImp.save();
            packIn.getNotifier().notifyRecipient();
        }
        return msg;
    }
}

