/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install.util;

import javax.swing.SwingUtilities;

public abstract class SwingWorker {
    private ThreadVar m_threadVar;
    private Object m_value;

    public SwingWorker() {
        final Runnable doFinished = new Runnable(){

            @Override
            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            @Override
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                }
                finally {
                    SwingWorker.this.m_threadVar.clear();
                }
                SwingUtilities.invokeLater(doFinished);
            }
        };
        Thread t = new Thread(doConstruct);
        this.m_threadVar = new ThreadVar(t);
    }

    public abstract Object construct();

    public void finished() {
    }

    protected synchronized Object getValue() {
        return this.m_value;
    }

    private synchronized void setValue(Object x) {
        this.m_value = x;
    }

    public void start() {
        Thread t = this.m_threadVar.get();
        if (t != null) {
            t.start();
        }
    }

    public Object get() {
        Thread t;
        while ((t = this.m_threadVar.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public void interrupt() {
        Thread t = this.m_threadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this.m_threadVar.clear();
    }

    public boolean isAlive() {
        Thread t = this.m_threadVar.get();
        if (t == null) {
            return false;
        }
        return t.isAlive();
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

