/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.markdown;

import java.util.List;
import java.util.Map;
import org.adempiere.base.markdown.IMarkdownRenderer;
import org.commonmark.Extension;
import org.commonmark.ext.autolink.AutolinkExtension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.AttributeProvider;
import org.commonmark.renderer.html.AttributeProviderContext;
import org.commonmark.renderer.html.AttributeProviderFactory;
import org.commonmark.renderer.html.HtmlRenderer;
import org.osgi.service.component.annotations.Component;

@Component(service={IMarkdownRenderer.class}, immediate=true)
public class MarkdownRendererImpl
implements IMarkdownRenderer {
    @Override
    public String renderToHtml(String inputText, boolean autoLink) {
        List<Extension> extensions = autoLink ? List.of(TablesExtension.create(), AutolinkExtension.create()) : List.of(TablesExtension.create());
        Parser parser = Parser.builder().extensions(extensions).build();
        HtmlRenderer.Builder builder = HtmlRenderer.builder().extensions(extensions).omitSingleParagraphP(true);
        if (autoLink) {
            builder = builder.attributeProviderFactory(new AttributeProviderFactory(){

                public AttributeProvider create(AttributeProviderContext context) {
                    return new LinkAttributeProvider();
                }
            });
        }
        HtmlRenderer renderer = builder.build();
        if (inputText.indexOf("<#md>") >= 0 && inputText.indexOf("</#md>") > 0) {
            StringBuilder sb = new StringBuilder();
            int start = inputText.indexOf("<#md>");
            int end = start >= 0 ? inputText.indexOf("</#md>", start) : 0;
            while (start >= 0 && end > start) {
                sb.append(inputText.substring(0, start));
                String md = inputText.substring(start + "<#md>".length(), end);
                inputText = end + 5 < inputText.length() ? inputText.substring(end + "</#md>".length(), inputText.length()) : "";
                Node node = parser.parse(md);
                sb.append(renderer.render(node));
                start = inputText.indexOf("<#md>");
                int n = end = start >= 0 ? inputText.indexOf("</#md>", start) : 0;
            }
            if (inputText.length() > 0) {
                sb.append(inputText);
            }
            return sb.toString();
        }
        Node node = parser.parse(inputText);
        return renderer.render(node);
    }

    private class LinkAttributeProvider
    implements AttributeProvider {
        private LinkAttributeProvider() {
        }

        public void setAttributes(Node node, String tagName, Map<String, String> attributes) {
            String href;
            if (node instanceof Link && (href = attributes.get("href")) != null) {
                if (!href.startsWith("javascript:") && !attributes.containsKey("target")) {
                    attributes.put("target", "_blank");
                }
                if (!attributes.containsKey("onclick")) {
                    attributes.put("onclick", "event.stopPropagation()");
                }
            }
        }
    }
}

