/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import java.util.ArrayList;
import java.util.List;
import org.adempiere.base.ILookupFactory;
import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.Service;
import org.compiere.model.GridFieldVO;
import org.compiere.model.InfoColumnVO;
import org.compiere.model.Lookup;
import org.compiere.util.CCache;

public final class LookupFactoryHelper {
    private static final CCache<Long, IServiceReferenceHolder<ILookupFactory>> s_lookupFactoryCache = new CCache(null, "ILookupFactory", 10, false);

    private LookupFactoryHelper() {
    }

    public static Lookup getLookup(GridFieldVO gridFieldVO) {
        ArrayList<Long> visitedIds = new ArrayList<Long>();
        if (!s_lookupFactoryCache.isEmpty()) {
            Long[] keys;
            Long[] longArray = keys = s_lookupFactoryCache.keySet().toArray(new Long[0]);
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                Long key = longArray[n2];
                IServiceReferenceHolder<ILookupFactory> serviceReference = s_lookupFactoryCache.get(key);
                if (serviceReference != null) {
                    ILookupFactory service = serviceReference.getService();
                    if (service != null) {
                        visitedIds.add(key);
                        Lookup lookup = service.getLookup(gridFieldVO);
                        if (lookup != null) {
                            return lookup;
                        }
                    } else {
                        s_lookupFactoryCache.remove(key);
                    }
                }
                ++n2;
            }
        }
        List<IServiceReferenceHolder<ILookupFactory>> serviceReferences = Service.locator().list(ILookupFactory.class).getServiceReferences();
        for (IServiceReferenceHolder<ILookupFactory> serviceReference : serviceReferences) {
            ILookupFactory service;
            Long serviceId = (Long)serviceReference.getServiceReference().getProperty("service.id");
            if (visitedIds.contains(serviceId) || (service = serviceReference.getService()) == null) continue;
            s_lookupFactoryCache.put(serviceId, serviceReference);
            Lookup lookup = service.getLookup(gridFieldVO);
            if (lookup == null) continue;
            return lookup;
        }
        return null;
    }

    public static boolean isLookup(GridFieldVO gridFieldVO) {
        ArrayList<Long> visitedIds = new ArrayList<Long>();
        if (!s_lookupFactoryCache.isEmpty()) {
            Long[] keys;
            Long[] longArray = keys = s_lookupFactoryCache.keySet().toArray(new Long[0]);
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                Long key = longArray[n2];
                IServiceReferenceHolder<ILookupFactory> serviceReference = s_lookupFactoryCache.get(key);
                if (serviceReference != null) {
                    ILookupFactory service = serviceReference.getService();
                    if (service != null) {
                        visitedIds.add(key);
                        if (service.isLookup(gridFieldVO)) {
                            return true;
                        }
                    } else {
                        s_lookupFactoryCache.remove(key);
                    }
                }
                ++n2;
            }
        }
        List<IServiceReferenceHolder<ILookupFactory>> serviceReferences = Service.locator().list(ILookupFactory.class).getServiceReferences();
        for (IServiceReferenceHolder<ILookupFactory> serviceReference : serviceReferences) {
            ILookupFactory service;
            Long serviceId = (Long)serviceReference.getServiceReference().getProperty("service.id");
            if (visitedIds.contains(serviceId) || (service = serviceReference.getService()) == null) continue;
            s_lookupFactoryCache.put(serviceId, serviceReference);
            if (!service.isLookup(gridFieldVO)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLookup(InfoColumnVO infoColumnVO) {
        ArrayList<Long> visitedIds = new ArrayList<Long>();
        if (!s_lookupFactoryCache.isEmpty()) {
            Long[] keys;
            Long[] longArray = keys = s_lookupFactoryCache.keySet().toArray(new Long[0]);
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                Long key = longArray[n2];
                IServiceReferenceHolder<ILookupFactory> serviceReference = s_lookupFactoryCache.get(key);
                if (serviceReference != null) {
                    ILookupFactory service = serviceReference.getService();
                    if (service != null) {
                        visitedIds.add(key);
                        if (service.isLookup(infoColumnVO)) {
                            return true;
                        }
                    } else {
                        s_lookupFactoryCache.remove(key);
                    }
                }
                ++n2;
            }
        }
        List<IServiceReferenceHolder<ILookupFactory>> serviceReferences = Service.locator().list(ILookupFactory.class).getServiceReferences();
        for (IServiceReferenceHolder<ILookupFactory> serviceReference : serviceReferences) {
            ILookupFactory service;
            Long serviceId = (Long)serviceReference.getServiceReference().getProperty("service.id");
            if (visitedIds.contains(serviceId) || (service = serviceReference.getService()) == null) continue;
            s_lookupFactoryCache.put(serviceId, serviceReference);
            if (!service.isLookup(infoColumnVO)) continue;
            return true;
        }
        return false;
    }
}

