/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MColumn;
import org.compiere.model.MTab;
import org.compiere.model.M_Element;
import org.compiere.model.X_AD_Field;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;
import org.idempiere.expression.logic.LogicEvaluator;

public class MField
extends X_AD_Field
implements ImmutablePOSupport {
    private static final long serialVersionUID = -7382459987895129752L;
    private static ImmutableIntPOCache<Integer, MField> s_cache = new ImmutableIntPOCache("AD_Field", 20);

    public static MField get(int AD_Field_ID) {
        return MField.get(Env.getCtx(), AD_Field_ID);
    }

    public static MField get(Properties ctx, int AD_Field_ID) {
        Integer key = AD_Field_ID;
        MField retValue = s_cache.get(ctx, key, e -> new MField(ctx, (MField)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MField(ctx, AD_Field_ID, null);
        if (retValue.get_ID() == AD_Field_ID) {
            s_cache.put(key, retValue, e -> new MField(Env.getCtx(), (MField)e));
            return retValue;
        }
        return null;
    }

    public MField(Properties ctx, String AD_Field_UU, String trxName) {
        super(ctx, AD_Field_UU, trxName);
        if (Util.isEmpty(AD_Field_UU)) {
            this.setInitialDefaults();
        }
    }

    public MField(Properties ctx, int AD_Field_ID, String trxName) {
        super(ctx, AD_Field_ID, trxName);
        if (AD_Field_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setEntityType("U");
        this.setIsCentrallyMaintained(true);
        this.setIsDisplayed(true);
        this.setIsDisplayedGrid(true);
        this.setIsEncrypted(false);
        this.setIsFieldOnly(false);
        this.setIsHeading(false);
        this.setIsReadOnly(false);
        this.setIsSameLine(false);
    }

    public MField(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MField(MTab parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Tab_ID(parent.getAD_Tab_ID());
    }

    public MField(MTab parent, MField from) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        MField.copyValues(from, this);
        this.setClientOrg(parent);
        this.setAD_Tab_ID(parent.getAD_Tab_ID());
        this.setEntityType(parent.getEntityType());
    }

    public MField(MField copy) {
        this(Env.getCtx(), copy);
    }

    public MField(Properties ctx, MField copy) {
        this(ctx, copy, null);
    }

    public MField(Properties ctx, MField copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public void setColumn(MColumn column) {
        this.setAD_Column_ID(column.getAD_Column_ID());
        this.setName(column.getName());
        this.setDescription(column.getDescription());
        this.setHelp(column.getHelp());
        this.setDisplayLength(column.getFieldLength());
        this.setEntityType(column.getEntityType());
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MColumn column;
        if ((newRecord || this.is_ValueChanged("AD_Column_ID")) && this.isCentrallyMaintained()) {
            M_Element element = M_Element.getOfColumn(this.getCtx(), this.getAD_Column_ID(), this.get_TrxName());
            this.setName(element.getName());
            this.setDescription(element.getDescription());
            this.setHelp(element.getHelp());
        }
        if (this.getIsAllowCopy() != null && ((column = (MColumn)this.getAD_Column()).isKey() || column.isVirtualColumn() || column.isUUIDColumn() || column.isStandardColumn() && !column.getColumnName().equals("AD_Org_ID"))) {
            this.setIsAllowCopy(null);
        }
        if (this.getIsAllowCopy() == null && this.getAD_Column().getColumnName().equals("AD_Org_ID")) {
            this.setIsAllowCopy("Y");
        }
        if (this.getAD_Reference_ID() <= 0) {
            if (this.getAD_Reference_Value_ID() != 0) {
                this.setAD_Reference_Value_ID(0);
            }
            if (this.getAD_Val_Rule_ID() != 0) {
                this.setAD_Val_Rule_ID(0);
            }
            if (this.getIsToolbarButton() != null) {
                this.setIsToolbarButton(null);
            }
        }
        if (this.isDisplayed() && (column = (MColumn)this.getAD_Column()).isVirtualSearchColumn()) {
            this.setIsDisplayed(false);
            this.setIsDisplayedGrid(false);
        }
        if ((newRecord || this.is_ValueChanged("ReadOnlyLogic")) && this.isActive() && !Util.isEmpty(this.getReadOnlyLogic(), true) && !this.getReadOnlyLogic().startsWith("@SQL=")) {
            LogicEvaluator.validate(this.getReadOnlyLogic());
        }
        if ((newRecord || this.is_ValueChanged("DisplayLogic")) && this.isActive() && !Util.isEmpty(this.getDisplayLogic(), true) && !this.getDisplayLogic().startsWith("@SQL=")) {
            LogicEvaluator.validate(this.getDisplayLogic());
        }
        if ((newRecord || this.is_ValueChanged("MandatoryLogic")) && this.isActive() && !Util.isEmpty(this.getMandatoryLogic(), true) && !this.getMandatoryLogic().startsWith("@SQL=")) {
            LogicEvaluator.validate(this.getMandatoryLogic());
        }
        return true;
    }

    @Override
    public MField markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

