/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Timestamp;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.MProductionPlan;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Env;
import org.compiere.wf.MWorkflow;

@Process
public class ProductionProcess
extends SvrProcess {
    private int p_M_Production_ID = 0;
    private Timestamp p_MovementDate = null;
    private MProduction m_production = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("MovementDate")) {
                    this.p_MovementDate = (Timestamp)para[i].getParameter();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        this.p_M_Production_ID = this.getRecord_ID();
        if (this.p_M_Production_ID > 0) {
            this.m_production = new MProduction(this.getCtx(), this.p_M_Production_ID, this.get_TrxName());
        }
    }

    protected String doIt() throws Exception {
        if (this.m_production == null || this.m_production.get_ID() == 0) {
            throw new AdempiereUserError("Could not load production header");
        }
        try {
            int processed = ProductionProcess.procesProduction(this.m_production, this.p_MovementDate, false);
            StringBuilder msgreturn = new StringBuilder("@Processed@ #").append(processed);
            return msgreturn.toString();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            return e.getMessage();
        }
    }

    public static int procesProduction(MProduction production, Timestamp movementDate, boolean mustBeStocked) {
        ProcessInfo pi = MWorkflow.runDocumentActionWorkflow((PO)production, (String)"CO");
        if (pi.isError()) {
            throw new RuntimeException(pi.getSummary());
        }
        if (production.isUseProductionPlan()) {
            Query planQuery = new Query(Env.getCtx(), "M_ProductionPlan", "M_ProductionPlan.M_Production_ID=?", production.get_TrxName());
            List plans = planQuery.setParameters(new Object[]{production.getM_Production_ID()}).list();
            int linesCount = 0;
            for (MProductionPlan plan : plans) {
                MProductionLine[] lines = plan.getLines();
                linesCount += lines.length;
            }
            return linesCount;
        }
        return production.getLines().length;
    }
}

