/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.exceptions.DBException;
import org.compiere.model.ICostInfo;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.X_M_CostHistory;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MCostHistory
extends X_M_CostHistory
implements ICostInfo {
    private static final long serialVersionUID = -5916746920051232413L;

    public MCostHistory(Properties ctx, String M_CostHistory_UU, String trxName) {
        super(ctx, M_CostHistory_UU, trxName);
    }

    public MCostHistory(Properties ctx, int M_CostHistory_ID, String trxName) {
        super(ctx, M_CostHistory_ID, trxName);
    }

    public MCostHistory(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCostHistory(MCostDetail cd, MCost cost, MCostElement ce) {
        this(cd.getCtx(), 0, cd.get_TrxName());
        this.setM_AttributeSetInstance_ID(cost.getM_AttributeSetInstance_ID());
        this.setM_CostDetail_ID(cd.getM_CostDetail_ID());
        this.setDateAcct(cd.getDateAcct());
        this.setIsBackDate(cd.isBackDate());
        this.setBackDateProcessedOn(cd.getBackDateProcessedOn());
        this.setM_CostElement_ID(ce.getM_CostElement_ID());
        this.setM_CostType_ID(cost.getM_CostType_ID());
        this.setM_Product_ID(cost.getM_Product_ID());
        this.setClientOrg(cost.getAD_Client_ID(), cost.getAD_Org_ID());
        this.setOldQty(cost.getCurrentQty());
        this.setOldCostPrice(cost.getCurrentCostPrice());
        this.setOldCAmt(cost.getCumulatedAmt());
        this.setOldCQty(cost.getCumulatedQty());
    }

    protected static MCostHistory get(Properties ctx, int AD_Org_ID, int M_CostType_ID, int C_AcctSchema_ID, String costingMethod, int M_CostElement_ID, int M_AttributeSetInstance_ID, MCostDetail cd, String trxName) {
        if (cd == null) {
            return null;
        }
        if ("S".equals(costingMethod)) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT c.* ");
        sql.append("FROM M_CostHistory c ");
        sql.append("JOIN M_CostDetail cd ON (cd.M_CostDetail_ID = c.M_CostDetail_ID AND cd.Processed=?) ");
        sql.append("LEFT JOIN M_CostDetail refcd ON (refcd.M_CostDetail_ID=cd.Ref_CostDetail_ID) ");
        sql.append("LEFT OUTER JOIN M_CostElement ce ON (c.M_CostElement_ID=ce.M_CostElement_ID) ");
        sql.append("WHERE c.AD_Client_ID=? AND c.AD_Org_ID=? ");
        sql.append(" AND c.M_Product_ID=? ");
        sql.append(" AND (c.M_AttributeSetInstance_ID=? OR c.M_AttributeSetInstance_ID=0) ");
        sql.append(" AND c.M_CostType_ID=? AND cd.C_AcctSchema_ID=? ");
        sql.append(" AND (ce.CostingMethod IS NULL OR ce.CostingMethod=?) ");
        if (M_CostElement_ID > 0) {
            sql.append(" AND c.M_CostElement_ID=? ");
        }
        sql.append(" AND c.M_CostDetail_ID IN (?,?) ");
        sql.append(" AND c.DateAcct=? ");
        sql.append("ORDER BY c.DateAcct DESC, ");
        sql.append("CASE WHEN COALESCE(refcd.DateAcct,cd.DateAcct) = cd.DateAcct THEN COALESCE(cd.Ref_CostDetail_ID, c.M_CostDetail_ID) ELSE c.M_CostDetail_ID END DESC, ");
        sql.append("c.M_CostHistory_ID DESC ");
        String sqlStr = DB.getDatabase().addPagingSQL(sql.toString(), 1, 1);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(cd.isDelta() ? "N" : "Y");
        params.add(cd.getAD_Client_ID());
        params.add(AD_Org_ID);
        params.add(cd.getM_Product_ID());
        params.add(M_AttributeSetInstance_ID);
        params.add(M_CostType_ID);
        params.add(C_AcctSchema_ID);
        params.add(costingMethod);
        if (M_CostElement_ID > 0) {
            params.add(M_CostElement_ID);
        }
        params.add(cd.getM_CostDetail_ID());
        params.add(cd.getRef_CostDetail_ID());
        params.add(cd.getDateAcct());
        MCostHistory costHistory = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sqlStr, trxName);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    costHistory = new MCostHistory(ctx, rs, trxName);
                    costHistory.makeImmutable();
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return costHistory;
    }

    protected static MCostHistory get(Properties ctx, int AD_Client_ID, int AD_Org_ID, int M_Product_ID, int M_CostType_ID, int C_AcctSchema_ID, String costingMethod, int M_CostElement_ID, int M_AttributeSetInstance_ID, Timestamp dateAcct, String trxName) {
        if (dateAcct == null) {
            return null;
        }
        if ("S".equals(costingMethod)) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("(");
        sql.append("SELECT c.* ");
        sql.append("FROM M_CostHistory c ");
        sql.append("JOIN M_CostDetail cd ON (cd.M_CostDetail_ID = c.M_CostDetail_ID AND cd.Processed='Y') ");
        sql.append("LEFT JOIN M_CostDetail refcd ON (refcd.M_CostDetail_ID=cd.Ref_CostDetail_ID) ");
        sql.append("LEFT OUTER JOIN M_CostElement ce ON (c.M_CostElement_ID=ce.M_CostElement_ID) ");
        sql.append("WHERE c.AD_Client_ID=? AND c.AD_Org_ID=? ");
        sql.append(" AND c.M_Product_ID=? ");
        sql.append(" AND (c.M_AttributeSetInstance_ID=? OR c.M_AttributeSetInstance_ID=0) ");
        sql.append(" AND c.M_CostType_ID=? AND cd.C_AcctSchema_ID=? ");
        sql.append(" AND (ce.CostingMethod IS NULL OR ce.CostingMethod=?) ");
        if (M_CostElement_ID > 0) {
            sql.append(" AND c.M_CostElement_ID=? ");
        }
        sql.append(" AND c.DateAcct<=? ");
        sql.append("ORDER BY c.DateAcct DESC, ");
        sql.append("CASE WHEN COALESCE(refcd.DateAcct,cd.DateAcct) = cd.DateAcct THEN COALESCE(cd.Ref_CostDetail_ID, c.M_CostDetail_ID) ELSE c.M_CostDetail_ID END DESC, ");
        sql.append("c.M_CostHistory_ID DESC ");
        sql = new StringBuilder(DB.getDatabase().addPagingSQL(sql.toString(), 1, 1));
        sql.append(") UNION ALL (");
        sql.append("SELECT c.* ");
        sql.append("FROM M_CostHistory c ");
        sql.append("JOIN M_CostDetail cd ON (cd.M_CostDetail_ID = c.M_CostDetail_ID AND cd.Processed='Y') ");
        sql.append("LEFT JOIN M_CostDetail refcd ON (refcd.M_CostDetail_ID=cd.Ref_CostDetail_ID) ");
        sql.append("LEFT OUTER JOIN M_CostElement ce ON (c.M_CostElement_ID=ce.M_CostElement_ID) ");
        sql.append("WHERE c.AD_Client_ID=? AND c.AD_Org_ID=? ");
        sql.append(" AND c.M_Product_ID=? ");
        sql.append(" AND (c.M_AttributeSetInstance_ID=? OR c.M_AttributeSetInstance_ID=0) ");
        sql.append(" AND c.M_CostType_ID=? AND cd.C_AcctSchema_ID=? ");
        sql.append(" AND (ce.CostingMethod IS NULL OR ce.CostingMethod=?) ");
        if (M_CostElement_ID > 0) {
            sql.append(" AND c.M_CostElement_ID=? ");
        }
        sql.append("ORDER BY c.DateAcct ASC, ");
        sql.append("CASE WHEN COALESCE(refcd.DateAcct,cd.DateAcct) = cd.DateAcct THEN COALESCE(cd.Ref_CostDetail_ID, c.M_CostDetail_ID) ELSE c.M_CostDetail_ID END ASC, ");
        sql.append("c.M_CostHistory_ID DESC ");
        sql = new StringBuilder(DB.getDatabase().addPagingSQL(sql.toString(), 1, 1));
        sql.append(")");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(AD_Client_ID);
        params.add(AD_Org_ID);
        params.add(M_Product_ID);
        params.add(M_AttributeSetInstance_ID);
        params.add(M_CostType_ID);
        params.add(C_AcctSchema_ID);
        params.add(costingMethod);
        if (M_CostElement_ID > 0) {
            params.add(M_CostElement_ID);
        }
        params.add(dateAcct);
        params.add(AD_Client_ID);
        params.add(AD_Org_ID);
        params.add(M_Product_ID);
        params.add(M_AttributeSetInstance_ID);
        params.add(M_CostType_ID);
        params.add(C_AcctSchema_ID);
        params.add(costingMethod);
        if (M_CostElement_ID > 0) {
            params.add(M_CostElement_ID);
        }
        MCostHistory costHistory = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), trxName);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    costHistory = new MCostHistory(ctx, rs, trxName);
                    if (costHistory.getDateAcct().after(dateAcct)) {
                        costHistory.setNewCAmt(costHistory.getOldCAmt());
                        costHistory.setNewCQty(costHistory.getOldCQty());
                        costHistory.setNewCostPrice(costHistory.getOldCostPrice());
                        costHistory.setNewQty(costHistory.getOldQty());
                    }
                    costHistory.makeImmutable();
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return costHistory;
    }

    @Override
    public BigDecimal getCumulatedAmt() {
        return this.getNewCAmt();
    }

    @Override
    public BigDecimal getCumulatedQty() {
        return this.getNewCQty();
    }

    @Override
    public BigDecimal getCurrentCostPrice() {
        return this.getNewCostPrice();
    }

    @Override
    public BigDecimal getCurrentQty() {
        return this.getNewQty();
    }
}

