/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInfoWindow;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProduct;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MStorageReservation;
import org.compiere.model.MStorageReservationLog;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PurchaseOrderTest
extends AbstractTestCase {
    private static final BigDecimal THREE = new BigDecimal("3");
    private static final BigDecimal MINUS_THREE = new BigDecimal("-3");

    @Test
    public void testQtyReservedForNegativeOrderAndReceipt() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MOrder order = new MOrder(ctx, 0, trxName);
        order.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)ctx, (int)DictionaryIDs.M_Product.SEEDER.id));
        line1.setQty(new BigDecimal("-1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(trxName, new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.setDocStatus("DR");
        receipt.setDocAction("CO");
        receipt.saveEx();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setOrderLine(line1, 0, new BigDecimal("-1"));
        receiptLine.setQty(new BigDecimal("-1"));
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        line1.load(trxName, new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
    }

    @Test
    public void testPositiveAndNegativeOrderThenReceiptThenInvoice() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MOrder order = new MOrder(ctx, 0, trxName);
        order.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)ctx, (int)DictionaryIDs.M_Product.WEEDER.id));
        line1.setQty(new BigDecimal("10"));
        line1.setDatePromised(today);
        line1.saveEx();
        MOrderLine line2 = new MOrderLine(order);
        line2.setLine(20);
        line2.setProduct(MProduct.get((Properties)ctx, (int)DictionaryIDs.M_Product.SEEDER.id));
        line2.setQty(new BigDecimal("-1"));
        line2.setDatePromised(today);
        line2.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.setDocStatus("DR");
        receipt.setDocAction("CO");
        receipt.saveEx();
        MInOutLine receiptLine1 = new MInOutLine(receipt);
        receiptLine1.setOrderLine(line1, 0, new BigDecimal("10"));
        receiptLine1.setQty(new BigDecimal("10"));
        receiptLine1.saveEx();
        MInOutLine receiptLine2 = new MInOutLine(receipt);
        receiptLine2.setOrderLine(line2, 0, new BigDecimal("-1"));
        receiptLine2.setQty(new BigDecimal("-1"));
        receiptLine2.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        MInvoice invoice = new MInvoice(order, DictionaryIDs.C_DocType.AP_INVOICE.id, order.getDateOrdered());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine invoiceLine1 = new MInvoiceLine(invoice);
        invoiceLine1.setOrderLine(line1);
        invoiceLine1.setQty(new BigDecimal("10"));
        invoiceLine1.saveEx();
        MInvoiceLine invoiceLine2 = new MInvoiceLine(invoice);
        invoiceLine2.setOrderLine(line2);
        invoiceLine2.setQty(new BigDecimal("-1"));
        invoiceLine2.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
    }

    @Test
    public void testOrderedStorageForReactivatedOrder() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        BigDecimal qtyOrderedOriginal = this.getQtyOrdered(ctx, DictionaryIDs.M_Product.HOLLY_BUSH.id, trxName);
        MOrder order = new MOrder(ctx, 0, trxName);
        order.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)ctx, (int)DictionaryIDs.M_Product.HOLLY_BUSH.id));
        line1.setQty(THREE);
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(trxName, new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().compareTo(THREE));
        BigDecimal newQtyOrdered = this.getQtyOrdered(ctx, DictionaryIDs.M_Product.HOLLY_BUSH.id, trxName);
        Assertions.assertEquals((int)0, (int)qtyOrderedOriginal.add(THREE).compareTo(newQtyOrdered));
        MInOut receipt1 = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt1.setDocStatus("DR");
        receipt1.setDocAction("CO");
        receipt1.saveEx();
        MInOutLine receiptLine1 = new MInOutLine(receipt1);
        receiptLine1.setOrderLine(line1, 0, THREE);
        receiptLine1.setQty(THREE);
        receiptLine1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt1.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
        line1.load(trxName, new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().compareTo(Env.ZERO));
        newQtyOrdered = this.getQtyOrdered(ctx, DictionaryIDs.M_Product.HOLLY_BUSH.id, trxName);
        Assertions.assertEquals((int)0, (int)qtyOrderedOriginal.compareTo(newQtyOrdered));
        info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"RE");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"IP", (Object)order.getDocStatus());
        line1.load(trxName, new String[0]);
        line1.setQty(Env.ZERO);
        line1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(trxName, new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().compareTo(Env.ZERO));
        newQtyOrdered = this.getQtyOrdered(ctx, DictionaryIDs.M_Product.HOLLY_BUSH.id, trxName);
        Assertions.assertEquals((int)0, (int)qtyOrderedOriginal.compareTo(newQtyOrdered));
        MInOut receipt2 = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt2.setDocStatus("DR");
        receipt2.setDocAction("CO");
        receipt2.saveEx();
        MInOutLine receiptLine2 = new MInOutLine(receipt2);
        receiptLine2.setOrderLine(line1, 0, MINUS_THREE);
        receiptLine2.setQty(MINUS_THREE);
        receiptLine2.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt2, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt2.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt2.getDocStatus());
        line1.load(trxName, new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().compareTo(Env.ZERO));
        newQtyOrdered = this.getQtyOrdered(ctx, DictionaryIDs.M_Product.HOLLY_BUSH.id, trxName);
        Assertions.assertEquals((int)0, (int)qtyOrderedOriginal.compareTo(newQtyOrdered));
    }

    private BigDecimal getQtyOrdered(Properties ctx, int M_Product_ID, String trxName) {
        BigDecimal qtyOrdered = Env.ZERO;
        MStorageReservation[] mStorageReservationArray = MStorageReservation.getOfProduct((Properties)ctx, (int)M_Product_ID, (String)trxName);
        int n = mStorageReservationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MStorageReservation rs = mStorageReservationArray[n2];
            if (!rs.isSOTrx()) {
                qtyOrdered = qtyOrdered.add(rs.getQty());
            }
            ++n2;
        }
        return qtyOrdered;
    }

    @Test
    public void testMultiDateMaterialReceipt() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MProduct fert50 = new MProduct(ctx, DictionaryIDs.M_Product.FERTILIZER_50.id, trxName);
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        Timestamp past_month = TimeUtil.addMonths((Timestamp)today, (int)-1);
        MAttributeSetInstance asi = new MAttributeSetInstance(ctx, 0, trxName);
        asi.setM_AttributeSet_ID(fert50.getM_AttributeSet_ID());
        asi.setLot("2020");
        asi.saveEx();
        MOrder order = new MOrder(ctx, 0, trxName);
        order.setAD_Org_ID(DictionaryIDs.AD_Org.FERTILIZER.id);
        order.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID("WP");
        order.setIsSOTrx(false);
        order.setM_Warehouse_ID(DictionaryIDs.M_Warehouse.FERTILIZER.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setPaymentRule("P");
        order.setDateOrdered(past_month);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)ctx, (int)DictionaryIDs.M_Product.FERTILIZER_50.id));
        line1.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(past_month);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(trxName, new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
        Assertions.assertEquals((int)1, (int)line1.getQtyDelivered().intValue());
        Assertions.assertEquals((int)0, (int)line1.getQtyInvoiced().intValue());
        MOrder order2 = new MOrder(ctx, 0, trxName);
        order2.setAD_Org_ID(DictionaryIDs.AD_Org.FERTILIZER.id);
        order2.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.PATIO.id));
        order2.setIsSOTrx(false);
        order2.setC_DocTypeTarget_ID("WP");
        order2.setIsSOTrx(false);
        order2.setM_Warehouse_ID(DictionaryIDs.M_Warehouse.FERTILIZER.id);
        order2.setDocStatus("DR");
        order2.setDocAction("CO");
        order2.setPaymentRule("P");
        order2.setDateOrdered(today);
        order2.saveEx();
        MOrderLine line2 = new MOrderLine(order2);
        line2.setLine(10);
        line2.setProduct(MProduct.get((Properties)ctx, (int)DictionaryIDs.M_Product.FERTILIZER_50.id));
        line2.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        line2.setQty(new BigDecimal("1"));
        line2.setDatePromised(today);
        line2.saveEx();
        ProcessInfo info2 = MWorkflow.runDocumentActionWorkflow((PO)order2, (String)"CO");
        Assertions.assertFalse((boolean)info2.isError(), (String)info2.getSummary());
        order2.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order2.getDocStatus());
        line2.load(trxName, new String[0]);
        Assertions.assertEquals((int)0, (int)line2.getQtyReserved().intValue());
        Assertions.assertEquals((int)1, (int)line2.getQtyDelivered().intValue());
        Assertions.assertEquals((int)0, (int)line2.getQtyInvoiced().intValue());
        MStorageOnHand[] storages = MStorageOnHand.getWarehouse((Properties)ctx, (int)DictionaryIDs.M_Warehouse.FERTILIZER.id, (int)DictionaryIDs.M_Product.FERTILIZER_50.id, (int)asi.getM_AttributeSetInstance_ID(), null, (boolean)"F".equals(fert50.getMMPolicy()), (boolean)false, (int)0, (String)trxName);
        Assertions.assertEquals((int)2, (int)storages.length);
        int i = 0;
        while (i < storages.length) {
            MStorageOnHand storage = storages[i];
            Assertions.assertEquals((int)1, (int)storage.getQtyOnHand().intValue());
            if (i == 0) {
                Assertions.assertEquals((Object)past_month, (Object)storage.getDateMaterialPolicy());
            } else {
                Assertions.assertEquals((Object)today, (Object)storage.getDateMaterialPolicy());
            }
            ++i;
        }
    }

    @Test
    public void testQtyOrderedLog() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MOrder order = new MOrder(ctx, 0, trxName);
        order.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)ctx, (int)DictionaryIDs.M_Product.WEEDER.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        Query query = new Query(Env.getCtx(), "M_StorageReservationLog", "M_Product_ID=? AND IsSOTrx='N' AND M_Warehouse_ID=?", this.getTrxName());
        MStorageReservationLog log = (MStorageReservationLog)query.setOrderBy("M_StorageReservationLog_ID Desc").setParameters(new Object[]{DictionaryIDs.M_Product.WEEDER.id, line1.getM_Warehouse_ID()}).first();
        Assertions.assertNotNull((Object)log, (String)"MStorageReservationLog not created after completion of purchase order");
        Assertions.assertTrue((log.getDeltaQty().intValue() == 1 ? 1 : 0) != 0, (String)("Delta quantity of MStorageReservationLog != 1 (" + log.getDeltaQty().toPlainString() + ")"));
        MStorageReservation ordered = MStorageReservation.get((Properties)Env.getCtx(), (int)line1.getM_Warehouse_ID(), (int)DictionaryIDs.M_Product.WEEDER.id, (int)0, (boolean)false, (String)this.getTrxName());
        Assertions.assertTrue((boolean)log.getNewQty().equals(ordered.getQty()), (String)"New Qty from MStorageReservationLog != Qty from MStorageReservation");
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.setDocStatus("DR");
        receipt.setDocAction("CO");
        receipt.saveEx();
        MInOutLine receiptLine1 = new MInOutLine(receipt);
        receiptLine1.setOrderLine(line1, 0, new BigDecimal("1"));
        receiptLine1.setQty(new BigDecimal("1"));
        receiptLine1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        log = (MStorageReservationLog)query.first();
        Assertions.assertNotNull((Object)log, (String)"MStorageReservationLog not created after completion of material receipt");
        Assertions.assertTrue((log.getDeltaQty().intValue() == -1 ? 1 : 0) != 0, (String)("Delta quantity of MStorageReservationLog != -1 (" + log.getDeltaQty().toPlainString() + ")"));
        ordered = MStorageReservation.get((Properties)Env.getCtx(), (int)line1.getM_Warehouse_ID(), (int)DictionaryIDs.M_Product.WEEDER.id, (int)0, (boolean)false, (String)this.getTrxName());
        Assertions.assertTrue((boolean)log.getNewQty().equals(ordered.getQty()), (String)"New Qty from MStorageReservationLog != Qty from MStorageReservation");
    }

    @Test
    public void testQtyOverReceipt() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        DB.executeUpdateEx((String)"UPDATE AD_SysConfig SET Value='N' WHERE AD_Client_ID=0 AND Name=?", (Object[])new Object[]{"VALIDATE_MATCHING_TO_ORDERED_QTY"}, null);
        CacheMgt.get().reset();
        BigDecimal initialQtyOrdered = this.getQtyOrdered(Env.getCtx(), DictionaryIDs.M_Product.ROSE_BUSH.id, this.getTrxName());
        try {
            MOrder order = new MOrder(ctx, 0, trxName);
            order.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.PATIO.id));
            order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
            order.setIsSOTrx(false);
            order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
            order.setDocStatus("DR");
            order.setDocAction("CO");
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            order.setDateOrdered(today);
            order.setDatePromised(today);
            order.saveEx();
            MOrderLine line1 = new MOrderLine(order);
            line1.setLine(10);
            line1.setProduct(MProduct.get((Properties)ctx, (int)DictionaryIDs.M_Product.ROSE_BUSH.id));
            line1.setQty(new BigDecimal("1"));
            line1.setDatePromised(today);
            line1.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            order.load(trxName, new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus(), (String)"Order not completed");
            line1.load(trxName, new String[0]);
            Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue(), (String)"Wrong Order line qty reserved value");
            BigDecimal newQtyOrdered = this.getQtyOrdered(Env.getCtx(), DictionaryIDs.M_Product.ROSE_BUSH.id, this.getTrxName());
            Assertions.assertEquals((int)(initialQtyOrdered.intValue() + 1), (int)newQtyOrdered.intValue(), (String)"Quantiy Ordered not updated as expected");
            MInOut receipt1 = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
            receipt1.setDocStatus("DR");
            receipt1.setDocAction("CO");
            receipt1.saveEx();
            MInOutLine receiptLine1 = new MInOutLine(receipt1);
            receiptLine1.setOrderLine(line1, 0, new BigDecimal("2"));
            receiptLine1.setQty(new BigDecimal("2"));
            receiptLine1.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt1.load(trxName, new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus(), (String)"Material receipt not completed");
            line1.load(trxName, new String[0]);
            Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue(), (String)"Wrong order line qty reserved value");
            newQtyOrdered = this.getQtyOrdered(Env.getCtx(), DictionaryIDs.M_Product.ROSE_BUSH.id, this.getTrxName());
            Assertions.assertEquals((int)initialQtyOrdered.intValue(), (int)newQtyOrdered.intValue(), (String)"Quantiy Ordered not updated as expected");
            info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"RE");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            order.load(trxName, new String[0]);
            Assertions.assertEquals((Object)"IP", (Object)order.getDocStatus(), (String)"Order not reactivated");
            line1.load(trxName, new String[0]);
            line1.setQty(new BigDecimal("2"));
            line1.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            order.load(trxName, new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus(), (String)"Order not completed");
            line1.load(trxName, new String[0]);
            Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue(), (String)"Wrong order line qty reserved value");
            Assertions.assertEquals((int)2, (int)line1.getQtyOrdered().intValue(), (String)"Wrong order line qty ordered value");
            newQtyOrdered = this.getQtyOrdered(Env.getCtx(), DictionaryIDs.M_Product.ROSE_BUSH.id, this.getTrxName());
            Assertions.assertEquals((int)initialQtyOrdered.intValue(), (int)newQtyOrdered.intValue(), (String)"Quantiy Ordered not updated as expected");
            receiptLine1.load(trxName, new String[0]);
            Assertions.assertEquals((int)2, (int)receiptLine1.getMovementQty().intValue(), (String)"Wrong receipt line movement qty value");
            receipt1.load(trxName, new String[0]);
            receipt1.getLines(true);
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"RA");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt1.load(trxName, new String[0]);
            Assertions.assertEquals((Object)"RE", (Object)receipt1.getDocStatus(), (String)"Material receipt not reversed");
            line1.load(trxName, new String[0]);
            Assertions.assertEquals((int)2, (int)line1.getQtyReserved().intValue(), (String)"Wrong order line qty reserved value");
            Assertions.assertEquals((int)0, (int)line1.getQtyDelivered().intValue(), (String)"Wrong order line qty delivered value");
            newQtyOrdered = this.getQtyOrdered(Env.getCtx(), DictionaryIDs.M_Product.ROSE_BUSH.id, this.getTrxName());
            Assertions.assertEquals((int)(initialQtyOrdered.intValue() + 2), (int)newQtyOrdered.intValue(), (String)"Quantiy Ordered not updated as expected");
        }
        catch (Throwable throwable) {
            DB.executeUpdateEx((String)"UPDATE AD_SysConfig SET Value='Y' WHERE AD_Client_ID=0 AND Name=?", (Object[])new Object[]{"VALIDATE_MATCHING_TO_ORDERED_QTY"}, null);
            CacheMgt.get().reset();
            throw throwable;
        }
        DB.executeUpdateEx((String)"UPDATE AD_SysConfig SET Value='Y' WHERE AD_Client_ID=0 AND Name=?", (Object[])new Object[]{"VALIDATE_MATCHING_TO_ORDERED_QTY"}, null);
        CacheMgt.get().reset();
    }

    @Test
    public void testVendorRMA() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ROSE_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.setDocStatus("DR");
        receipt.setDocAction("CO");
        receipt.saveEx();
        MInOutLine receiptLine1 = new MInOutLine(receipt);
        receiptLine1.setOrderLine(line1, 0, new BigDecimal("1"));
        receiptLine1.setQty(new BigDecimal("1"));
        receiptLine1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        MRMA rma = new MRMA(Env.getCtx(), 0, this.getTrxName());
        rma.setM_InOut_ID(receipt.getM_InOut_ID());
        rma.setC_BPartner_ID(receipt.getC_BPartner_ID());
        rma.setC_Currency_ID(order.getC_Currency_ID());
        rma.setIsSOTrx(false);
        rma.setName("testVendorRMA");
        rma.setC_DocType_ID(DictionaryIDs.C_DocType.VENDOR_RETURN_MATERIAL.id);
        rma.setSalesRep_ID(order.getSalesRep_ID());
        rma.setM_RMAType_ID(DictionaryIDs.M_RMAType.DAMAGE_ON_ARRIVAL.id);
        rma.saveEx();
        MRMALine rmaLine = new MRMALine(Env.getCtx(), 0, this.getTrxName());
        rmaLine.setM_RMA_ID(rma.get_ID());
        rmaLine.setM_InOutLine_ID(receiptLine1.get_ID());
        rmaLine.setQty(receiptLine1.getMovementQty());
        rmaLine.saveEx();
        Assertions.assertEquals((int)0, (int)rmaLine.getQtyDelivered().intValue(), (String)"Unexpected RMA Line QtyDelivered value");
        info = MWorkflow.runDocumentActionWorkflow((PO)rma, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        rma.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)rma.getDocStatus());
        int AD_Process_ID = 52001;
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0, 0, null);
        instance.saveEx();
        String insert = "INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) Values (?, ?)";
        DB.executeUpdateEx((String)insert, (Object[])new Object[]{instance.getAD_PInstance_ID(), rma.get_ID()}, null);
        ProcessInfo pi = new ProcessInfo("InOutGenRMA", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        ip.saveEx();
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("DocAction", "CO");
        ip.saveEx();
        ip = new MPInstancePara(instance, 30);
        ip.setParameter("M_Warehouse_ID", this.getM_Warehouse_ID());
        ip.saveEx();
        ServerProcessCtl processCtl = new ServerProcessCtl(pi, this.getTrx());
        processCtl.setManagedTrxForJavaProcess(false);
        processCtl.run();
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        rmaLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)rmaLine.getQty().intValue(), (int)rmaLine.getQtyDelivered().intValue(), (String)"RMA Line QtyDelivered not updated by shipment for Vendor RMA");
    }

    @Test
    public void testInOutGenerateRMAManualMovementDate() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp currentDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentDate.getTime());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, -2);
        Timestamp date1 = new Timestamp(cal.getTimeInMillis());
        cal.setTimeInMillis(currentDate.getTime());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, -1);
        Timestamp date2 = new Timestamp(cal.getTimeInMillis());
        order.setDateOrdered(date1);
        order.setDatePromised(date1);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ROSE_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(date1);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.setDocStatus("DR");
        receipt.setDocAction("CO");
        receipt.saveEx();
        MInOutLine receiptLine1 = new MInOutLine(receipt);
        receiptLine1.setOrderLine(line1, 0, new BigDecimal("1"));
        receiptLine1.setQty(new BigDecimal("1"));
        receiptLine1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        MRMA rma = new MRMA(Env.getCtx(), 0, this.getTrxName());
        rma.setM_InOut_ID(receipt.getM_InOut_ID());
        rma.setC_BPartner_ID(receipt.getC_BPartner_ID());
        rma.setC_Currency_ID(order.getC_Currency_ID());
        rma.setIsSOTrx(false);
        rma.setName("testInOutGenerateRMAManualMovementDate");
        rma.setC_DocType_ID(DictionaryIDs.C_DocType.VENDOR_RETURN_MATERIAL.id);
        rma.setSalesRep_ID(order.getSalesRep_ID());
        rma.setM_RMAType_ID(DictionaryIDs.M_RMAType.DAMAGE_ON_ARRIVAL.id);
        rma.saveEx();
        MRMALine rmaLine = new MRMALine(Env.getCtx(), 0, this.getTrxName());
        rmaLine.setM_RMA_ID(rma.get_ID());
        rmaLine.setM_InOutLine_ID(receiptLine1.get_ID());
        rmaLine.setQty(receiptLine1.getMovementQty());
        rmaLine.saveEx();
        Assertions.assertEquals((int)0, (int)rmaLine.getQtyDelivered().intValue(), (String)"Unexpected RMA Line QtyDelivered value");
        info = MWorkflow.runDocumentActionWorkflow((PO)rma, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        rma.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)rma.getDocStatus());
        int AD_Process_ID = 52001;
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0, 0, null);
        instance.saveEx();
        String insert = "INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) Values (?, ?)";
        DB.executeUpdateEx((String)insert, (Object[])new Object[]{instance.getAD_PInstance_ID(), rma.get_ID()}, null);
        ProcessInfo pi = new ProcessInfo("InOutGenRMA", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        ip.saveEx();
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("DocAction", "CO");
        ip.saveEx();
        ip = new MPInstancePara(instance, 30);
        ip.setParameter("M_Warehouse_ID", this.getM_Warehouse_ID());
        ip.saveEx();
        ip = new MPInstancePara(instance, 40);
        ip.setParameter("MovementDate", date2);
        ip.saveEx();
        ServerProcessCtl processCtl = new ServerProcessCtl(pi, this.getTrx());
        processCtl.setManagedTrxForJavaProcess(false);
        processCtl.run();
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        rmaLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)rmaLine.getQty().intValue(), (int)rmaLine.getQtyDelivered().intValue(), (String)"RMA Line QtyDelivered not updated by shipment for Vendor RMA");
        int M_InOut_ID = DB.getSQLValueEx((String)this.getTrxName(), (String)"SELECT M_InOut_ID FROM M_InOut WHERE M_RMA_ID=?", (Object[])new Object[]{rma.getM_RMA_ID()});
        MInOut vendorReturn = new MInOut(Env.getCtx(), M_InOut_ID, this.getTrxName());
        Assertions.assertEquals((Object)date2, (Object)vendorReturn.getMovementDate());
        Assertions.assertEquals((Object)date2, (Object)vendorReturn.getDateAcct());
    }

    @Test
    public void testDeferredMatchedPOCreditQty() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MOrder order = new MOrder(ctx, 0, trxName);
        order.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line = new MOrderLine(order);
        line.setLine(10);
        line.setProduct(MProduct.get((Properties)ctx, (int)DictionaryIDs.M_Product.WEEDER.id));
        line.setQty(new BigDecimal("12"));
        line.setDatePromised(today);
        line.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.setDocStatus("DR");
        receipt.setDocAction("CO");
        receipt.saveEx();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setOrderLine(line, 0, new BigDecimal("10"));
        receiptLine.setQty(new BigDecimal("10"));
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        MInvoice invoice = new MInvoice(order, DictionaryIDs.C_DocType.AP_INVOICE.id, order.getDateOrdered());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setOrderLine(line);
        invoiceLine.setQty(new BigDecimal("12"));
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        MInvoice creditMemo = new MInvoice(order, DictionaryIDs.C_DocType.AP_CREDIT_MEMO.id, order.getDateOrdered());
        creditMemo.setDocStatus("DR");
        creditMemo.setDocAction("CO");
        creditMemo.saveEx();
        MInfoWindow infoWindow = MInfoWindow.get((int)200024, (String)trxName);
        String tableName = MTable.getTableName((Properties)Env.getCtx(), (int)infoWindow.getAD_Table_ID());
        String sql = "SELECT C_OrderLine_ID, CreditQty, Qty FROM " + tableName + " WHERE C_Order_ID=? ";
        List data = DB.getSQLValueObjectsEx((String)trxName, (String)sql, (Object[])new Object[]{order.getC_Order_ID()});
        Assertions.assertEquals((int)data.size(), (int)3);
        int C_OrderLine_ID = ((BigDecimal)data.get(0)).intValue();
        BigDecimal CreditQty = (BigDecimal)data.get(1);
        BigDecimal Qty = (BigDecimal)data.get(2);
        CreditQty = CreditQty.setScale(0);
        Qty = Qty.setScale(0);
        Assertions.assertEquals((int)line.getC_OrderLine_ID(), (int)C_OrderLine_ID);
        Assertions.assertEquals((Object)new BigDecimal("2"), (Object)CreditQty);
        Assertions.assertEquals((Object)new BigDecimal("0"), (Object)Qty);
        MInvoiceLine creditMemoLine = new MInvoiceLine(creditMemo);
        creditMemoLine.setOrderLine(line);
        creditMemoLine.setQty(CreditQty);
        creditMemoLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)creditMemo, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        creditMemo.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)creditMemo.getDocStatus());
    }

    @Test
    public void testDeferredMatchedPOCreditQtyNoMR() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MOrder order = new MOrder(ctx, 0, trxName);
        order.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line = new MOrderLine(order);
        line.setLine(10);
        line.setProduct(MProduct.get((Properties)ctx, (int)DictionaryIDs.M_Product.WEEDER.id));
        line.setQty(new BigDecimal("3"));
        line.setDatePromised(today);
        line.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInvoice invoice = new MInvoice(order, DictionaryIDs.C_DocType.AP_INVOICE.id, order.getDateOrdered());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setOrderLine(line);
        invoiceLine.setQty(new BigDecimal("3"));
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        MInvoice creditMemo = new MInvoice(order, DictionaryIDs.C_DocType.AP_CREDIT_MEMO.id, order.getDateOrdered());
        creditMemo.setDocStatus("DR");
        creditMemo.setDocAction("CO");
        creditMemo.saveEx();
        MInfoWindow infoWindow = MInfoWindow.get((int)200024, (String)trxName);
        String tableName = MTable.getTableName((Properties)Env.getCtx(), (int)infoWindow.getAD_Table_ID());
        String sql = "SELECT C_OrderLine_ID, CreditQty, Qty FROM " + tableName + " WHERE C_Order_ID=? ";
        List data = DB.getSQLValueObjectsEx((String)trxName, (String)sql, (Object[])new Object[]{order.getC_Order_ID()});
        Assertions.assertEquals((int)data.size(), (int)3);
        int C_OrderLine_ID = ((BigDecimal)data.get(0)).intValue();
        BigDecimal CreditQty = (BigDecimal)data.get(1);
        BigDecimal Qty = (BigDecimal)data.get(2);
        CreditQty = CreditQty.setScale(0);
        Qty = Qty.setScale(0);
        Assertions.assertEquals((int)line.getC_OrderLine_ID(), (int)C_OrderLine_ID);
        Assertions.assertEquals((Object)new BigDecimal("3"), (Object)CreditQty);
        Assertions.assertEquals((Object)new BigDecimal("0"), (Object)Qty);
        MInvoiceLine creditMemoLine = new MInvoiceLine(creditMemo);
        creditMemoLine.setOrderLine(line);
        creditMemoLine.setQty(CreditQty);
        creditMemoLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)creditMemo, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        creditMemo.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)creditMemo.getDocStatus());
    }

    @Test
    public void testDeferredMatchedPOCreditQtyMultiMR_1() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MOrder order = new MOrder(ctx, 0, trxName);
        order.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line = new MOrderLine(order);
        line.setLine(10);
        line.setProduct(MProduct.get((Properties)ctx, (int)DictionaryIDs.M_Product.WEEDER.id));
        line.setQty(new BigDecimal("1800"));
        line.setDatePromised(today);
        line.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInvoice invoice = new MInvoice(order, DictionaryIDs.C_DocType.AP_INVOICE.id, order.getDateOrdered());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setOrderLine(line);
        invoiceLine.setQty(new BigDecimal("1800"));
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        MInOut receipt1 = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt1.setDocStatus("DR");
        receipt1.setDocAction("CO");
        receipt1.saveEx();
        MInOutLine receiptLine1 = new MInOutLine(receipt1);
        receiptLine1.setOrderLine(line, 0, new BigDecimal("1763"));
        receiptLine1.setQty(new BigDecimal("1763"));
        receiptLine1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt1.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
        MInOut receipt2 = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt2.setDocStatus("DR");
        receipt2.setDocAction("CO");
        receipt2.saveEx();
        MInOutLine receiptLine2 = new MInOutLine(receipt2);
        receiptLine2.setOrderLine(line, 0, new BigDecimal("30"));
        receiptLine2.setQty(new BigDecimal("30"));
        receiptLine2.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt2, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt2.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt2.getDocStatus());
        MInvoice creditMemo = new MInvoice(order, DictionaryIDs.C_DocType.AP_CREDIT_MEMO.id, order.getDateOrdered());
        creditMemo.setDocStatus("DR");
        creditMemo.setDocAction("CO");
        creditMemo.saveEx();
        MInfoWindow infoWindow = MInfoWindow.get((int)200024, (String)trxName);
        String tableName = MTable.getTableName((Properties)Env.getCtx(), (int)infoWindow.getAD_Table_ID());
        String sql = "SELECT C_OrderLine_ID, CreditQty, Qty FROM " + tableName + " WHERE C_Order_ID=? ";
        List data = DB.getSQLValueObjectsEx((String)trxName, (String)sql, (Object[])new Object[]{order.getC_Order_ID()});
        Assertions.assertEquals((int)data.size(), (int)3);
        int C_OrderLine_ID = ((BigDecimal)data.get(0)).intValue();
        BigDecimal CreditQty = (BigDecimal)data.get(1);
        BigDecimal Qty = (BigDecimal)data.get(2);
        CreditQty = CreditQty.setScale(0);
        Qty = Qty.setScale(0);
        Assertions.assertEquals((int)line.getC_OrderLine_ID(), (int)C_OrderLine_ID);
        Assertions.assertEquals((Object)new BigDecimal("7"), (Object)CreditQty);
        Assertions.assertEquals((Object)new BigDecimal("0"), (Object)Qty);
        MInvoiceLine creditMemoLine = new MInvoiceLine(creditMemo);
        creditMemoLine.setOrderLine(line);
        creditMemoLine.setQty(CreditQty);
        creditMemoLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)creditMemo, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        creditMemo.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)creditMemo.getDocStatus());
    }

    @Test
    public void testDeferredMatchedPOCreditQtyMultiMR_2() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MOrder order = new MOrder(ctx, 0, trxName);
        order.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line = new MOrderLine(order);
        line.setLine(10);
        line.setProduct(MProduct.get((Properties)ctx, (int)DictionaryIDs.M_Product.WEEDER.id));
        line.setQty(new BigDecimal("1800"));
        line.setDatePromised(today);
        line.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt1 = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt1.setDocStatus("DR");
        receipt1.setDocAction("CO");
        receipt1.saveEx();
        MInOutLine receiptLine1 = new MInOutLine(receipt1);
        receiptLine1.setOrderLine(line, 0, new BigDecimal("1763"));
        receiptLine1.setQty(new BigDecimal("1763"));
        receiptLine1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt1.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
        MInOut receipt2 = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt2.setDocStatus("DR");
        receipt2.setDocAction("CO");
        receipt2.saveEx();
        MInOutLine receiptLine2 = new MInOutLine(receipt2);
        receiptLine2.setOrderLine(line, 0, new BigDecimal("30"));
        receiptLine2.setQty(new BigDecimal("30"));
        receiptLine2.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt2, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt2.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt2.getDocStatus());
        MInvoice invoice = new MInvoice(order, DictionaryIDs.C_DocType.AP_INVOICE.id, order.getDateOrdered());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setOrderLine(line);
        invoiceLine.setQty(new BigDecimal("1800"));
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        MInvoice creditMemo = new MInvoice(order, DictionaryIDs.C_DocType.AP_CREDIT_MEMO.id, order.getDateOrdered());
        creditMemo.setDocStatus("DR");
        creditMemo.setDocAction("CO");
        creditMemo.saveEx();
        MInfoWindow infoWindow = MInfoWindow.get((int)200024, (String)trxName);
        String tableName = MTable.getTableName((Properties)Env.getCtx(), (int)infoWindow.getAD_Table_ID());
        String sql = "SELECT C_OrderLine_ID, CreditQty, Qty FROM " + tableName + " WHERE C_Order_ID=? ";
        List data = DB.getSQLValueObjectsEx((String)trxName, (String)sql, (Object[])new Object[]{order.getC_Order_ID()});
        Assertions.assertEquals((int)data.size(), (int)3);
        int C_OrderLine_ID = ((BigDecimal)data.get(0)).intValue();
        BigDecimal CreditQty = (BigDecimal)data.get(1);
        BigDecimal Qty = (BigDecimal)data.get(2);
        CreditQty = CreditQty.setScale(0);
        Qty = Qty.setScale(0);
        Assertions.assertEquals((int)line.getC_OrderLine_ID(), (int)C_OrderLine_ID);
        Assertions.assertEquals((Object)new BigDecimal("7"), (Object)CreditQty);
        Assertions.assertEquals((Object)new BigDecimal("0"), (Object)Qty);
        MInvoiceLine creditMemoLine = new MInvoiceLine(creditMemo);
        creditMemoLine.setOrderLine(line);
        creditMemoLine.setQty(CreditQty);
        creditMemoLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)creditMemo, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        creditMemo.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)creditMemo.getDocStatus());
    }

    @Test
    public void testDeferredMatchedPOCreditQtyMultiLine() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MOrder order = new MOrder(ctx, 0, trxName);
        order.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)ctx, (int)DictionaryIDs.M_Product.ELM.id));
        line1.setQty(new BigDecimal("3"));
        line1.setDatePromised(today);
        line1.saveEx();
        MOrderLine line2 = new MOrderLine(order);
        line2.setLine(20);
        line2.setProduct(MProduct.get((Properties)ctx, (int)DictionaryIDs.M_Product.OAK.id));
        line2.setQty(new BigDecimal("3"));
        line2.setDatePromised(today);
        line2.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.setDocStatus("DR");
        receipt.setDocAction("CO");
        receipt.saveEx();
        MInOutLine receiptLine1 = new MInOutLine(receipt);
        receiptLine1.setOrderLine(line1, 0, new BigDecimal("3"));
        receiptLine1.setQty(new BigDecimal("3"));
        receiptLine1.saveEx();
        MInOutLine receiptLine2 = new MInOutLine(receipt);
        receiptLine2.setOrderLine(line2, 0, new BigDecimal("2"));
        receiptLine2.setQty(new BigDecimal("2"));
        receiptLine2.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        MInvoice invoice = new MInvoice(order, DictionaryIDs.C_DocType.AP_INVOICE.id, order.getDateOrdered());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine invoiceLine1 = new MInvoiceLine(invoice);
        invoiceLine1.setOrderLine(line1);
        invoiceLine1.setQty(new BigDecimal("3"));
        invoiceLine1.saveEx();
        MInvoiceLine invoiceLine2 = new MInvoiceLine(invoice);
        invoiceLine2.setOrderLine(line2);
        invoiceLine2.setQty(new BigDecimal("3"));
        invoiceLine2.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        MInvoice creditMemo = new MInvoice(order, DictionaryIDs.C_DocType.AP_CREDIT_MEMO.id, order.getDateOrdered());
        creditMemo.setDocStatus("DR");
        creditMemo.setDocAction("CO");
        creditMemo.saveEx();
        MInfoWindow infoWindow = MInfoWindow.get((int)200024, (String)trxName);
        String tableName = MTable.getTableName((Properties)Env.getCtx(), (int)infoWindow.getAD_Table_ID());
        String sql = "SELECT CreditQty, Qty FROM " + tableName + " WHERE C_Order_ID=? AND C_OrderLine_ID=?";
        List data = DB.getSQLValueObjectsEx((String)trxName, (String)sql, (Object[])new Object[]{order.getC_Order_ID(), line1.getC_OrderLine_ID()});
        Assertions.assertTrue((data == null ? 1 : 0) != 0);
        data = DB.getSQLValueObjectsEx((String)trxName, (String)sql, (Object[])new Object[]{order.getC_Order_ID(), line2.getC_OrderLine_ID()});
        Assertions.assertEquals((int)data.size(), (int)2);
        BigDecimal CreditQty = (BigDecimal)data.get(0);
        BigDecimal Qty = (BigDecimal)data.get(1);
        CreditQty = CreditQty.setScale(0);
        Qty = Qty.setScale(0);
        Assertions.assertEquals((Object)new BigDecimal("1"), (Object)CreditQty);
        Assertions.assertEquals((Object)new BigDecimal("0"), (Object)Qty);
        MInvoiceLine creditMemoLine = new MInvoiceLine(creditMemo);
        creditMemoLine.setOrderLine(line2);
        creditMemoLine.setQty(CreditQty);
        creditMemoLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)creditMemo, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        creditMemo.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)creditMemo.getDocStatus());
    }
}

