/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.commission;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MCommission;
import org.compiere.model.MCommissionAmt;
import org.compiere.model.MCommissionLine;
import org.compiere.model.MCommissionRun;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoLog;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CommissionRunTest
extends AbstractTestCase {
    private static final int PROCESS_GENERATE_COMMISSION = 123;

    @Test
    public void testCommissionOnInvoice() {
        MPInstancePara[] paras;
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        MCommission com = new MCommission(ctx, 0, trxName);
        com.setName("Test commission to pay GardenUser 10% on own invoices");
        com.setC_BPartner_ID(DictionaryIDs.C_BPartner.GARDEN_USER.id);
        com.setC_Charge_ID(DictionaryIDs.C_Charge.COMMISSIONS.id);
        com.setC_Currency_ID(DictionaryIDs.C_Currency.USD.id);
        com.setDocBasisType("I");
        com.setFrequencyType("M");
        com.setListDetails(true);
        com.saveEx();
        MCommissionLine coml = new MCommissionLine(ctx, 0, trxName);
        coml.setC_Commission_ID(com.getC_Commission_ID());
        coml.setLine(10);
        coml.setCommissionOrders(true);
        coml.setAmtMultiplier(BigDecimal.valueOf(0.1));
        coml.saveEx();
        MInvoice invoice = new MInvoice(ctx, 0, trxName);
        invoice.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.C_AND_W.id));
        invoice.setC_DocTypeTarget_ID("ARI");
        invoice.setC_DocType_ID(invoice.getC_DocTypeTarget_ID());
        invoice.setPaymentRule("S");
        invoice.setC_PaymentTerm_ID(DictionaryIDs.C_PaymentTerm.IMMEDIATE.id);
        invoice.setDateInvoiced(today);
        invoice.setDateAcct(today);
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_USER.id);
        invoice.saveEx();
        MInvoiceLine line1 = new MInvoiceLine(invoice);
        line1.setLine(10);
        line1.setM_Product_ID(DictionaryIDs.M_Product.AZALEA_BUSH.id);
        line1.setQty(new BigDecimal("7"));
        line1.setPrice(BigDecimal.valueOf(23.75));
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        invoice.load(trxName, new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)("Error processing invoice: " + info.getSummary()));
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus(), (String)("Invoice document status is not completed: " + invoice.getDocStatus()));
        MInvoice creditMemo = new MInvoice(ctx, 0, trxName);
        creditMemo.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.C_AND_W.id));
        creditMemo.setC_DocTypeTarget_ID("ARC");
        creditMemo.setC_DocType_ID(creditMemo.getC_DocTypeTarget_ID());
        creditMemo.setPaymentRule("S");
        creditMemo.setC_PaymentTerm_ID(DictionaryIDs.C_PaymentTerm.IMMEDIATE.id);
        creditMemo.setDateInvoiced(today);
        creditMemo.setDateAcct(today);
        creditMemo.setDocStatus("DR");
        creditMemo.setDocAction("CO");
        creditMemo.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_USER.id);
        creditMemo.saveEx();
        MInvoiceLine line1cm = new MInvoiceLine(creditMemo);
        line1cm.setLine(10);
        line1cm.setM_Product_ID(DictionaryIDs.M_Product.AZALEA_BUSH.id);
        line1cm.setQty(new BigDecimal("2"));
        line1cm.setPrice(BigDecimal.valueOf(23.75));
        line1cm.saveEx();
        ProcessInfo infocm = MWorkflow.runDocumentActionWorkflow((PO)creditMemo, (String)"CO");
        creditMemo.load(trxName, new String[0]);
        Assertions.assertFalse((boolean)infocm.isError(), (String)("Error processing invoice: " + infocm.getSummary()));
        Assertions.assertEquals((Object)"CO", (Object)creditMemo.getDocStatus(), (String)("Credit Memo document status is not completed: " + creditMemo.getDocStatus()));
        MProcess process = MProcess.get((int)123);
        MPInstance pinstance = new MPInstance(process, 0, 0, null);
        MPInstancePara[] mPInstanceParaArray = paras = pinstance.getParameters();
        int n = paras.length;
        int n2 = 0;
        while (n2 < n) {
            MPInstancePara para = mPInstanceParaArray[n2];
            if (para.getParameterName().equals("StartDate")) {
                para.setP_Date(today);
                para.saveEx();
            }
            ++n2;
        }
        ProcessInfo pi = new ProcessInfo(process.getName(), 123);
        pi.setAD_PInstance_ID(pinstance.getAD_PInstance_ID());
        pi.setRecord_ID(com.getC_Commission_ID());
        process.processIt(pi, Trx.get((String)this.getTrxName(), (boolean)false), false);
        Assertions.assertTrue((!pi.isError() ? 1 : 0) != 0, (String)pi.getSummary());
        ProcessInfoLog[] logs = pi.getLogs();
        MCommissionRun comrun = new MCommissionRun(ctx, logs[0].getRecord_ID(), trxName);
        MCommissionAmt[] amts = comrun.getAmts();
        Assertions.assertTrue((BigDecimal.valueOf(118.75).compareTo(amts[0].getConvertedAmt()) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((BigDecimal.valueOf(5L).compareTo(amts[0].getActualQty()) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((BigDecimal.valueOf(11.875).compareTo(amts[0].getCommissionAmt()) == 0 ? 1 : 0) != 0);
    }
}

