/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.UUIDGenerator;
import org.compiere.model.AccessSqlParser;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MColumnAccess;
import org.compiere.model.MDocType;
import org.compiere.model.MForm;
import org.compiere.model.MOrg;
import org.compiere.model.MPrivateAccess;
import org.compiere.model.MProcess;
import org.compiere.model.MRecordAccess;
import org.compiere.model.MRoleOrgAccess;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MTableAccess;
import org.compiere.model.MTableValRule;
import org.compiere.model.MTask;
import org.compiere.model.MTree_Base;
import org.compiere.model.MUserOrgAccess;
import org.compiere.model.MUserRoles;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Role;
import org.compiere.model.X_AD_Role_Included;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trace;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflow;
import org.idempiere.cache.ImmutablePOSupport;
import org.idempiere.cache.POCopyCache;

public final class MRole
extends X_AD_Role
implements ImmutablePOSupport {
    private static final long serialVersionUID = -8473945674135719367L;
    private static POCopyCache<String, MRole> s_roles = new POCopyCache("AD_Role", 5);
    private static CLogger s_log = CLogger.getCLogger(MRole.class);
    public static final boolean SQL_RW = true;
    public static final boolean SQL_RO = false;
    public static final boolean SQL_FULLYQUALIFIED = true;
    public static final boolean SQL_NOTQUALIFIED = false;
    public static final int SUPERUSER_USER_ID = 100;
    public static final int SYSTEM_USER_ID = 10;
    private static final String ROLE_KEY = "org.compiere.model.DefaultRole";
    private int m_AD_User_ID = -1;
    private OrgAccess[] m_orgAccess = null;
    private MTableAccess[] m_tableAccess = null;
    private MColumnAccess[] m_columnAccess = null;
    private MRecordAccess[] m_recordAccess = null;
    private MRecordAccess[] m_recordDependentAccess = null;
    private HashMap<Integer, Boolean> m_windowAccess = null;
    private HashMap<Integer, Boolean> m_processAccess = null;
    private HashMap<Integer, Boolean> m_taskAccess = null;
    private HashMap<Integer, Boolean> m_workflowAccess = null;
    private HashMap<Integer, Boolean> m_formAccess = null;
    private HashMap<Integer, Boolean> m_infoAccess;
    private List<MRole> m_includedRoles = null;
    private MRole m_parent = null;
    private int m_includedSeqNo = -1;
    private Boolean m_canAccess_Info_Product = null;

    public static MRole getDefault() {
        return MRole.getDefault(Env.getCtx(), false);
    }

    public static MRole getDefault(Properties ctx, boolean reload) {
        if (MSysConfig.getBooleanValue("MROLE_GETDEFAULT_RETURNS_NULL_WHEN_NO_CONTEXT", true) && (Util.isEmpty(Env.getContext(ctx, "#AD_Role_ID")) || Util.isEmpty(Env.getContext(ctx, "#AD_User_ID")))) {
            return null;
        }
        int AD_Role_ID = Env.getContextAsInt(ctx, "#AD_Role_ID");
        int AD_User_ID = Env.getContextAsInt(ctx, "#AD_User_ID");
        MRole defaultRole = MRole.getDefaultRole(ctx, AD_Role_ID, AD_User_ID);
        if (reload || defaultRole == null) {
            defaultRole = MRole.get(ctx, AD_Role_ID, AD_User_ID, reload);
            MRole.setDefaultRole(defaultRole);
        } else if (defaultRole.getAD_Role_ID() != AD_Role_ID || defaultRole.getAD_User_ID() != AD_User_ID) {
            defaultRole = MRole.get(ctx, AD_Role_ID, AD_User_ID, reload);
            MRole.setDefaultRole(defaultRole);
        }
        return defaultRole;
    }

    public static KeyNamePair[] getRoleKeyNamePairs() {
        String sql = MRole.getDefault().addAccessSQL("SELECT AD_Role_ID, Name FROM AD_Role WHERE AD_Client_ID=? AND IsActive='Y' ORDER BY 2", "AD_Role", false, false);
        return DB.getKeyNamePairsEx(sql, false, Env.getAD_Client_ID(Env.getCtx()));
    }

    private static void setDefaultRole(MRole defaultRole) {
        Env.getCtx().remove(ROLE_KEY);
        Env.getCtx().put(ROLE_KEY, defaultRole);
    }

    private static MRole getDefaultRole() {
        return MRole.getDefaultRole(Env.getCtx(), Env.getAD_Role_ID(Env.getCtx()), Env.getAD_User_ID(Env.getCtx()));
    }

    private static MRole getDefaultRole(Properties ctx, int AD_Role_ID, int AD_User_ID) {
        MRole role = (MRole)ctx.get(ROLE_KEY);
        String key = AD_Role_ID + "_" + AD_User_ID;
        if (!s_roles.containsKey(key)) {
            ctx.remove(ROLE_KEY);
            role = null;
        }
        return role;
    }

    public static synchronized MRole get(Properties ctx, int AD_Role_ID, int AD_User_ID, boolean reload) {
        String key;
        MRole role;
        if (s_log.isLoggable(Level.CONFIG)) {
            s_log.config("AD_Role_ID=" + AD_Role_ID + ", AD_User_ID=" + AD_User_ID + ", reload=" + reload);
        }
        if ((role = s_roles.get(key = AD_Role_ID + "_" + AD_User_ID, e -> new MRole(ctx, (MRole)e))) == null || reload) {
            role = new MRole(ctx, AD_Role_ID, null);
            if (AD_Role_ID == 0) {
                String trxName = null;
                role.load(trxName, new String[0]);
            }
            role.setAD_User_ID(AD_User_ID);
            role.loadAccess(reload);
            s_roles.put(key, role, e -> new MRole(Env.getCtx(), (MRole)e));
            if (s_log.isLoggable(Level.INFO)) {
                s_log.info(role.toString());
            }
        }
        return role;
    }

    public static MRole get(Properties ctx, int AD_Role_ID) {
        return MRole.get(ctx, AD_Role_ID, Env.getAD_User_ID(ctx), false);
    }

    public static MRole[] getOfClient(Properties ctx) {
        return MRole.getOfClient(ctx, null);
    }

    public static MRole[] getOfClient(Properties ctx, String trxName) {
        ArrayList<MRole> list;
        block6: {
            String sql = "SELECT * FROM AD_Role WHERE AD_Client_ID=?";
            list = new ArrayList<MRole>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, Env.getAD_Client_ID(ctx));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MRole(ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MRole[] retValue = new MRole[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MRole[] getOf(Properties ctx, String whereClause) {
        ArrayList<MRole> list;
        block7: {
            Object sql = "SELECT * FROM AD_Role";
            if (whereClause != null && whereClause.length() > 0) {
                sql = (String)sql + " WHERE " + whereClause;
            }
            list = new ArrayList<MRole>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MRole(ctx, rs, null));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, (String)sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MRole[] retValue = new MRole[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MRole(Properties ctx, String AD_Role_UU, String trxName) {
        super(ctx, AD_Role_UU, trxName);
        if (Util.isEmpty(AD_Role_UU)) {
            this.setInitialDefaults();
        }
    }

    public MRole(Properties ctx, int AD_Role_ID, String trxName) {
        super(ctx, AD_Role_ID, trxName);
        if (AD_Role_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setIsCanExport(true);
        this.setIsCanReport(true);
        this.setIsManual(false);
        this.setIsPersonalAccess(false);
        this.setIsPersonalLock(false);
        this.setIsShowAcct(false);
        this.setIsAccessAllOrgs(false);
        this.setUserLevel("  O");
        this.setPreferenceType("O");
        this.setIsChangeLog(false);
        this.setOverwritePriceLimit(false);
        this.setIsUseUserOrgAccess(false);
        this.setMaxQueryRecords(0);
        this.setConfirmQueryRecords(0);
    }

    public MRole(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRole(MRole copy) {
        this(Env.getCtx(), copy);
    }

    public MRole(Properties ctx, MRole copy) {
        this(ctx, copy, null);
    }

    public MRole(Properties ctx, MRole copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_AD_User_ID = copy.m_AD_User_ID;
        this.m_orgAccess = copy.m_orgAccess != null ? Arrays.copyOf(copy.m_orgAccess, copy.m_orgAccess.length) : null;
        this.m_tableAccess = copy.m_tableAccess != null ? Arrays.copyOf(copy.m_tableAccess, copy.m_tableAccess.length) : null;
        this.m_columnAccess = copy.m_columnAccess != null ? Arrays.copyOf(copy.m_columnAccess, copy.m_columnAccess.length) : null;
        this.m_recordAccess = copy.m_recordAccess != null ? Arrays.copyOf(copy.m_recordAccess, copy.m_recordAccess.length) : null;
        this.m_recordDependentAccess = copy.m_recordDependentAccess != null ? Arrays.copyOf(copy.m_recordDependentAccess, copy.m_recordDependentAccess.length) : null;
        this.m_windowAccess = copy.m_windowAccess != null ? new HashMap<Integer, Boolean>(copy.m_windowAccess) : null;
        this.m_processAccess = copy.m_processAccess != null ? new HashMap<Integer, Boolean>(copy.m_processAccess) : null;
        this.m_taskAccess = copy.m_taskAccess != null ? new HashMap<Integer, Boolean>(copy.m_taskAccess) : null;
        this.m_workflowAccess = copy.m_workflowAccess != null ? new HashMap<Integer, Boolean>(copy.m_workflowAccess) : null;
        this.m_formAccess = copy.m_formAccess != null ? new HashMap<Integer, Boolean>(copy.m_formAccess) : null;
        this.m_infoAccess = copy.m_infoAccess != null ? new HashMap<Integer, Boolean>(copy.m_infoAccess) : null;
        this.m_includedRoles = copy.m_includedRoles != null ? new ArrayList<MRole>(copy.m_includedRoles) : null;
        this.m_parent = copy.m_parent != null ? new MRole(ctx, copy.m_parent, trxName) : null;
        this.m_includedSeqNo = copy.m_includedSeqNo;
        this.m_canAccess_Info_Product = copy.m_canAccess_Info_Product;
    }

    @Override
    public int getConfirmQueryRecords() {
        int no = super.getConfirmQueryRecords();
        if (no == 0) {
            return 500;
        }
        return no;
    }

    @Deprecated
    public boolean isQueryRequire(int noRecords) {
        if (noRecords < 2) {
            return false;
        }
        int max = this.getMaxQueryRecords();
        if (max > 0 && noRecords > max) {
            return true;
        }
        int qu = this.getConfirmQueryRecords();
        return noRecords > qu;
    }

    @Deprecated
    public boolean isQueryMax(int noRecords) {
        int max = this.getMaxQueryRecords();
        return max > 0 && noRecords > max;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Client_ID() == 0) {
            this.setUserLevel("S  ");
        } else if (this.getUserLevel().equals("S  ")) {
            this.log.saveError("AccessTableNoUpdate", Msg.getElement(this.getCtx(), "UserLevel"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord && success) {
            MUserRoles su = new MUserRoles(this.getCtx(), 100, this.getAD_Role_ID(), this.get_TrxName());
            su.saveEx();
            if (this.getCreatedBy() != 100 && MSysConfig.getBooleanValue("AUTO_ASSIGN_ROLE_TO_CREATOR_USER", false, this.getAD_Client_ID())) {
                MUserRoles ur = new MUserRoles(this.getCtx(), this.getCreatedBy(), this.getAD_Role_ID(), this.get_TrxName());
                ur.saveEx();
            }
            this.updateAccessRecords();
        } else if (this.is_ValueChanged("UserLevel")) {
            this.updateAccessRecords();
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            this.deleteAccessRecords();
        }
        return success;
    }

    public String updateAccessRecords() {
        return this.updateAccessRecords(true);
    }

    public String updateAccessRecords(boolean reset) {
        if (this.isManual()) {
            return "-";
        }
        String roleClientOrgUser = this.getAD_Role_ID() + "," + this.getAD_Client_ID() + "," + this.getAD_Org_ID() + ",'Y', getDate()," + this.getUpdatedBy() + ", getDate()," + this.getUpdatedBy() + ",'Y' ";
        String sqlWindow = "INSERT INTO AD_Window_Access (AD_Window_ID, AD_Role_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,IsReadWrite) SELECT DISTINCT w.AD_Window_ID, " + roleClientOrgUser + "FROM AD_Window w INNER JOIN AD_Tab t ON (w.AD_Window_ID=t.AD_Window_ID) INNER JOIN AD_Table tt ON (t.AD_Table_ID=tt.AD_Table_ID)  LEFT JOIN AD_Window_Access wa ON (wa.AD_Role_ID=" + this.getAD_Role_ID() + " AND w.AD_Window_ID = wa.AD_Window_ID) WHERE w.IsActive = 'Y' AND wa.AD_Window_ID IS NULL AND t.SeqNo=(SELECT MIN(SeqNo) FROM AD_Tab xt WHERE xt.AD_Window_ID=w.AD_Window_ID) AND tt.AccessLevel IN ";
        String sqlProcess = "INSERT INTO AD_Process_Access (AD_Process_ID, AD_Role_ID, AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, IsReadWrite) SELECT DISTINCT p.AD_Process_ID, " + roleClientOrgUser + "FROM AD_Process p LEFT JOIN AD_Process_Access pa ON (pa.AD_Role_ID=" + this.getAD_Role_ID() + " AND p.AD_Process_ID = pa.AD_Process_ID) WHERE p.IsActive = 'Y' AND pa.AD_Process_ID IS NULL AND AccessLevel IN ";
        String sqlForm = "INSERT INTO AD_Form_Access (AD_Form_ID, AD_Role_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,IsReadWrite) SELECT f.AD_Form_ID, " + roleClientOrgUser + "FROM AD_Form f LEFT JOIN AD_Form_Access fa ON (fa.AD_Role_ID=" + this.getAD_Role_ID() + " AND f.AD_Form_ID = fa.AD_Form_ID) WHERE f.IsActive = 'Y' AND fa.AD_Form_ID IS NULL AND AccessLevel IN ";
        String sqlWorkflow = "INSERT INTO AD_WorkFlow_Access (AD_WorkFlow_ID, AD_Role_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,IsReadWrite) SELECT w.AD_WorkFlow_ID, " + roleClientOrgUser + "FROM AD_WorkFlow w LEFT JOIN AD_WorkFlow_Access wa ON (wa.AD_Role_ID=" + this.getAD_Role_ID() + " AND w.AD_WorkFlow_ID = wa.AD_WorkFlow_ID) WHERE w.IsActive = 'Y' AND w.AD_Client_ID IN (0," + this.getAD_Client_ID() + ") AND wa.AD_WorkFlow_ID IS NULL AND AccessLevel IN ";
        String sqlDocAction = "INSERT INTO AD_Document_Action_Access (AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,C_DocType_ID , AD_Ref_List_ID, AD_Role_ID) (SELECT " + this.getAD_Client_ID() + ",0,'Y', getDate()," + this.getUpdatedBy() + ", getDate()," + this.getUpdatedBy() + ", doctype.C_DocType_ID, action.AD_Ref_List_ID, rol.AD_Role_ID FROM AD_Client client INNER JOIN C_DocType doctype ON (doctype.AD_Client_ID=client.AD_Client_ID) INNER JOIN AD_Ref_List action ON (action.AD_Reference_ID=135) INNER JOIN AD_Role rol ON (rol.AD_Client_ID=client.AD_Client_ID AND rol.AD_Role_ID=" + this.getAD_Role_ID() + ") LEFT JOIN AD_Document_Action_Access da ON (da.AD_Role_ID=" + this.getAD_Role_ID() + " AND da.C_DocType_ID=doctype.C_DocType_ID AND da.AD_Ref_List_ID=action.AD_Ref_List_ID) WHERE doctype.IsActive = 'Y' AND  (da.C_DocType_ID IS NULL AND da.AD_Ref_List_ID IS NULL)) ";
        String sqlInfo = "INSERT INTO AD_InfoWindow_Access (AD_InfoWindow_ID, AD_Role_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy) SELECT i.AD_InfoWindow_ID," + this.getAD_Role_ID() + "," + this.getAD_Client_ID() + "," + this.getAD_Org_ID() + ",'Y',getDate()," + this.getUpdatedBy() + ", getDate()," + this.getUpdatedBy() + " FROM AD_InfoWindow i LEFT JOIN AD_InfoWindow_Access ia ON (ia.AD_Role_ID=" + this.getAD_Role_ID() + " AND i.AD_InfoWindow_ID = ia.AD_InfoWindow_ID)  INNER JOIN AD_Table tt ON (i.AD_Table_ID=tt.AD_Table_ID) WHERE i.IsActive = 'Y' AND i.AD_Client_ID IN (0," + this.getAD_Client_ID() + ") AND ia.AD_InfoWindow_ID IS NULL AND tt.AccessLevel IN ";
        String roleAccessLevel = null;
        Object roleAccessLevelWin = null;
        if ("S  ".equals(this.getUserLevel())) {
            roleAccessLevel = "('4','7','6')";
        } else if (" C ".equals(this.getUserLevel())) {
            roleAccessLevel = "('7','6','3','2')";
        } else if (" CO".equals(this.getUserLevel())) {
            roleAccessLevel = "('7','6','3','2','1')";
        } else {
            roleAccessLevel = "('3','1','7')";
            roleAccessLevelWin = roleAccessLevel + " AND w.Name NOT LIKE '%(all)%'";
        }
        if (roleAccessLevelWin == null) {
            roleAccessLevelWin = roleAccessLevel;
        }
        if (reset) {
            this.deleteAccessRecords();
        }
        int win = DB.executeUpdateEx(sqlWindow + (String)roleAccessLevelWin, this.get_TrxName());
        int proc = DB.executeUpdateEx(sqlProcess + roleAccessLevel, this.get_TrxName());
        int form = DB.executeUpdateEx(sqlForm + roleAccessLevel, this.get_TrxName());
        int wf = DB.executeUpdateEx(sqlWorkflow + roleAccessLevel, this.get_TrxName());
        int docact = DB.executeUpdateEx(sqlDocAction, this.get_TrxName());
        int info = DB.executeUpdateEx(sqlInfo + roleAccessLevel, this.get_TrxName());
        if (DB.isGenerateUUIDSupported()) {
            DB.executeUpdateEx("UPDATE AD_Window_Access SET AD_Window_Access_UU=generate_uuid() WHERE AD_Window_Access_UU IS NULL", this.get_TrxName());
            DB.executeUpdateEx("UPDATE AD_Process_Access SET AD_Process_Access_UU=generate_uuid() WHERE AD_Process_Access_UU IS NULL", this.get_TrxName());
            DB.executeUpdateEx("UPDATE AD_Form_Access SET AD_Form_Access_UU=generate_uuid() WHERE AD_Form_Access_UU IS NULL", this.get_TrxName());
            DB.executeUpdateEx("UPDATE AD_Workflow_Access SET AD_Workflow_Access_UU=generate_uuid() WHERE AD_Workflow_Access_UU IS NULL", this.get_TrxName());
            DB.executeUpdateEx("UPDATE AD_Document_Action_Access SET AD_Document_Action_Access_UU=generate_uuid() WHERE AD_Document_Action_Access_UU IS NULL", this.get_TrxName());
            DB.executeUpdateEx("UPDATE AD_InfoWindow_Access SET AD_InfoWindow_Access_UU=generate_uuid() WHERE AD_InfoWindow_Access_UU IS NULL", this.get_TrxName());
        } else {
            UUIDGenerator.updateUUID(MColumn.get(this.getCtx(), "AD_Window_Access", PO.getUUIDColumnName("AD_Window_Access")), this.get_TrxName());
            UUIDGenerator.updateUUID(MColumn.get(this.getCtx(), "AD_Process_Access", PO.getUUIDColumnName("AD_Process_Access")), this.get_TrxName());
            UUIDGenerator.updateUUID(MColumn.get(this.getCtx(), "AD_Form_Access", PO.getUUIDColumnName("AD_Form_Access")), this.get_TrxName());
            UUIDGenerator.updateUUID(MColumn.get(this.getCtx(), "AD_Workflow_Access", PO.getUUIDColumnName("AD_Workflow_Access")), this.get_TrxName());
            UUIDGenerator.updateUUID(MColumn.get(this.getCtx(), "AD_Document_Action_Access", PO.getUUIDColumnName("AD_Document_Action_Access")), this.get_TrxName());
            UUIDGenerator.updateUUID(MColumn.get(this.getCtx(), "AD_InfoWindow_Access", PO.getUUIDColumnName("AD_InfoWindow_Access")), this.get_TrxName());
        }
        this.loadAccess(true);
        return Msg.parseTranslation(this.getCtx(), "@AD_Window_ID@ #" + win + " -  @AD_Process_ID@ #" + proc + " -  @AD_Form_ID@ #" + form + " -  @AD_Workflow_ID@ #" + wf + " -  @DocAction@ #" + docact + " -  @AD_InfoWindow_ID@ #" + info);
    }

    private void deleteAccessRecords() {
        String whereDel = " WHERE AD_Role_ID=" + this.getAD_Role_ID();
        int winDel = DB.executeUpdateEx("DELETE FROM AD_Window_Access" + whereDel, this.get_TrxName());
        int procDel = DB.executeUpdateEx("DELETE FROM AD_Process_Access" + whereDel, this.get_TrxName());
        int formDel = DB.executeUpdateEx("DELETE FROM AD_Form_Access" + whereDel, this.get_TrxName());
        int wfDel = DB.executeUpdateEx("DELETE FROM AD_WorkFlow_Access" + whereDel, this.get_TrxName());
        int docactDel = DB.executeUpdateEx("DELETE FROM AD_Document_Action_Access" + whereDel, this.get_TrxName());
        int infoDel = DB.executeUpdateEx("DELETE FROM AD_InfoWindow_Access" + whereDel, this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("AD_Window_Access=" + winDel + ", AD_Process_Access=" + procDel + ", AD_Form_Access=" + formDel + ", AD_Workflow_Access=" + wfDel + ", AD_Document_Action_Access=" + docactDel + ", AD_InfoWindow_Access=" + infoDel);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MRole[");
        sb.append(this.getAD_Role_ID()).append(",").append(this.getName()).append(",UserLevel=").append(this.getUserLevel()).append(",").append(this.getClientWhere(false)).append(",").append(this.getOrgWhere(false)).append("]");
        return sb.toString();
    }

    public String toStringX(Properties ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append(Msg.translate(ctx, "AD_Role_ID")).append("=").append(this.getName()).append(" - ").append(Msg.translate(ctx, "IsCanExport")).append("=").append(Msg.translate(ctx, String.valueOf(this.isCanExport()))).append(" - ").append(Msg.translate(ctx, "IsCanReport")).append("=").append(Msg.translate(ctx, String.valueOf(this.isCanReport()))).append(Env.NL).append(Env.NL);
        int i = 0;
        while (i < this.m_orgAccess.length) {
            sb.append(this.m_orgAccess[i].toString()).append(Env.NL);
            ++i;
        }
        sb.append(Env.NL);
        this.loadTableAccess(false);
        i = 0;
        while (i < this.m_tableAccess.length) {
            sb.append(this.m_tableAccess[i].toStringX(ctx)).append(Env.NL);
            ++i;
        }
        if (this.m_tableAccess.length > 0) {
            sb.append(Env.NL);
        }
        this.loadColumnAccess(false);
        i = 0;
        while (i < this.m_columnAccess.length) {
            sb.append(this.m_columnAccess[i].toStringX(ctx)).append(Env.NL);
            ++i;
        }
        if (this.m_columnAccess.length > 0) {
            sb.append(Env.NL);
        }
        this.loadRecordAccess(false);
        i = 0;
        while (i < this.m_recordAccess.length) {
            sb.append(this.m_recordAccess[i].toStringX(ctx)).append(Env.NL);
            ++i;
        }
        return sb.toString();
    }

    public void setAD_User_ID(int AD_User_ID) {
        this.m_AD_User_ID = AD_User_ID;
    }

    public int getAD_User_ID() {
        return this.m_AD_User_ID;
    }

    public void loadAccess(boolean reload) {
        this.loadOrgAccess(reload);
        this.loadTableAccess(reload);
        this.loadColumnAccess(reload);
        this.loadRecordAccess(reload);
        if (reload) {
            this.m_windowAccess = null;
            this.m_processAccess = null;
            this.m_taskAccess = null;
            this.m_workflowAccess = null;
            this.m_formAccess = null;
        }
        this.loadIncludedRoles(reload);
    }

    private void loadOrgAccess(boolean reload) {
        if (!reload && this.m_orgAccess != null) {
            return;
        }
        ArrayList<OrgAccess> list = new ArrayList<OrgAccess>();
        if (this.isUseUserOrgAccess()) {
            this.loadOrgAccessUser(list);
        } else {
            this.loadOrgAccessRole(list);
        }
        this.m_orgAccess = new OrgAccess[list.size()];
        list.toArray(this.m_orgAccess);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_orgAccess.length + (reload ? " - reload" : ""));
        }
        if (Ini.isClient()) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.m_orgAccess.length) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this.m_orgAccess[i].AD_Org_ID);
                ++i;
            }
            Env.setContext(Env.getCtx(), "#User_Org", sb.toString());
        }
    }

    private void loadOrgAccessUser(ArrayList<OrgAccess> list) {
        block7: {
            if (this.getAD_User_ID() == -1) {
                this.log.info("Trying to load Org Access from User but user has not been set");
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            String sql = "SELECT * FROM AD_User_OrgAccess WHERE AD_User_ID=? AND IsActive='Y' AND AD_Client_ID = ?";
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getAD_User_ID());
                    pstmt.setInt(2, this.getAD_Client_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MUserOrgAccess oa = new MUserOrgAccess(this.getCtx(), rs, this.get_TrxName());
                        this.loadOrgAccessAdd(list, new OrgAccess(oa.getAD_Client_ID(), oa.getAD_Org_ID(), oa.isReadOnly()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
    }

    private void loadOrgAccessRole(ArrayList<OrgAccess> list) {
        block6: {
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            String sql = "SELECT * FROM AD_Role_OrgAccess WHERE AD_Role_ID=? AND IsActive='Y' AND AD_Client_ID = ?";
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getAD_Role_ID());
                    pstmt.setInt(2, this.getAD_Client_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MRoleOrgAccess oa = new MRoleOrgAccess(this.getCtx(), rs, this.get_TrxName());
                        this.loadOrgAccessAdd(list, new OrgAccess(oa.getAD_Client_ID(), oa.getAD_Org_ID(), oa.isReadOnly()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
    }

    private void loadOrgAccessAdd(ArrayList<OrgAccess> list, OrgAccess oa) {
        block9: {
            if (list.contains(oa)) {
                return;
            }
            list.add(oa);
            if (this.getAD_Tree_Org_ID() == 0) {
                return;
            }
            MOrg org = MOrg.get(oa.AD_Org_ID);
            if (!org.isSummary()) {
                return;
            }
            MTree_Base tree = MTree_Base.get(this.getCtx(), this.getAD_Tree_Org_ID(), this.get_TrxName());
            String sql = "SELECT AD_Client_ID, AD_Org_ID FROM AD_Org WHERE IsActive='Y' AND AD_Org_ID IN (SELECT Node_ID FROM " + tree.getNodeTableName() + " WHERE AD_Tree_ID=? AND Parent_ID=? AND IsActive='Y')";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, tree.getAD_Tree_ID());
                    pstmt.setInt(2, org.getAD_Org_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int AD_Client_ID = rs.getInt(1);
                        int AD_Org_ID = rs.getInt(2);
                        this.loadOrgAccessAdd(list, new OrgAccess(AD_Client_ID, AD_Org_ID, oa.readOnly));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private void loadTableAccess(boolean reload) {
        ArrayList<MTableAccess> list;
        block8: {
            if (this.m_tableAccess != null && !reload) {
                return;
            }
            list = new ArrayList<MTableAccess>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            String sql = "SELECT * FROM AD_Table_Access WHERE AD_Role_ID=? AND IsActive='Y'";
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getAD_Role_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MTableAccess(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        this.m_tableAccess = new MTableAccess[list.size()];
        list.toArray(this.m_tableAccess);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_tableAccess.length);
        }
    }

    private boolean isView(String tableName) {
        MTable table2 = MTable.get(this.getCtx(), tableName);
        if (table2 == null) {
            return false;
        }
        return table2.isView();
    }

    private String getIdColumnName(String tableName) {
        StringBuilder colkey = new StringBuilder(tableName).append("_ID");
        MTable table2 = MTable.get(this.getCtx(), tableName);
        if (table2 == null) {
            return null;
        }
        if (table2.getColumnIndex(colkey.toString()) >= 0) {
            return colkey.toString();
        }
        return null;
    }

    private void loadColumnAccess(boolean reload) {
        ArrayList<MColumnAccess> list;
        block8: {
            if (this.m_columnAccess != null && !reload) {
                return;
            }
            list = new ArrayList<MColumnAccess>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            String sql = "SELECT * FROM AD_Column_Access WHERE AD_Role_ID=? AND IsActive='Y'";
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getAD_Role_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MColumnAccess(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        this.m_columnAccess = new MColumnAccess[list.size()];
        list.toArray(this.m_columnAccess);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_columnAccess.length);
        }
    }

    private void loadRecordAccess(boolean reload) {
        ArrayList<MRecordAccess> dependent;
        ArrayList<MRecordAccess> list;
        block8: {
            if (!reload && this.m_recordAccess != null && this.m_recordDependentAccess != null) {
                return;
            }
            list = new ArrayList<MRecordAccess>();
            dependent = new ArrayList<MRecordAccess>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            String sql = "SELECT * FROM AD_Record_Access WHERE AD_Role_ID=? AND IsActive='Y' ORDER BY AD_Table_ID";
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getAD_Role_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MRecordAccess ra = new MRecordAccess(this.getCtx(), rs, this.get_TrxName());
                        list.add(ra);
                        if (!ra.isDependentEntities()) continue;
                        dependent.add(ra);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        this.m_recordAccess = new MRecordAccess[list.size()];
        list.toArray(this.m_recordAccess);
        this.m_recordDependentAccess = new MRecordAccess[dependent.size()];
        dependent.toArray(this.m_recordDependentAccess);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_recordAccess.length + " - Dependent #" + this.m_recordDependentAccess.length);
        }
    }

    public String getClientWhere(boolean rw) {
        if (this.isAccessAllOrgs()) {
            if (rw || this.getAD_Client_ID() == 0) {
                return "AD_Client_ID=" + this.getAD_Client_ID();
            }
            return "AD_Client_ID IN (0," + this.getAD_Client_ID() + ")";
        }
        this.loadOrgAccess(false);
        HashSet<String> set = new HashSet<String>();
        if (!rw) {
            set.add("0");
        }
        int i = 0;
        while (i < this.m_orgAccess.length) {
            set.add(String.valueOf(this.m_orgAccess[i].AD_Client_ID));
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = set.iterator();
        boolean oneOnly = true;
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(",");
                oneOnly = false;
            }
            sb.append((String)it.next());
        }
        if (oneOnly) {
            if (sb.length() > 0) {
                return "AD_Client_ID=" + sb.toString();
            }
            this.log.log(Level.SEVERE, "No Access Org records");
            return "AD_Client_ID=-1";
        }
        return "AD_Client_ID IN(" + sb.toString() + ")";
    }

    public boolean isClientAccess(int AD_Client_ID, boolean rw) {
        if (AD_Client_ID == 0 && !rw) {
            return true;
        }
        if (this.isAccessAllOrgs()) {
            return this.getAD_Client_ID() == AD_Client_ID;
        }
        this.loadOrgAccess(false);
        int i = 0;
        while (i < this.m_orgAccess.length) {
            if (this.m_orgAccess[i].AD_Client_ID == AD_Client_ID) {
                if (!rw) {
                    return true;
                }
                if (!this.m_orgAccess[i].readOnly) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public String getOrgWhere(boolean rw) {
        if (this.isAccessAllOrgs()) {
            return null;
        }
        this.loadOrgAccess(false);
        HashSet<String> set = new HashSet<String>();
        if (!rw) {
            set.add("0");
        }
        int i = 0;
        while (i < this.m_orgAccess.length) {
            if (!rw) {
                set.add(String.valueOf(this.m_orgAccess[i].AD_Org_ID));
            } else if (!this.m_orgAccess[i].readOnly) {
                set.add(String.valueOf(this.m_orgAccess[i].AD_Org_ID));
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = set.iterator();
        int idx = 0;
        while (it.hasNext()) {
            ++idx;
            if (sb.length() > 0) {
                if (DB.isOracle() && (idx - 1) % 1000 == 0) {
                    sb.append(") OR AD_Org_ID IN (");
                } else {
                    sb.append(",");
                }
            }
            sb.append((String)it.next());
        }
        if (sb.indexOf(",") < 0) {
            if (sb.length() > 0) {
                return "AD_Org_ID=" + sb.toString();
            }
            this.log.log(Level.SEVERE, "No Access Org records");
            return "AD_Org_ID=-1";
        }
        return "(AD_Org_ID IN (" + sb.toString() + "))";
    }

    public boolean isOrgAccess(int AD_Org_ID, boolean rw) {
        if (this.isAccessAllOrgs()) {
            return true;
        }
        if (AD_Org_ID == 0 && !rw) {
            return true;
        }
        this.loadOrgAccess(false);
        int i = 0;
        while (i < this.m_orgAccess.length) {
            if (this.m_orgAccess[i].AD_Org_ID == AD_Org_ID) {
                if (!rw) {
                    return true;
                }
                return !this.m_orgAccess[i].readOnly;
            }
            ++i;
        }
        return false;
    }

    public boolean isCanReport(int AD_Table_ID) {
        if (!this.isCanReport()) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Role denied (" + MRole.getDefaultRole().getAD_Role_ID() + ") tableID=" + AD_Table_ID);
            }
            return false;
        }
        if (!this.isTableAccess(AD_Table_ID, true)) {
            return false;
        }
        boolean canReport = true;
        int i = 0;
        while (i < this.m_tableAccess.length) {
            if ("R".equals(this.m_tableAccess[i].getAccessTypeRule())) {
                if (this.m_tableAccess[i].isExclude()) {
                    if (this.m_tableAccess[i].getAD_Table_ID() == AD_Table_ID) {
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("Exclude " + AD_Table_ID);
                        }
                        return false;
                    }
                } else {
                    canReport = false;
                    if (this.m_tableAccess[i].getAD_Table_ID() == AD_Table_ID) {
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("Include " + AD_Table_ID);
                        }
                        return true;
                    }
                }
            }
            ++i;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(AD_Table_ID + " - " + canReport);
        }
        return canReport;
    }

    public boolean isCanExport(int AD_Table_ID) {
        if (!this.isCanExport()) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Role denied (" + MRole.getDefaultRole().getAD_Role_ID() + ") tableID=" + AD_Table_ID);
            }
            return false;
        }
        if (!this.isTableAccess(AD_Table_ID, true)) {
            return false;
        }
        if (!this.isCanReport(AD_Table_ID)) {
            return false;
        }
        boolean canExport = true;
        int i = 0;
        while (i < this.m_tableAccess.length) {
            if ("E".equals(this.m_tableAccess[i].getAccessTypeRule())) {
                if (this.m_tableAccess[i].isExclude()) {
                    if (this.m_tableAccess[i].getAD_Table_ID() == AD_Table_ID) {
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("Exclude " + AD_Table_ID);
                        }
                        return false;
                    }
                } else {
                    canExport = false;
                    if (this.m_tableAccess[i].getAD_Table_ID() == AD_Table_ID) {
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("Include " + AD_Table_ID);
                        }
                        return true;
                    }
                }
            }
            ++i;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(AD_Table_ID + " - " + canExport);
        }
        return canExport;
    }

    public boolean isTableAccess(int AD_Table_ID, boolean ro) {
        if (!this.isTableAccessLevel(AD_Table_ID, ro)) {
            return false;
        }
        this.loadTableAccess(false);
        boolean hasAccess = true;
        int i = 0;
        while (i < this.m_tableAccess.length) {
            if ("A".equals(this.m_tableAccess[i].getAccessTypeRule())) {
                if (this.m_tableAccess[i].isExclude()) {
                    if (this.m_tableAccess[i].getAD_Table_ID() == AD_Table_ID) {
                        hasAccess = ro ? this.m_tableAccess[i].isReadOnly() : false;
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("Exclude AD_Table_ID=" + AD_Table_ID + " (ro=" + ro + ",TableAccessRO=" + this.m_tableAccess[i].isReadOnly() + ") = " + hasAccess);
                        }
                        return hasAccess;
                    }
                } else {
                    hasAccess = false;
                    if (this.m_tableAccess[i].getAD_Table_ID() == AD_Table_ID) {
                        hasAccess = !ro ? !this.m_tableAccess[i].isReadOnly() : true;
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("Include AD_Table_ID=" + AD_Table_ID + " (ro=" + ro + ",TableAccessRO=" + this.m_tableAccess[i].isReadOnly() + ") = " + hasAccess);
                        }
                        return hasAccess;
                    }
                }
            }
            ++i;
        }
        if (!hasAccess && this.log.isLoggable(Level.FINE)) {
            this.log.fine("AD_Table_ID=" + AD_Table_ID + "(ro=" + ro + ") = " + hasAccess);
        }
        return hasAccess;
    }

    public boolean isTableAccessLevel(int AD_Table_ID, boolean ro) {
        if (ro) {
            return true;
        }
        MTable table2 = MTable.get(AD_Table_ID);
        if (table2 == null) {
            this.log.warning("No Table Found with AD_Table_ID=" + AD_Table_ID);
            return false;
        }
        String tableAccessLevel = table2.getAccessLevel();
        if (tableAccessLevel == null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("NO - No AccessLevel - AD_Table_ID=" + AD_Table_ID);
            }
            return false;
        }
        if (tableAccessLevel.equals("7")) {
            return true;
        }
        String userLevel = this.getUserLevel();
        if (userLevel.charAt(0) == 'S' && (tableAccessLevel.equals("4") || tableAccessLevel.equals("6"))) {
            return true;
        }
        if (userLevel.charAt(1) == 'C' && (tableAccessLevel.equals("2") || tableAccessLevel.equals("6"))) {
            return true;
        }
        if (userLevel.charAt(2) == 'O' && (tableAccessLevel.equals("1") || tableAccessLevel.equals("3"))) {
            return true;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("NO - AD_Table_ID=" + AD_Table_ID + ", UserLevel=" + userLevel + ", AccessLevel=" + tableAccessLevel);
        }
        return false;
    }

    public boolean isColumnAccess(int AD_Table_ID, int AD_Column_ID, boolean ro) {
        return this.isColumnAccess(AD_Table_ID, AD_Column_ID, ro, null);
    }

    public boolean isColumnAccess(int AD_Table_ID, int AD_Column_ID, boolean ro, String trxName) {
        Boolean access;
        if (!this.isTableAccess(AD_Table_ID, ro)) {
            return false;
        }
        this.loadColumnAccess(false);
        MColumn column = MColumn.get(Env.getCtx(), AD_Column_ID, trxName);
        if (column.getAD_Reference_ID() == 28 && (column.getAD_Process_ID() > 0 ? (access = MRole.getDefault().getProcessAccess(column.getAD_Process_ID())) == null : column.getAD_InfoWindow_ID() > 0 && (access = MRole.getDefault().getInfoAccess(column.getAD_InfoWindow_ID())) == null)) {
            return false;
        }
        boolean retValue = true;
        int i = 0;
        while (i < this.m_columnAccess.length) {
            if (this.m_columnAccess[i].isExclude()) {
                if (this.m_columnAccess[i].getAD_Table_ID() == AD_Table_ID && this.m_columnAccess[i].getAD_Column_ID() == AD_Column_ID) {
                    retValue = ro ? this.m_columnAccess[i].isReadOnly() : false;
                    if (!retValue && this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Exclude AD_Table_ID=" + AD_Table_ID + ", AD_Column_ID=" + AD_Column_ID + " (ro=" + ro + ",ColumnAccessRO=" + this.m_columnAccess[i].isReadOnly() + ") = " + retValue);
                    }
                    return retValue;
                }
            } else if (this.m_columnAccess[i].getAD_Table_ID() == AD_Table_ID) {
                retValue = false;
                if (this.m_columnAccess[i].getAD_Column_ID() == AD_Column_ID) {
                    retValue = !ro ? !this.m_columnAccess[i].isReadOnly() : true;
                    if (!retValue && this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Include AD_Table_ID=" + AD_Table_ID + ", AD_Column_ID=" + AD_Column_ID + " (ro=" + ro + ",ColumnAccessRO=" + this.m_columnAccess[i].isReadOnly() + ") = " + retValue);
                    }
                    return retValue;
                }
            }
            ++i;
        }
        if (!retValue && this.log.isLoggable(Level.FINE)) {
            this.log.fine("AD_Table_ID=" + AD_Table_ID + ", AD_Column_ID=" + AD_Column_ID + " (ro=" + ro + ") = " + retValue);
        }
        return retValue;
    }

    public boolean isRecordAccess(int AD_Table_ID, int Record_ID, boolean ro) {
        this.loadRecordAccess(false);
        boolean negativeList = true;
        int i = 0;
        while (i < this.m_recordAccess.length) {
            MRecordAccess ra = this.m_recordAccess[i];
            if (ra.getAD_Table_ID() == AD_Table_ID) {
                if (ra.isExclude()) {
                    if (ra.getRecord_ID() == Record_ID) {
                        if (ro) {
                            return ra.isReadOnly();
                        }
                        return false;
                    }
                } else {
                    negativeList = false;
                    if (ra.getRecord_ID() == Record_ID) {
                        if (!ro) {
                            return !ra.isReadOnly();
                        }
                        return true;
                    }
                }
            }
            ++i;
        }
        return negativeList;
    }

    public synchronized Boolean getWindowAccess(int AD_Window_ID) {
        Boolean retValue;
        if (this.m_windowAccess == null) {
            HashMap<Integer, Boolean> directAccess;
            block12: {
                this.m_windowAccess = new HashMap(100);
                this.mergeIncludedAccess("m_windowAccess");
                MClient client = MClient.get(Env.getCtx());
                Object ASPFilter = "";
                if (client.isUseASP()) {
                    ASPFilter = "   AND (   AD_Window_ID IN (               SELECT w.AD_Window_ID                 FROM ASP_Window w, ASP_Level l, ASP_ClientLevel cl                WHERE w.ASP_Level_ID = l.ASP_Level_ID                  AND cl.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND cl.ASP_Level_ID = l.ASP_Level_ID                  AND w.IsActive = 'Y'                  AND l.IsActive = 'Y'                  AND cl.IsActive = 'Y'                  AND w.ASP_Status = 'S')         OR AD_Window_ID IN (               SELECT AD_Window_ID                 FROM ASP_ClientException ce                WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND ce.IsActive = 'Y'                  AND ce.AD_Window_ID IS NOT NULL                  AND ce.AD_Tab_ID IS NULL                  AND ce.AD_Field_ID IS NULL                  AND ce.ASP_Status = 'S')        )    AND AD_Window_ID NOT IN (           SELECT AD_Window_ID             FROM ASP_ClientException ce            WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "             AND ce.IsActive = 'Y'              AND ce.AD_Window_ID IS NOT NULL              AND ce.AD_Tab_ID IS NULL              AND ce.AD_Field_ID IS NULL              AND ce.ASP_Status = 'H')";
                }
                String sql = "SELECT AD_Window_ID, IsReadWrite, IsActive FROM AD_Window_Access WHERE AD_Role_ID=?" + (String)ASPFilter;
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                directAccess = new HashMap<Integer, Boolean>(100);
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, this.get_TrxName());
                        pstmt.setInt(1, this.getAD_Role_ID());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            Integer winId = rs.getInt(1);
                            if ("N".equals(rs.getString(3))) {
                                if (!this.m_windowAccess.containsKey(winId)) continue;
                                this.m_windowAccess.remove(winId);
                                continue;
                            }
                            directAccess.put(winId, "Y".equals(rs.getString(2)));
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
            this.setAccessMap("m_windowAccess", MRole.mergeAccess(this.getAccessMap("m_windowAccess"), directAccess, true));
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("#" + this.m_windowAccess.size());
            }
        }
        if ((retValue = this.m_windowAccess.get(AD_Window_ID)) != null && AD_Window_ID != 200073 && Env.isReadOnlySession()) {
            retValue = Boolean.FALSE;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("getWindowAccess - AD_Window_ID=" + AD_Window_ID + " - " + String.valueOf(retValue));
        }
        return retValue;
    }

    public synchronized Boolean getProcessAccess(int AD_Process_ID) {
        MProcess process;
        Boolean retValue;
        if (this.m_processAccess == null) {
            HashMap<Integer, Boolean> directAccess;
            block11: {
                this.m_processAccess = new HashMap(50);
                this.mergeIncludedAccess("m_processAccess");
                MClient client = MClient.get(Env.getCtx());
                Object ASPFilter = "";
                if (client.isUseASP()) {
                    ASPFilter = "   AND (   AD_Process_ID IN (               SELECT p.AD_Process_ID                 FROM ASP_Process p, ASP_Level l, ASP_ClientLevel cl                WHERE p.ASP_Level_ID = l.ASP_Level_ID                  AND cl.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND cl.ASP_Level_ID = l.ASP_Level_ID                  AND p.IsActive = 'Y'                  AND l.IsActive = 'Y'                  AND cl.IsActive = 'Y'                  AND p.ASP_Status = 'S')         OR AD_Process_ID IN (               SELECT AD_Process_ID                 FROM ASP_ClientException ce                WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND ce.IsActive = 'Y'                  AND ce.AD_Process_ID IS NOT NULL                  AND ce.AD_Process_Para_ID IS NULL                  AND ce.ASP_Status = 'S')        )    AND AD_Process_ID NOT IN (           SELECT AD_Process_ID             FROM ASP_ClientException ce            WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "             AND ce.IsActive = 'Y'              AND ce.AD_Process_ID IS NOT NULL              AND ce.AD_Process_Para_ID IS NULL              AND ce.ASP_Status = 'H')";
                }
                String sql = "SELECT AD_Process_ID, IsReadWrite, IsActive FROM AD_Process_Access WHERE AD_Role_ID=?" + (String)ASPFilter;
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                directAccess = new HashMap<Integer, Boolean>(100);
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, this.get_TrxName());
                        pstmt.setInt(1, this.getAD_Role_ID());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            Integer procId = rs.getInt(1);
                            if ("N".equals(rs.getString(3))) {
                                if (!this.m_processAccess.containsKey(procId)) continue;
                                this.m_processAccess.remove(procId);
                                continue;
                            }
                            directAccess.put(procId, "Y".equals(rs.getString(2)));
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
            this.setAccessMap("m_processAccess", MRole.mergeAccess(this.getAccessMap("m_processAccess"), directAccess, true));
        }
        if ((retValue = this.m_processAccess.get(AD_Process_ID)) != null && retValue.booleanValue() && !this.isAccessLevelCompatible((process = MProcess.get(this.getCtx(), AD_Process_ID)).getAccessLevel())) {
            this.log.warning("Role " + this.getName() + " has assigned access incompatible process " + process.getName());
            this.m_processAccess.remove(AD_Process_ID);
            retValue = null;
        }
        if (retValue != null && Env.isReadOnlySession()) {
            retValue = Boolean.FALSE;
        }
        return retValue;
    }

    public synchronized Boolean getTaskAccess(int AD_Task_ID) {
        MTask task;
        Boolean retValue;
        if (this.m_taskAccess == null) {
            HashMap<Integer, Boolean> directAccess;
            block11: {
                this.m_taskAccess = new HashMap(10);
                this.mergeIncludedAccess("m_taskAccess");
                MClient client = MClient.get(Env.getCtx());
                Object ASPFilter = "";
                if (client.isUseASP()) {
                    ASPFilter = "   AND (   AD_Task_ID IN (               SELECT t.AD_Task_ID                 FROM ASP_Task t, ASP_Level l, ASP_ClientLevel cl                WHERE t.ASP_Level_ID = l.ASP_Level_ID                  AND cl.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND cl.ASP_Level_ID = l.ASP_Level_ID                  AND t.IsActive = 'Y'                  AND l.IsActive = 'Y'                  AND cl.IsActive = 'Y'                  AND t.ASP_Status = 'S')         OR AD_Task_ID IN (               SELECT AD_Task_ID                 FROM ASP_ClientException ce                WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND ce.IsActive = 'Y'                  AND ce.AD_Task_ID IS NOT NULL                  AND ce.ASP_Status = 'S')        )    AND AD_Task_ID NOT IN (           SELECT AD_Task_ID             FROM ASP_ClientException ce            WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "             AND ce.IsActive = 'Y'              AND ce.AD_Task_ID IS NOT NULL              AND ce.ASP_Status = 'H')";
                }
                String sql = "SELECT AD_Task_ID, IsReadWrite, IsActive FROM AD_Task_Access WHERE AD_Role_ID=?" + (String)ASPFilter;
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                directAccess = new HashMap<Integer, Boolean>(100);
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, this.get_TrxName());
                        pstmt.setInt(1, this.getAD_Role_ID());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            Integer taskId = rs.getInt(1);
                            if ("N".equals(rs.getString(3))) {
                                if (!this.m_taskAccess.containsKey(taskId)) continue;
                                this.m_taskAccess.remove(taskId);
                                continue;
                            }
                            directAccess.put(taskId, "Y".equals(rs.getString(2)));
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
            this.setAccessMap("m_taskAccess", MRole.mergeAccess(this.getAccessMap("m_taskAccess"), directAccess, true));
        }
        if ((retValue = this.m_taskAccess.get(AD_Task_ID)) != null && retValue.booleanValue() && !this.isAccessLevelCompatible((task = new MTask(this.getCtx(), AD_Task_ID, this.get_TrxName())).getAccessLevel())) {
            this.log.warning("Role " + this.getName() + " has assigned access incompatible task " + task.getName());
            this.m_taskAccess.remove(AD_Task_ID);
            retValue = null;
        }
        if (retValue != null && Env.isReadOnlySession()) {
            retValue = Boolean.FALSE;
        }
        return retValue;
    }

    public synchronized Boolean getFormAccess(int AD_Form_ID) {
        MForm form;
        Boolean retValue;
        if (this.m_formAccess == null) {
            HashMap<Integer, Boolean> directAccess;
            block11: {
                this.m_formAccess = new HashMap(20);
                this.mergeIncludedAccess("m_formAccess");
                MClient client = MClient.get(Env.getCtx());
                Object ASPFilter = "";
                if (client.isUseASP()) {
                    ASPFilter = "   AND (   AD_Form_ID IN (               SELECT f.AD_Form_ID                 FROM ASP_Form f, ASP_Level l, ASP_ClientLevel cl                WHERE f.ASP_Level_ID = l.ASP_Level_ID                  AND cl.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND cl.ASP_Level_ID = l.ASP_Level_ID                  AND f.IsActive = 'Y'                  AND l.IsActive = 'Y'                  AND cl.IsActive = 'Y'                  AND f.ASP_Status = 'S')         OR AD_Form_ID IN (               SELECT AD_Form_ID                 FROM ASP_ClientException ce                WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND ce.IsActive = 'Y'                  AND ce.AD_Form_ID IS NOT NULL                  AND ce.ASP_Status = 'S')        )    AND AD_Form_ID NOT IN (           SELECT AD_Form_ID             FROM ASP_ClientException ce            WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "             AND ce.IsActive = 'Y'              AND ce.AD_Form_ID IS NOT NULL              AND ce.ASP_Status = 'H')";
                }
                String sql = "SELECT AD_Form_ID, IsReadWrite, IsActive FROM AD_Form_Access WHERE AD_Role_ID=?" + (String)ASPFilter;
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                directAccess = new HashMap<Integer, Boolean>(100);
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, this.get_TrxName());
                        pstmt.setInt(1, this.getAD_Role_ID());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            Integer formId = rs.getInt(1);
                            if ("N".equals(rs.getString(3))) {
                                if (!this.m_formAccess.containsKey(formId)) continue;
                                this.m_formAccess.remove(formId);
                                continue;
                            }
                            directAccess.put(formId, "Y".equals(rs.getString(2)));
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
            this.setAccessMap("m_formAccess", MRole.mergeAccess(this.getAccessMap("m_formAccess"), directAccess, true));
        }
        if ((retValue = this.m_formAccess.get(AD_Form_ID)) != null && retValue.booleanValue() && !this.isAccessLevelCompatible((form = new MForm(this.getCtx(), AD_Form_ID, this.get_TrxName())).getAccessLevel())) {
            this.log.warning("Role " + this.getName() + " has assigned access incompatible form " + form.getName());
            this.m_formAccess.remove(AD_Form_ID);
            retValue = null;
        }
        if (retValue != null && Env.isReadOnlySession()) {
            retValue = Boolean.FALSE;
        }
        return retValue;
    }

    public synchronized Boolean getWorkflowAccess(int AD_Workflow_ID) {
        MWorkflow workflow;
        Boolean retValue;
        if (this.m_workflowAccess == null) {
            HashMap<Integer, Boolean> directAccess;
            block11: {
                this.m_workflowAccess = new HashMap(20);
                this.mergeIncludedAccess("m_workflowAccess");
                MClient client = MClient.get(Env.getCtx());
                Object ASPFilter = "";
                if (client.isUseASP()) {
                    ASPFilter = "   AND (   AD_Workflow_ID IN (               SELECT w.AD_Workflow_ID                 FROM ASP_Workflow w, ASP_Level l, ASP_ClientLevel cl                WHERE w.ASP_Level_ID = l.ASP_Level_ID                  AND cl.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND cl.ASP_Level_ID = l.ASP_Level_ID                  AND w.IsActive = 'Y'                  AND l.IsActive = 'Y'                  AND cl.IsActive = 'Y'                  AND w.ASP_Status = 'S')         OR AD_Workflow_ID IN (               SELECT AD_Workflow_ID                 FROM ASP_ClientException ce                WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND ce.IsActive = 'Y'                  AND ce.AD_Workflow_ID IS NOT NULL                  AND ce.ASP_Status = 'S')        )    AND AD_Workflow_ID NOT IN (           SELECT AD_Workflow_ID             FROM ASP_ClientException ce            WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "             AND ce.IsActive = 'Y'              AND ce.AD_Workflow_ID IS NOT NULL              AND ce.ASP_Status = 'H')";
                }
                String sql = "SELECT AD_Workflow_ID, IsReadWrite, IsActive FROM AD_Workflow_Access WHERE AD_Role_ID=?" + (String)ASPFilter;
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                directAccess = new HashMap<Integer, Boolean>(100);
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, this.get_TrxName());
                        pstmt.setInt(1, this.getAD_Role_ID());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            Integer formId = rs.getInt(1);
                            if ("N".equals(rs.getString(3))) {
                                if (!this.m_workflowAccess.containsKey(formId)) continue;
                                this.m_workflowAccess.remove(formId);
                                continue;
                            }
                            directAccess.put(formId, "Y".equals(rs.getString(2)));
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
            this.setAccessMap("m_workflowAccess", MRole.mergeAccess(this.getAccessMap("m_workflowAccess"), directAccess, true));
        }
        if ((retValue = this.m_workflowAccess.get(AD_Workflow_ID)) != null && retValue.booleanValue() && !this.isAccessLevelCompatible((workflow = MWorkflow.get(this.getCtx(), AD_Workflow_ID)).getAccessLevel())) {
            this.log.warning("Role " + this.getName() + " has assigned access incompatible workflow " + workflow.getName());
            this.m_workflowAccess.remove(AD_Workflow_ID);
            retValue = null;
        }
        if (retValue != null && Env.isReadOnlySession()) {
            retValue = Boolean.FALSE;
        }
        return retValue;
    }

    public String addAccessSQL(String SQL, String TableNameIn, boolean fullyQualified, boolean rw) {
        StringBuilder retSQL = new StringBuilder();
        String orderBy = "";
        int posOrder = SQL.lastIndexOf(" ORDER BY ");
        if (posOrder != -1) {
            orderBy = SQL.substring(posOrder);
            retSQL.append(SQL.substring(0, posOrder));
        } else {
            retSQL.append(SQL);
        }
        AccessSqlParser asp = new AccessSqlParser(retSQL.toString());
        AccessSqlParser.TableInfo[] ti = asp.getTableInfo(asp.getMainSqlIndex());
        if (asp.getMainSql().indexOf(" WHERE ") == -1) {
            retSQL.append(" WHERE ");
        } else {
            retSQL.append(" AND ");
        }
        String tableName = "";
        if (ti.length > 0 && (tableName = ti[0].getSynonym()).length() == 0) {
            tableName = ti[0].getTableName();
        }
        if (TableNameIn != null && !tableName.equals(TableNameIn)) {
            String msg = "TableName not correctly parsed - TableNameIn=" + TableNameIn + " - " + String.valueOf(asp);
            if (ti.length > 0) {
                msg = msg + " - #1 " + String.valueOf(ti[0]);
            }
            msg = msg + "\n = " + SQL;
            this.log.log(Level.SEVERE, msg);
            Trace.printStack();
            tableName = TableNameIn;
        }
        if (!tableName.equals("AD_PInstance_Log")) {
            if (fullyQualified) {
                retSQL.append(tableName).append(".");
            }
            retSQL.append(this.getClientWhere(rw));
            if (!this.isAccessAllOrgs()) {
                retSQL.append(" AND ");
                String orgWhere = this.getOrgWhere(rw);
                if (fullyQualified) {
                    orgWhere = orgWhere.replaceAll("AD_Org_ID", tableName + ".AD_Org_ID");
                }
                retSQL.append(orgWhere);
            }
        } else {
            retSQL.append("1=1");
        }
        int i = 0;
        while (i < ti.length) {
            String TableName = ti[i].getTableName();
            if (!TableName.toUpperCase().endsWith("_TRL") && !this.isView(TableName)) {
                String recordWhere;
                int AD_Table_ID = this.getAD_Table_ID(TableName);
                if (AD_Table_ID != 0 && !this.isTableAccess(AD_Table_ID, !rw)) {
                    retSQL.append(" AND 1=3");
                    if (!this.log.isLoggable(Level.FINE)) break;
                    this.log.fine("No access to AD_Table_ID=" + AD_Table_ID + " - " + TableName + " - " + String.valueOf(retSQL));
                    break;
                }
                Object keyColumnName = "";
                if (fullyQualified) {
                    keyColumnName = ti[i].getSynonym();
                    if (((String)keyColumnName).length() == 0) {
                        keyColumnName = TableName;
                    }
                    keyColumnName = (String)keyColumnName + ".";
                }
                if (this.getIdColumnName(TableName) != null && (recordWhere = this.getRecordWhere(AD_Table_ID, (String)(keyColumnName = (String)keyColumnName + this.getIdColumnName(TableName)), rw, TableName, ti[i].getSynonym())).length() > 0) {
                    retSQL.append(" AND ").append(recordWhere);
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("Record access - " + recordWhere);
                    }
                }
            }
            ++i;
        }
        String mainSql = asp.getMainSql();
        this.loadRecordAccess(false);
        int AD_Table_ID = 0;
        String whereColumnName = null;
        ArrayList<Integer> includes = new ArrayList<Integer>();
        ArrayList<Integer> excludes = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < this.m_recordDependentAccess.length) {
            MColumn column;
            MTable table2;
            char charCheck;
            int posColumn;
            String columnName = this.m_recordDependentAccess[i2].getKeyColumnName(asp.getTableInfo(asp.getMainSqlIndex()));
            if (columnName != null && !(!mainSql.toUpperCase().startsWith("SELECT COUNT(*) FROM ") ? (posColumn = mainSql.indexOf(columnName)) == -1 || (charCheck = mainSql.charAt(posColumn - 1)) != ',' && charCheck != '.' && charCheck != ' ' && charCheck != '(' || (charCheck = mainSql.charAt(posColumn + columnName.length())) != ',' && charCheck != ' ' && charCheck != ')' : (table2 = MTable.get(this.getCtx(), tableName)) == null || (column = table2.getColumn(columnName)) == null || column.isVirtualColumn() || !column.isActive())) {
                if (AD_Table_ID != 0 && AD_Table_ID != this.m_recordDependentAccess[i2].getAD_Table_ID()) {
                    retSQL.append(this.getDependentAccess(whereColumnName, includes, excludes));
                }
                AD_Table_ID = this.m_recordDependentAccess[i2].getAD_Table_ID();
                if (this.m_recordDependentAccess[i2].isExclude()) {
                    excludes.add(this.m_recordDependentAccess[i2].getRecord_ID());
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Exclude " + columnName + " - " + String.valueOf(this.m_recordDependentAccess[i2]));
                    }
                } else if (!rw || !this.m_recordDependentAccess[i2].isReadOnly()) {
                    includes.add(this.m_recordDependentAccess[i2].getRecord_ID());
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Include " + columnName + " - " + String.valueOf(this.m_recordDependentAccess[i2]));
                    }
                }
                whereColumnName = this.getDependentRecordWhereColumn(mainSql, columnName);
            }
            ++i2;
        }
        retSQL.append(this.getDependentAccess(whereColumnName, includes, excludes));
        retSQL.append(orderBy);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(retSQL.toString());
        }
        return retSQL.toString();
    }

    private String getDependentAccess(String whereColumnName, ArrayList<Integer> includes, ArrayList<Integer> excludes) {
        if (includes.size() == 0 && excludes.size() == 0) {
            return "";
        }
        if (includes.size() != 0 && excludes.size() != 0) {
            this.log.warning("Mixing Include and Exclude rules - Will not return values");
        }
        StringBuilder where = new StringBuilder(" AND ");
        if (includes.size() == 1) {
            where.append(whereColumnName).append("=").append(includes.get(0));
        } else if (includes.size() > 1) {
            where.append(whereColumnName).append(" IN (");
            int ii = 0;
            while (ii < includes.size()) {
                if (ii > 0) {
                    where.append(",");
                }
                where.append(includes.get(ii));
                ++ii;
            }
            where.append(")");
        } else if (excludes.size() == 1) {
            where.append("(" + whereColumnName + " IS NULL OR ");
            where.append(whereColumnName).append("<>").append(excludes.get(0)).append(")");
        } else if (excludes.size() > 1) {
            where.append("(" + whereColumnName + " IS NULL OR ");
            where.append(whereColumnName).append(" NOT IN (");
            int ii = 0;
            while (ii < excludes.size()) {
                if (ii > 0) {
                    where.append(",");
                }
                where.append(excludes.get(ii));
                ++ii;
            }
            where.append("))");
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(where.toString());
        }
        return where.toString();
    }

    private String getDependentRecordWhereColumn(String mainSql, String columnName) {
        String retValue = columnName;
        int index = mainSql.indexOf(columnName);
        if (index == -1) {
            return retValue;
        }
        int offset = index - 1;
        char c = mainSql.charAt(offset);
        if (c == '.') {
            StringBuilder sb = new StringBuilder();
            while (c != ' ' && c != ',' && c != '(') {
                sb.insert(0, c);
                c = mainSql.charAt(--offset);
            }
            sb.append(columnName);
            return sb.toString();
        }
        return retValue;
    }

    public boolean canUpdate(int AD_Client_ID, int AD_Org_ID, int AD_Table_ID, int Record_ID, boolean createError) {
        String userLevel = this.getUserLevel();
        if (userLevel.indexOf(83) != -1) {
            return true;
        }
        boolean retValue = true;
        Object whatMissing = "";
        if (AD_Client_ID == 0 && AD_Org_ID == 0 && userLevel.charAt(0) != 'S') {
            retValue = false;
            whatMissing = (String)whatMissing + "S";
        } else if (AD_Client_ID != 0 && AD_Org_ID == 0 && userLevel.charAt(1) != 'C') {
            if (userLevel.charAt(2) != 'O' || !this.isOrgAccess(AD_Org_ID, true)) {
                retValue = false;
                whatMissing = (String)whatMissing + "C";
            }
        } else if (AD_Client_ID != 0 && AD_Org_ID != 0 && userLevel.charAt(2) != 'O') {
            retValue = false;
            whatMissing = (String)whatMissing + "O";
        }
        if (retValue) {
            retValue = this.isClientAccess(AD_Client_ID, true);
            whatMissing = (String)whatMissing + "C";
        }
        if (retValue) {
            retValue = this.isOrgAccess(AD_Org_ID, true);
            whatMissing = "W";
        }
        if (retValue) {
            retValue = this.isTableAccess(AD_Table_ID, false);
        }
        if (retValue && Record_ID != 0) {
            retValue = this.isRecordAccess(AD_Table_ID, Record_ID, false);
        }
        if (!retValue && createError) {
            this.log.saveWarning("AccessTableNoUpdate", "AD_Client_ID=" + AD_Client_ID + ", AD_Org_ID=" + AD_Org_ID + ", UserLevel=" + userLevel + " => missing=" + (String)whatMissing);
            this.log.warning(this.toString());
        }
        return retValue;
    }

    public boolean canView(Properties ctx, String TableLevel) {
        String userLevel = this.getUserLevel();
        boolean retValue = true;
        if ("7".equals(TableLevel)) {
            retValue = true;
        } else if ("4".equals(TableLevel) && userLevel.charAt(0) != 'S') {
            retValue = false;
        } else if ("2".equals(TableLevel) && userLevel.charAt(1) != 'C') {
            retValue = false;
        } else if ("1".equals(TableLevel) && userLevel.charAt(2) != 'O') {
            retValue = false;
        } else if ("3".equals(TableLevel) && userLevel.charAt(1) != 'C' && userLevel.charAt(2) != 'O') {
            retValue = false;
        } else if ("6".equals(TableLevel) && userLevel.charAt(0) != 'S' && userLevel.charAt(1) != 'C') {
            retValue = false;
        }
        if (retValue) {
            return retValue;
        }
        this.log.saveWarning("AccessTableNoView", "Required=" + TableLevel + "(" + this.getTableLevelString(Env.getAD_Language(ctx), TableLevel) + ") != UserLevel=" + userLevel);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        return retValue;
    }

    private String getTableLevelString(String AD_Language, String TableLevel) {
        Object level = TableLevel + "??";
        if (TableLevel.equals("1")) {
            level = "AccessOrg";
        } else if (TableLevel.equals("2")) {
            level = "AccessClient";
        } else if (TableLevel.equals("3")) {
            level = "AccessClientOrg";
        } else if (TableLevel.equals("4")) {
            level = "AccessSystem";
        } else if (TableLevel.equals("6")) {
            level = "AccessSystemClient";
        } else if (TableLevel.equals("7")) {
            level = "AccessShared";
        }
        return Msg.getMsg(AD_Language, (String)level);
    }

    private int getAD_Table_ID(String tableName) {
        MTable table2 = MTable.get(this.getCtx(), tableName);
        if (table2 == null) {
            return 0;
        }
        return table2.getAD_Table_ID();
    }

    private String getRecordWhere(int AD_Table_ID, String keyColumnName, boolean rw, String tableName, String alias) {
        String lockedIDs;
        this.loadRecordAccess(false);
        StringBuilder sbInclude = new StringBuilder();
        StringBuilder sbExclude = new StringBuilder();
        int i = 0;
        while (i < this.m_recordAccess.length) {
            if (this.m_recordAccess[i].getAD_Table_ID() == AD_Table_ID) {
                if (this.m_recordAccess[i].isExclude()) {
                    if (sbExclude.length() == 0) {
                        sbExclude.append("(").append(keyColumnName).append(" IS NULL OR ");
                        sbExclude.append(keyColumnName).append(" NOT IN (");
                    } else {
                        sbExclude.append(",");
                    }
                    sbExclude.append(this.m_recordAccess[i].getRecord_ID());
                } else if (!rw || !this.m_recordAccess[i].isReadOnly()) {
                    if (sbInclude.length() == 0) {
                        sbInclude.append(keyColumnName).append(" IN (");
                    } else {
                        sbInclude.append(",");
                    }
                    sbInclude.append(this.m_recordAccess[i].getRecord_ID());
                }
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        if (sbExclude.length() > 0) {
            sb.append((CharSequence)sbExclude).append("))");
        }
        if (sbInclude.length() > 0) {
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            sb.append((CharSequence)sbInclude).append(")");
        }
        if (!this.isPersonalAccess() && (lockedIDs = MPrivateAccess.getLockedRecordWhere(AD_Table_ID, this.m_AD_User_ID)) != null) {
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            sb.append(" (" + keyColumnName + " IS NULL OR ");
            sb.append(keyColumnName).append(lockedIDs).append(") ");
        }
        for (MTableValRule tvr : MTableValRule.get(this.p_ctx, AD_Table_ID, Env.getAD_Client_ID(this.p_ctx), Env.getAD_Role_ID(this.p_ctx), Env.getAD_User_ID(this.p_ctx))) {
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            String wherevr = Env.parseContext(this.p_ctx, 0, tvr.getCode(), false);
            if (!Util.isEmpty(alias) && !alias.equals(tableName)) {
                wherevr = wherevr.replaceAll("\\b" + tableName + "\\b", alias);
            }
            sb.append(" (").append(wherevr).append(") ");
        }
        return sb.toString();
    }

    public boolean isShowPreference() {
        return !"N".equals(this.getPreferenceType());
    }

    public int checkActionAccess(int clientId, int docTypeId, String[] options, int maxIndex) {
        ArrayList<String> validOptions;
        block19: {
            if (maxIndex <= 0) {
                return maxIndex;
            }
            validOptions = new ArrayList<String>();
            ArrayList<String> optionParams = new ArrayList<String>();
            StringBuilder sql_values = new StringBuilder();
            int i = 0;
            while (i < maxIndex) {
                if (sql_values.length() > 0) {
                    sql_values.append(",");
                }
                sql_values.append("?");
                optionParams.add(options[i]);
                ++i;
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            List<MRole> roles = this.getIncludedRoles(true);
            roles.add(this);
            String sql = null;
            try {
                try {
                    for (MRole role : roles) {
                        int idxpar = 1;
                        if (role.getAD_Client_ID() == 0 && role.isMasterRole()) {
                            MDocType mDocType = new MDocType(this.getCtx(), docTypeId, this.get_TrxName());
                            sql = "SELECT DISTINCT rl.Value, a.IsActive FROM AD_Document_Action_Access a INNER JOIN AD_Ref_List rl ON (rl.AD_Reference_ID=135 and rl.AD_Ref_List_ID=a.AD_Ref_List_ID) INNER JOIN AD_Role ro ON (a.AD_Role_ID=ro.AD_Role_ID) INNER JOIN C_Doctype ty ON (a.C_Doctype_ID=ty.C_Doctype_ID) WHERE ro.AD_Role_ID=? AND ty.DocBaseType=?" + ("SOO".equals(mDocType.getDocBaseType()) ? " AND ty.DocSubTypeSO=?" : "") + ("POO".equals(mDocType.getDocBaseType()) && mDocType.getDocSubTypeSO() != null ? " AND ty.DocSubTypeSO=?" : "") + ("MMI".equals(mDocType.getDocBaseType()) ? " AND ty.DocSubTypeInv=?" : "") + " AND rl.Value IN (" + String.valueOf(sql_values) + ")";
                            pstmt = DB.prepareStatement(sql, this.get_TrxName());
                            pstmt.setInt(idxpar++, role.getAD_Role_ID());
                            pstmt.setString(idxpar++, mDocType.getDocBaseType());
                            if ("SOO".equals(mDocType.getDocBaseType())) {
                                pstmt.setString(idxpar++, mDocType.getDocSubTypeSO());
                            } else if ("POO".equals(mDocType.getDocBaseType()) && mDocType.getDocSubTypeSO() != null) {
                                pstmt.setString(idxpar++, mDocType.getDocSubTypeSO());
                            } else if ("MMI".equals(mDocType.getDocBaseType())) {
                                pstmt.setString(idxpar++, mDocType.getDocSubTypeInv());
                            }
                        } else {
                            sql = "SELECT DISTINCT rl.Value, a.IsActive FROM AD_Document_Action_Access a INNER JOIN AD_Ref_List rl ON (rl.AD_Reference_ID=135 and rl.AD_Ref_List_ID=a.AD_Ref_List_ID) WHERE a.AD_Client_ID=? AND a.C_DocType_ID=? AND a.AD_Role_ID=? AND rl.Value IN (" + String.valueOf(sql_values) + ")";
                            pstmt = DB.prepareStatement(sql, this.get_TrxName());
                            pstmt.setInt(idxpar++, clientId);
                            pstmt.setInt(idxpar++, docTypeId);
                            pstmt.setInt(idxpar++, role.getAD_Role_ID());
                        }
                        for (Object e : optionParams) {
                            pstmt.setObject(idxpar++, e);
                        }
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            String string = rs.getString(1);
                            String active = rs.getString(2);
                            if ("N".equals(active)) {
                                if (!validOptions.contains(string)) continue;
                                validOptions.remove(string);
                                continue;
                            }
                            if (validOptions.contains(string)) continue;
                            validOptions.add(string);
                        }
                        DB.close(rs, pstmt);
                    }
                    validOptions.toArray(options);
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block19;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        int newMaxIndex = validOptions.size();
        return newMaxIndex;
    }

    private void includeRole(MRole role, int seqNo) {
        if (this.getAD_Role_ID() == role.getAD_Role_ID()) {
            return;
        }
        if (this.m_includedRoles == null) {
            this.m_includedRoles = new ArrayList<MRole>();
        }
        for (MRole r : this.m_includedRoles) {
            if (r.getAD_Role_ID() != role.getAD_Role_ID()) continue;
            return;
        }
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info("Include " + String.valueOf(role));
        }
        if (role.isActive()) {
            this.m_includedRoles.add(role);
            role.setParentRole(this);
            role.m_includedSeqNo = seqNo;
        }
    }

    public List<MRole> getIncludedRoles(boolean recursive) {
        if (!recursive) {
            List<MRole> list = this.m_includedRoles;
            if (list == null) {
                list = new ArrayList<MRole>();
            }
            return Collections.unmodifiableList(list);
        }
        ArrayList<MRole> list = new ArrayList<MRole>();
        if (this.m_includedRoles != null) {
            for (MRole role : this.m_includedRoles) {
                list.add(role);
                list.addAll(role.getIncludedRoles(true));
            }
        }
        return list;
    }

    private void loadIncludedRoles(boolean reload) {
        this.loadChildRoles(reload);
        this.loadSubstitutedRoles(reload);
        if (this.m_parent == null) {
            this.mergeAccesses(reload);
        }
    }

    private void mergeAccesses(boolean reload) {
        OrgAccess[] orgAccess = new OrgAccess[]{};
        MTableAccess[] tableAccess = new MTableAccess[]{};
        MColumnAccess[] columnAccess = new MColumnAccess[]{};
        MRecordAccess[] recordAccess = new MRecordAccess[]{};
        MRecordAccess[] recordDependentAccess = new MRecordAccess[]{};
        MRole last_role = null;
        for (MRole role : this.getIncludedRoles(false)) {
            boolean override = false;
            if (last_role != null && last_role.m_includedSeqNo >= 0 && role.m_includedSeqNo >= 0 && last_role.m_includedSeqNo == role.m_includedSeqNo) {
                override = true;
            }
            role.loadAccess(reload);
            role.mergeAccesses(reload);
            orgAccess = MRole.mergeAccess(orgAccess, role.m_orgAccess, override);
            tableAccess = MRole.mergeAccess(tableAccess, role.m_tableAccess, override);
            columnAccess = MRole.mergeAccess(columnAccess, role.m_columnAccess, override);
            recordAccess = MRole.mergeAccess(recordAccess, role.m_recordAccess, override);
            recordDependentAccess = MRole.mergeAccess(recordDependentAccess, role.m_recordDependentAccess, override);
            last_role = role;
        }
        this.m_orgAccess = MRole.mergeAccess(this.m_orgAccess, orgAccess, false);
        this.m_tableAccess = MRole.mergeAccess(this.m_tableAccess, tableAccess, false);
        this.m_columnAccess = MRole.mergeAccess(this.m_columnAccess, columnAccess, false);
        this.m_recordAccess = MRole.mergeAccess(this.m_recordAccess, recordAccess, false);
        this.m_recordDependentAccess = MRole.mergeAccess(this.m_recordDependentAccess, recordDependentAccess, false);
    }

    private void loadChildRoles(boolean reload) {
        this.m_includedRoles = null;
        int AD_User_ID = this.getAD_User_ID();
        if (AD_User_ID < 0) {
            this.log.info("Trying to load Child Roles but user has not been set");
            return;
        }
        List list = new Query(this.getCtx(), "AD_Role_Included", "AD_Role_ID=?", this.get_TrxName()).setParameters(this.getAD_Role_ID()).setOnlyActiveRecords(true).setOrderBy("SeqNo,Included_Role_ID").list();
        for (X_AD_Role_Included includedRole : list) {
            MRole role = MRole.get(this.getCtx(), includedRole.getIncluded_Role_ID());
            this.includeRole(role, includedRole.getSeqNo());
        }
    }

    private void loadSubstitutedRoles(boolean reload) {
        if (this.m_parent != null || this.isMasterRole()) {
            return;
        }
        int AD_User_ID = this.getAD_User_ID();
        if (AD_User_ID < 0) {
            this.log.info("Trying to load Substituted Roles but user has not been set");
            return;
        }
        List list = new Query(this.getCtx(), "AD_Role", "EXISTS ( SELECT 1 FROM AD_User_Roles ur INNER JOIN AD_User_Substitute us ON (us.AD_User_ID=ur.AD_User_ID) WHERE ur.AD_Role_ID=AD_Role.AD_Role_ID AND ur.IsActive='Y' AND us.IsActive='Y' AND (us.ValidFrom IS NULL OR us.ValidFrom <= getDate()) AND (us.ValidTo IS NULL OR us.ValidTo >= getDate()) AND us.Substitute_ID=?)", this.get_TrxName()).setParameters(AD_User_ID).setClient_ID().setOrderBy("AD_Role_ID").list();
        for (MRole role : list) {
            this.includeRole(role, -1);
        }
    }

    private void setParentRole(MRole parent) {
        this.setAD_User_ID(parent.getAD_User_ID());
        this.m_parent = parent;
    }

    private static final <T> T[] mergeAccess(T[] array1, T[] array2, boolean override) {
        if (array1 == null) {
            s_log.info("array1 null !!!");
        }
        ArrayList<T> list = new ArrayList<T>();
        T[] TArray = array1;
        int n = array1.length;
        int n2 = 0;
        while (n2 < n) {
            T po = TArray[n2];
            list.add(po);
            ++n2;
        }
        TArray = array2;
        n = array2.length;
        n2 = 0;
        while (n2 < n) {
            T o2 = TArray[n2];
            boolean found = false;
            int i = 0;
            while (i < array1.length) {
                T o1 = array1[i];
                if (o1 instanceof OrgAccess) {
                    OrgAccess oa1 = (OrgAccess)o1;
                    OrgAccess oa2 = (OrgAccess)o2;
                    found = oa1.equals(oa2);
                    if (found && override && !oa2.readOnly) {
                        oa1.readOnly = false;
                    }
                } else if (o1 instanceof MTableAccess) {
                    MTableAccess ta1 = (MTableAccess)o1;
                    MTableAccess ta2 = (MTableAccess)o2;
                    boolean bl = found = ta1.getAD_Table_ID() == ta2.getAD_Table_ID();
                    if (found && override && !ta2.isExclude()) {
                        ta1.setIsExclude(false);
                    }
                } else if (o1 instanceof MColumnAccess) {
                    MColumnAccess ca1 = (MColumnAccess)o1;
                    MColumnAccess ca2 = (MColumnAccess)o2;
                    boolean bl = found = ca1.getAD_Column_ID() == ca2.getAD_Column_ID();
                    if (found && override) {
                        if (!ca2.isReadOnly()) {
                            ca1.setIsReadOnly(false);
                        }
                        if (!ca2.isExclude()) {
                            ca1.setIsExclude(false);
                        }
                    }
                } else if (o1 instanceof MRecordAccess) {
                    MRecordAccess ra1 = (MRecordAccess)o1;
                    MRecordAccess ra2 = (MRecordAccess)o2;
                    boolean bl = found = ra1.getAD_Table_ID() == ra2.getAD_Table_ID() && ra1.getRecord_ID() == ra2.getRecord_ID();
                    if (found && override) {
                        if (!ra2.isReadOnly()) {
                            ra1.setIsReadOnly(false);
                        }
                        if (!ra2.isDependentEntities()) {
                            ra1.setIsDependentEntities(false);
                        }
                        if (!ra2.isExclude()) {
                            ra1.setIsExclude(false);
                        }
                    }
                } else {
                    throw new AdempiereException("Not supported objects - " + String.valueOf(o1) + ", " + String.valueOf(o2));
                }
                if (found) break;
                ++i;
            }
            if (!found) {
                list.add(o2);
            }
            ++n2;
        }
        Object[] arr = (Object[])Array.newInstance(array1.getClass().getComponentType(), list.size());
        return list.toArray(arr);
    }

    private static final HashMap<Integer, Boolean> mergeAccess(HashMap<Integer, Boolean> map1, HashMap<Integer, Boolean> map2, boolean override) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        if (map1 != null) {
            map.putAll(map1);
        }
        for (Map.Entry<Integer, Boolean> e : map2.entrySet()) {
            Integer key = e.getKey();
            Boolean b2 = e.getValue();
            if (b2 == null) continue;
            Boolean b1 = map.get(key);
            if (b1 == null) {
                map.put(key, b2);
                continue;
            }
            if (!override) continue;
            map.put(key, b2);
        }
        return map;
    }

    private void mergeIncludedAccess(String varname) {
        HashMap<Integer, Boolean> includedAccess = new HashMap<Integer, Boolean>();
        MRole last_role = null;
        for (MRole role : this.getIncludedRoles(false)) {
            boolean override = false;
            if (last_role != null && last_role.m_includedSeqNo >= 0 && role.m_includedSeqNo >= 0 && last_role.m_includedSeqNo == role.m_includedSeqNo) {
                override = true;
            }
            includedAccess = MRole.mergeAccess(includedAccess, role.getAccessMap(varname), override);
            last_role = role;
        }
        this.setAccessMap(varname, MRole.mergeAccess(this.getAccessMap(varname), includedAccess, false));
    }

    private HashMap<Integer, Boolean> getAccessMap(String varname) {
        if ("m_windowAccess".equals(varname)) {
            this.getWindowAccess(-1);
            return this.m_windowAccess;
        }
        if ("m_processAccess".equals(varname)) {
            this.getProcessAccess(-1);
            return this.m_processAccess;
        }
        if ("m_taskAccess".equals(varname)) {
            this.getTaskAccess(-1);
            return this.m_taskAccess;
        }
        if ("m_workflowAccess".equals(varname)) {
            this.getWorkflowAccess(-1);
            return this.m_workflowAccess;
        }
        if ("m_formAccess".equals(varname)) {
            this.getFormAccess(-1);
            return this.m_formAccess;
        }
        if ("m_infoAccess".equals(varname)) {
            this.getInfoAccess(-1);
            return this.m_infoAccess;
        }
        throw new IllegalArgumentException("varname not supported - " + varname);
    }

    private void setAccessMap(String varname, HashMap<Integer, Boolean> map) {
        if ("m_windowAccess".equals(varname)) {
            this.m_windowAccess = map;
        } else if ("m_processAccess".equals(varname)) {
            this.m_processAccess = map;
        } else if ("m_taskAccess".equals(varname)) {
            this.m_taskAccess = map;
        } else if ("m_workflowAccess".equals(varname)) {
            this.m_workflowAccess = map;
        } else if ("m_formAccess".equals(varname)) {
            this.m_formAccess = map;
        } else if ("m_infoAccess".equals(varname)) {
            this.m_infoAccess = map;
        } else {
            throw new IllegalArgumentException("varname not supported - " + varname);
        }
    }

    public String getIncludedRolesWhereClause(String roleColumnSQL, List<Object> params) {
        StringBuilder whereClause = new StringBuilder();
        if (params != null) {
            whereClause.append("?");
            params.add(this.getAD_Role_ID());
        } else {
            whereClause.append(this.getAD_Role_ID());
        }
        for (MRole role : this.getIncludedRoles(true)) {
            if (params != null) {
                whereClause.append(",?");
                params.add(role.getAD_Role_ID());
                continue;
            }
            whereClause.append(",").append(role.getAD_Role_ID());
        }
        whereClause.insert(0, roleColumnSQL + " IN (").append(")");
        return whereClause.toString();
    }

    public synchronized Boolean getInfoAccess(int AD_InfoWindow_ID) {
        if (this.m_infoAccess == null) {
            HashMap<Integer, Boolean> directAccess;
            block8: {
                this.m_infoAccess = new HashMap(20);
                this.mergeIncludedAccess("m_infoAccess");
                String ASPFilter = "";
                String sql = "SELECT AD_InfoWindow_ID, IsActive FROM AD_InfoWindow_Access WHERE AD_Role_ID=?" + ASPFilter;
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                directAccess = new HashMap<Integer, Boolean>(100);
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, this.get_TrxName());
                        pstmt.setInt(1, this.getAD_Role_ID());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            Integer infoId = rs.getInt(1);
                            if ("N".equals(rs.getString(2))) {
                                if (!this.m_infoAccess.containsKey(infoId)) continue;
                                this.m_infoAccess.remove(infoId);
                                continue;
                            }
                            directAccess.put(infoId, Boolean.TRUE);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
            this.setAccessMap("m_infoAccess", MRole.mergeAccess(this.getAccessMap("m_infoAccess"), directAccess, true));
        }
        Boolean retValue = this.m_infoAccess.get(AD_InfoWindow_ID);
        return retValue;
    }

    public boolean canAccess_Info_Product() {
        if (this.m_canAccess_Info_Product == null) {
            String sql = "SELECT COUNT(*) FROM   AD_InfoWindow iw        JOIN AD_InfoWindow_Access iwa          ON ( iwa.AD_InfoWindow_ID = iw.AD_InfoWindow_ID ) WHERE  AD_Table_ID = ?        AND iw.IsActive = 'Y'        AND iwa.IsActive = 'Y'        AND (iwa.AD_Role_ID = ? OR iwa.AD_Role_ID IN       \t\t(SELECT ri.Included_Role_ID FROM AD_Role_Included ri WHERE ri.IsActive='Y' AND ri.AD_Role_ID=?))";
            int cnt = DB.getSQLValueEx(this.get_TrxName(), sql, 208, this.getAD_Role_ID(), this.getAD_Role_ID());
            this.m_canAccess_Info_Product = cnt > 0;
            if (this.m_canAccess_Info_Product.booleanValue()) {
                String sqlInactive = "SELECT COUNT(*) FROM   AD_InfoWindow iw        JOIN AD_InfoWindow_Access iwa          ON ( iwa.AD_InfoWindow_ID = iw.AD_InfoWindow_ID ) WHERE  AD_Table_ID = ?        AND iw.IsActive = 'Y'        AND iwa.IsActive = 'N'        AND iwa.AD_Role_ID = ?";
                int cntInactive = DB.getSQLValueEx(this.get_TrxName(), sqlInactive, 208, this.getAD_Role_ID());
                if (cntInactive > 0) {
                    this.m_canAccess_Info_Product = Boolean.FALSE;
                }
            }
        }
        return this.m_canAccess_Info_Product;
    }

    public static String getWhereRoleType(String roleType, String tableName) {
        if (Util.isEmpty(roleType, true)) {
            return null;
        }
        boolean includeNull = false;
        String[] types = roleType.split(",");
        StringBuilder whereClause = new StringBuilder("(");
        boolean start = true;
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if ("null".equalsIgnoreCase(type)) {
                includeNull = true;
            } else {
                if (start) {
                    if (!Util.isEmpty(tableName)) {
                        whereClause.append(tableName).append(".");
                    }
                    whereClause.append("RoleType").append(" IN (");
                    start = false;
                } else {
                    whereClause.append(",");
                }
                whereClause.append(DB.TO_STRING(type));
            }
            ++n2;
        }
        if (!start) {
            whereClause.append(")");
        }
        if (includeNull) {
            if (!start) {
                whereClause.append(" OR ");
            }
            if (!Util.isEmpty(tableName)) {
                whereClause.append(tableName).append(".");
            }
            whereClause.append("RoleType").append(" IS NULL");
        }
        whereClause.append(")");
        return whereClause.toString();
    }

    private boolean isAccessLevelCompatible(String accessLevel) {
        boolean access = false;
        switch (this.getUserLevel()) {
            case "S  ": {
                switch (accessLevel) {
                    case "4": 
                    case "6": 
                    case "7": {
                        access = true;
                    }
                }
            }
            case " C ": {
                switch (accessLevel) {
                    case "2": 
                    case "3": 
                    case "6": 
                    case "7": {
                        access = true;
                    }
                }
            }
            case "  O": {
                switch (accessLevel) {
                    case "1": 
                    case "3": 
                    case "7": {
                        access = true;
                    }
                }
            }
            case " CO": {
                switch (accessLevel) {
                    case "1": 
                    case "2": 
                    case "3": 
                    case "6": 
                    case "7": {
                        access = true;
                    }
                }
            }
        }
        return access;
    }

    public boolean isTableAccessExcluded(int tableID) {
        this.loadTableAccess(false);
        int i = 0;
        while (i < this.m_tableAccess.length) {
            if (this.m_tableAccess[i].isExclude() && this.m_tableAccess[i].getAD_Table_ID() == tableID && !this.m_tableAccess[i].isReadOnly() && "A".equals(this.m_tableAccess[i].getAccessTypeRule())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public MRole markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }

    public boolean checkAccessSQL(MTable table2, int recordId, String uuid, boolean rw) {
        StringBuilder sql = new StringBuilder("SELECT 1 FROM ").append(table2.getTableName()).append(" WHERE ").append(table2.getTableName()).append(".");
        if (!Util.isEmpty(uuid, true)) {
            sql.append(PO.getUUIDColumnName(table2.getTableName())).append("=?");
            return DB.getSQLValueEx(null, this.addAccessSQL(sql.toString(), table2.getTableName(), true, rw), uuid) == 1;
        }
        sql.append(table2.getKeyColumns()[0]).append("=?");
        return DB.getSQLValueEx(null, this.addAccessSQL(sql.toString(), table2.getTableName(), true, rw), recordId) == 1;
    }

    @Override
    public String getPredefinedContextVariables() {
        StringBuilder predefinedContextVariables = new StringBuilder();
        for (MRole role : this.getIncludedRoles(false)) {
            if (role.get_Value("PredefinedContextVariables") == null) continue;
            if (predefinedContextVariables.length() > 0) {
                predefinedContextVariables.append("\n");
            }
            predefinedContextVariables.append(role.get_Value("PredefinedContextVariables").toString());
        }
        if (this.get_Value("PredefinedContextVariables") != null) {
            if (predefinedContextVariables.length() > 0) {
                predefinedContextVariables.append("\n");
            }
            predefinedContextVariables.append(this.get_Value("PredefinedContextVariables").toString());
        }
        return predefinedContextVariables.toString();
    }

    class OrgAccess
    implements Serializable {
        private static final long serialVersionUID = -4880665261978385315L;
        public int AD_Client_ID = 0;
        public int AD_Org_ID = 0;
        public boolean readOnly = true;

        public OrgAccess(int ad_Client_ID, int ad_Org_ID, boolean readonly) {
            this.AD_Client_ID = ad_Client_ID;
            this.AD_Org_ID = ad_Org_ID;
            this.readOnly = readonly;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof OrgAccess) {
                OrgAccess comp = (OrgAccess)obj;
                return comp.AD_Client_ID == this.AD_Client_ID && comp.AD_Org_ID == this.AD_Org_ID;
            }
            return false;
        }

        public int hashCode() {
            return this.AD_Client_ID * 7 + this.AD_Org_ID;
        }

        public String toString() {
            String clientName = "System";
            if (this.AD_Client_ID != 0) {
                clientName = MClient.get(MRole.this.getCtx(), this.AD_Client_ID).getName();
            }
            String orgName = "*";
            if (this.AD_Org_ID != 0) {
                orgName = MOrg.get(this.AD_Org_ID).getName();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(Msg.translate(MRole.this.getCtx(), "AD_Client_ID")).append("=").append(clientName).append(" - ").append(Msg.translate(MRole.this.getCtx(), "AD_Org_ID")).append("=").append(orgName);
            if (this.readOnly) {
                sb.append(" r/o");
            }
            return sb.toString();
        }
    }
}

