/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_Bank;
import org.compiere.acct.DocLine_DepositBatch;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MDepositBatchLine;
import org.compiere.model.MPayment;
import org.compiere.util.Env;

public class Doc_BankStatement
extends Doc {
    protected int m_C_BankAccount_ID = 0;

    public Doc_BankStatement(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MBankStatement.class, rs, null, trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        MBankStatement bs = (MBankStatement)this.getPO();
        this.setDateDoc(bs.getStatementDate());
        this.setDateAcct(bs.getDateAcct());
        this.m_C_BankAccount_ID = bs.getC_BankAccount_ID();
        this.setAmount(0, bs.getStatementDifference());
        MBankAccount ba = MBankAccount.get(this.getCtx(), this.m_C_BankAccount_ID);
        this.setC_Currency_ID(ba.getC_Currency_ID());
        this.p_lines = this.loadLines(bs);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Lines=" + this.p_lines.length);
        }
        return null;
    }

    protected DocLine[] loadLines(MBankStatement bs) {
        ArrayList<DocLine_Bank> list = new ArrayList<DocLine_Bank>();
        MBankStatementLine[] lines = bs.getLines(false);
        int i2 = 0;
        while (i2 < lines.length) {
            MBankStatementLine line = lines[i2];
            if (line.isActive()) {
                DocLine_Bank docLine = new DocLine_Bank(line, this);
                list.add(docLine);
            }
            ++i2;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        StringBuilder sb = new StringBuilder(" [");
        retValue = retValue.add(this.getAmount(0));
        sb.append(this.getAmount(0));
        int i2 = 0;
        while (i2 < this.p_lines.length) {
            BigDecimal lineBalance = ((DocLine_Bank)this.p_lines[i2]).getStmtAmt();
            retValue = retValue.subtract(lineBalance);
            sb.append("-").append(lineBalance);
            ++i2;
        }
        sb.append("]");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.toString() + " Balance=" + String.valueOf(retValue) + sb.toString());
        }
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        FactLine fl = null;
        int AD_Org_ID = this.getBank_Org_ID();
        int i2 = 0;
        while (i2 < this.p_lines.length) {
            DocLine_Bank line = (DocLine_Bank)this.p_lines[i2];
            int C_BPartner_ID = line.getC_BPartner_ID();
            MAccount acct_bank_asset = this.getAccount(40, as);
            MAccount acct_bank_in_transit = this.getAccount(11, as);
            if (!as.isPostIfClearingEqual() && acct_bank_asset.equals(acct_bank_in_transit)) {
                BigDecimal amt_stmt_minus_trx = line.getStmtAmt().subtract(line.getTrxAmt());
                if (amt_stmt_minus_trx.compareTo(Env.ZERO) != 0) {
                    fl = fact.createLine(line, acct_bank_asset, line.getC_Currency_ID(), amt_stmt_minus_trx);
                    if (fl != null && AD_Org_ID != 0) {
                        fl.setAD_Org_ID(AD_Org_ID);
                    }
                    if (fl != null && C_BPartner_ID != 0) {
                        fl.setC_BPartner_ID(C_BPartner_ID);
                    }
                }
            } else {
                MBankStatementLine statementLine;
                fl = fact.createLine(line, acct_bank_asset, line.getC_Currency_ID(), line.getStmtAmt());
                if (fl != null && AD_Org_ID != 0) {
                    fl.setAD_Org_ID(AD_Org_ID);
                }
                if (fl != null && C_BPartner_ID != 0) {
                    fl.setC_BPartner_ID(C_BPartner_ID);
                }
                if ((statementLine = (MBankStatementLine)line.getPO()).getC_DepositBatch_ID() != 0) {
                    MDepositBatchLine[] depositBatchLines;
                    MDepositBatchLine[] mDepositBatchLineArray = depositBatchLines = statementLine.getC_DepositBatch().getLines();
                    int n = depositBatchLines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MDepositBatchLine depositLine = mDepositBatchLineArray[n2];
                        MPayment payment = depositLine.getC_Payment();
                        DocLine_DepositBatch docDepositLine = new DocLine_DepositBatch(payment, this, statementLine.isReversal());
                        fl = fact.createLine(docDepositLine, this.getAccount(11, as), payment.getC_Currency_ID(), payment.isReceipt() ? payment.getPayAmt().negate() : payment.getPayAmt());
                        fl.setLine_ID(statementLine.get_ID());
                        if (fl != null) {
                            if (C_BPartner_ID != 0) {
                                fl.setC_BPartner_ID(C_BPartner_ID);
                            }
                            if (AD_Org_ID != 0) {
                                fl.setAD_Org_ID(AD_Org_ID);
                            } else {
                                fl.setAD_Org_ID(docDepositLine.getAD_Org_ID(true));
                            }
                        }
                        ++n2;
                    }
                } else {
                    fl = fact.createLine(line, this.getAccount(11, as), line.getC_Currency_ID(), line.getTrxAmt().negate());
                    if (fl != null) {
                        if (C_BPartner_ID != 0) {
                            fl.setC_BPartner_ID(C_BPartner_ID);
                        }
                        if (AD_Org_ID != 0) {
                            fl.setAD_Org_ID(AD_Org_ID);
                        } else {
                            fl.setAD_Org_ID(line.getAD_Org_ID(true));
                        }
                    }
                }
            }
            if ((fl = line.getChargeAmt().compareTo(Env.ZERO) > 0 ? fact.createLine((DocLine)line, line.getChargeAccount(as, line.getChargeAmt().negate()), line.getC_Currency_ID(), null, line.getChargeAmt()) : fact.createLine((DocLine)line, line.getChargeAccount(as, line.getChargeAmt().negate()), line.getC_Currency_ID(), line.getChargeAmt().negate(), null)) != null && C_BPartner_ID != 0) {
                fl.setC_BPartner_ID(C_BPartner_ID);
            }
            if ((fl = line.getInterestAmt().signum() < 0 ? fact.createLine((DocLine)line, this.getAccount(42, as), this.getAccount(42, as), line.getC_Currency_ID(), line.getInterestAmt().negate()) : fact.createLine((DocLine)line, this.getAccount(41, as), this.getAccount(41, as), line.getC_Currency_ID(), line.getInterestAmt().negate())) != null && C_BPartner_ID != 0) {
                fl.setC_BPartner_ID(C_BPartner_ID);
            }
            ++i2;
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }

    protected int getBank_Org_ID() {
        if (this.m_C_BankAccount_ID == 0) {
            return 0;
        }
        MBankAccount ba = MBankAccount.get(this.getCtx(), this.m_C_BankAccount_ID);
        return ba.getAD_Org_ID();
    }
}

