/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.zk.billboard;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONObject;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.CategoryModel;
import org.zkoss.zul.ChartModel;
import org.zkoss.zul.DialModel;
import org.zkoss.zul.PieModel;
import org.zkoss.zul.event.ChartDataEvent;
import org.zkoss.zul.event.ChartDataListener;
import org.zkoss.zul.impl.XulElement;

public class Billboard
extends XulElement {
    private static final long serialVersionUID = -2164790050418874185L;
    private ChartModel _model;
    private ChartDataListener _dataListener;
    private String _title = "";
    private String _type = "line";
    private String _orient = "vertical";
    private Map<String, Object> _rendererOptions;
    private Map<String, Object> _legend;
    private boolean timeSeries = false;
    private String timeSeriesInterval = "1 months";
    private String timeSeriesFormat = "%b %Y";
    private String tickAxisLabel = null;
    private String valueAxisLabel = null;
    private String[] seriesColors = null;
    private int xAxisAngle = 0;
    private String locale = null;
    public static final String ON_DATA_CLICK_EVENT = "onDataClick";
    public static final String VERTICAL_ORIENTATION = "vertical";
    public static final String HORIZONTAL_ORIENTATION = "horizontal";
    private static final List<Object> _VALID_TYPES;

    static {
        Billboard.addClientEvent(Billboard.class, (String)"onClick", (int)1);
        Billboard.addClientEvent(Billboard.class, (String)ON_DATA_CLICK_EVENT, (int)1);
        _VALID_TYPES = Arrays.asList("pie", "line", "bar", "area", "stacked_bar", "stacked_area", "gauge", "donut", "waterfall");
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        JSONObject jData;
        super.renderProperties(renderer);
        this.render(renderer, "type", this._type);
        this.render(renderer, "title", this._title);
        this.render(renderer, "orient", this._orient);
        this.render(renderer, "timeSeries", this.timeSeries);
        this.render(renderer, "xAxisAngle", this.xAxisAngle);
        this.render(renderer, "locale", this.toD3Locale(this.locale));
        if (this.timeSeries) {
            if (this.timeSeriesInterval != null) {
                this.render(renderer, "timeSeriesInterval", this.timeSeriesInterval);
            }
            if (this.timeSeriesFormat != null) {
                this.render(renderer, "timeSeriesFormat", this.timeSeriesFormat);
            }
        }
        String model = Billboard.toJSONArray(this.transferToJSONObject(this.getModel()));
        this.render(renderer, "model", model);
        if (this._rendererOptions != null && !this._rendererOptions.isEmpty()) {
            jData = this.mapToJSON(this._rendererOptions);
            this.render(renderer, "rendererOptions", jData.toString());
        }
        if (this._legend != null && !this._legend.isEmpty()) {
            jData = this.mapToJSON(this._legend);
            this.render(renderer, "legend", jData.toString());
        }
        if (this.tickAxisLabel != null) {
            this.render(renderer, "tickAxisLabel", this.tickAxisLabel);
        }
        if (this.valueAxisLabel != null) {
            this.render(renderer, "valueAxisLabel", this.valueAxisLabel);
        }
        if (this.seriesColors != null && this.seriesColors.length > 0) {
            jData = new JSONArray();
            String[] stringArray = this.seriesColors;
            int n = this.seriesColors.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                jData.add((Object)s);
                ++n2;
            }
            this.render(renderer, "seriesColors", jData.toString());
        }
    }

    private String toD3Locale(String locale) {
        if (locale == null) {
            return null;
        }
        if ("es_CO".equals(locale)) {
            return "es-ES";
        }
        return locale.replaceFirst("[_]", "-");
    }

    private JSONObject mapToJSON(Map<String, Object> map) {
        JSONObject jData = new JSONObject();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            jData.put((Object)key, value);
        }
        return jData;
    }

    public void service(AuRequest request, boolean everError) {
        if ("onClick".equals(request.getCommand())) {
            Events.postEvent((String)"onClick", (Component)this, (Object)request.getData());
        } else if (ON_DATA_CLICK_EVENT.equals(request.getCommand())) {
            Events.postEvent((String)ON_DATA_CLICK_EVENT, (Component)this, (Object)request.getData());
        } else {
            super.service(request, everError);
        }
    }

    public ChartModel getModel() {
        return this._model;
    }

    public void setModel(ChartModel model) {
        if (this._model != model) {
            if (this._model != null) {
                this._model.removeChartDataListener(this._dataListener);
            }
            this._model = model;
            if (this._dataListener == null) {
                this._dataListener = new DefaultChartDataListener();
                this._model.addChartDataListener(this._dataListener);
            }
            this.invalidate();
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        if (!title.equals(this._title)) {
            this._title = title;
            this.smartUpdate("title", this._title);
            this.invalidate();
        }
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        if (!type.equals(this._type) && Billboard.isValid(type)) {
            this._type = type;
            this.smartUpdate("type", this._type);
            this.invalidate();
        }
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) {
        if (!orient.equals(this._orient)) {
            this._orient = orient;
            this.smartUpdate("orient", this._orient);
            this.invalidate();
        }
    }

    public void addRendererOptions(String key, Object value) {
        if (this._rendererOptions == null) {
            this._rendererOptions = new HashMap<String, Object>();
        }
        this._rendererOptions.put(key, value);
    }

    public void addLegendOptions(String key, Object value) {
        if (this._legend == null) {
            this._legend = new HashMap<String, Object>();
        }
        this._legend.put(key, value);
    }

    private List<JSONObject> transferToJSONObject(ChartModel model) {
        LinkedList<JSONObject> list = new LinkedList<JSONObject>();
        if (model == null || this._type == null) {
            return list;
        }
        if ("gauge".equals(this._type)) {
            DialModel dialModel = (DialModel)model;
            JSONObject json = new JSONObject();
            json.put((Object)"value", (Object)new double[]{dialModel.getValue(0)});
            list.add(json);
        } else if ("pie".equals(this._type) || "donut".equals(this._type)) {
            PieModel tempModel = (PieModel)model;
            int i = 0;
            while (i < tempModel.getCategories().size()) {
                Comparable category = tempModel.getCategory(i);
                JSONObject json = new JSONObject();
                json.put((Object)"category", (Object)category);
                json.put((Object)"value", (Object)tempModel.getValue(category));
                list.add(json);
                ++i;
            }
        } else {
            CategoryModel tempModel = (CategoryModel)model;
            int seriesLength = tempModel.getSeries().size();
            int j = 0;
            while (j < seriesLength) {
                Comparable series = tempModel.getSeries(j);
                int i = 0;
                while (i < tempModel.getCategories().size()) {
                    Comparable category = tempModel.getCategory(i);
                    Number value = tempModel.getValue(series, category);
                    if (value != null) {
                        JSONObject jData = new JSONObject();
                        jData.put((Object)"category", (Object)category);
                        jData.put((Object)"series", (Object)series);
                        jData.put((Object)"value", (Object)(value != null ? (Number)value : (Number)0.0));
                        list.add(jData);
                    }
                    ++i;
                }
                ++j;
            }
        }
        return list;
    }

    private static String toJSONArray(List<JSONObject> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer().append('[');
        Iterator<JSONObject> it = list.iterator();
        while (it.hasNext()) {
            String s = String.valueOf(it.next());
            sb.append(s).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(']');
        return sb.toString().replaceAll("\\\\", "");
    }

    private static boolean isValid(String type) {
        return _VALID_TYPES.contains(type);
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-billboard";
    }

    public void setLegend(boolean show, boolean insideGrid) {
        if (show) {
            this.addLegendOptions("show", Boolean.TRUE);
            this.addLegendOptions("location", "bottom");
            if (insideGrid) {
                this.addLegendOptions("placement", "insideGrid");
            } else {
                this.addLegendOptions("placement", "outsideGrid");
            }
        } else {
            this.addLegendOptions("show", Boolean.FALSE);
        }
    }

    public String getTickAxisLabel() {
        return this.tickAxisLabel;
    }

    public void setTickAxisLabel(String tickAxisLabel) {
        this.tickAxisLabel = tickAxisLabel;
    }

    public String getValueAxisLabel() {
        return this.valueAxisLabel;
    }

    public void setValueAxisLabel(String valueAxisLabel) {
        this.valueAxisLabel = valueAxisLabel;
    }

    public boolean isTimeSeries() {
        return this.timeSeries;
    }

    public void setTimeSeries(boolean _timeSeries) {
        this.timeSeries = _timeSeries;
    }

    public String getTimeSeriesInterval() {
        return this.timeSeriesInterval;
    }

    public void setTimeSeriesInterval(String _timeSeriesInterval) {
        this.timeSeriesInterval = _timeSeriesInterval;
    }

    public String getTimeSeriesFormat() {
        return this.timeSeriesFormat;
    }

    public void setTimeSeriesFormat(String timeSeriesFormat) {
        this.timeSeriesFormat = timeSeriesFormat;
    }

    public String[] getSeriesColors() {
        return this.seriesColors;
    }

    public void setSeriesColors(String[] seriesColors) {
        this.seriesColors = seriesColors;
    }

    public int getXAxisAngle() {
        return this.xAxisAngle;
    }

    public void setXAxisAngle(int xAxisAngle) {
        this.xAxisAngle = xAxisAngle;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    private class DefaultChartDataListener
    implements ChartDataListener,
    Serializable {
        private static final long serialVersionUID = 20091125153002L;

        private DefaultChartDataListener() {
        }

        public void onChange(ChartDataEvent event) {
            Billboard.this.invalidate();
        }
    }
}

