/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.List;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MSequence;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.CacheMgt;

@Process
public class EnableNativeSequence
extends SvrProcess {
    @Override
    protected void prepare() {
    }

    @Override
    protected String doIt() throws Exception {
        boolean SYSTEM_NATIVE_SEQUENCE = MSysConfig.getBooleanValue("SYSTEM_NATIVE_SEQUENCE", false);
        if (SYSTEM_NATIVE_SEQUENCE) {
            throw new AdempiereException("Native Sequence is already set");
        }
        MSysConfig conf = new MSysConfig(this.getCtx(), 50016, null);
        conf.setValue("Y");
        conf.saveEx();
        CacheMgt.get().reset("AD_SysConfig");
        try {
            this.createSequence("AD_Sequence", null);
            this.createSequence("AD_Issue", null);
            this.createSequence("AD_ChangeLog", null);
            List tables = new Query(this.getCtx(), "AD_Table", "TableName NOT IN ('AD_Sequence', 'AD_Issue', 'AD_ChangeLog')", this.get_TrxName()).setOrderBy("TableName").list();
            for (MTable table2 : tables) {
                this.createSequence(table2, this.get_TrxName());
            }
        }
        catch (Exception e) {
            conf.setValue("N");
            conf.saveEx();
            throw e;
        }
        return "@OK@";
    }

    private void createSequence(MTable table2, String trxName) {
        if (!table2.isView()) {
            if (!MSequence.createTableSequence(this.getCtx(), table2.getTableName(), trxName)) {
                throw new AdempiereException("Can not create Native Sequence for table " + table2.getTableName());
            }
            this.addLog("Create Native Sequence for : " + table2.getTableName());
        }
    }

    private void createSequence(String tableName, String trxName) {
        this.createSequence(MTable.get(this.getCtx(), tableName), trxName);
    }
}

