/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PackoutItem;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ShellScriptElementHandler
extends AbstractElementHandler
implements ElementHandler {
    private static final String SHELL_SCRIPT = "ShellScript";
    private Path m_tmpfile = null;

    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        String script = this.getStringValue(element, SHELL_SCRIPT);
        Set<PosixFilePermission> fp = PosixFilePermissions.fromString("rwx------");
        try {
            this.m_tmpfile = Files.createTempFile("2PackShellScript_", ".sh", PosixFilePermissions.asFileAttribute(fp));
            Files.write(this.m_tmpfile, script.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new AdempiereException((Throwable)e);
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "", 0);
        int exitCode = -1;
        StringBuilder out = new StringBuilder();
        StringBuilder err = new StringBuilder();
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command(this.m_tmpfile.toString());
            Process process = processBuilder.start();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = stdInput.readLine()) != null) {
                out.append(line);
            }
            while ((line = stdError.readLine()) != null) {
                err.append(line);
            }
            exitCode = process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            ctx.packIn.getNotifier().addFailureLine("Shell Script failed, error (" + e.getLocalizedMessage() + "):");
            this.logImportDetail(ctx, impDetail, 0, SHELL_SCRIPT, exitCode, "Execute", script, e.getLocalizedMessage() + "\nout -> " + out.toString() + "\nerr -> " + err.toString());
            if (out.length() > 0) {
                ctx.packIn.getNotifier().addFailureLine("out -> " + out.toString());
            }
            if (err.length() > 0) {
                ctx.packIn.getNotifier().addFailureLine("err -> " + err.toString());
            }
            this.log.log(Level.SEVERE, SHELL_SCRIPT, (Throwable)e);
            throw new AdempiereException((Throwable)e);
        }
        if (out.length() > 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Executed Shell Script with stdout: " + out.toString());
        }
        if (err.length() > 0 && this.log.isLoggable(Level.WARNING)) {
            this.log.warning("Executed Shell Script with stderr: " + err.toString());
        }
        if (exitCode != 0) {
            this.logImportDetail(ctx, impDetail, 0, SHELL_SCRIPT, exitCode, "Execute", script, "exitCode -> " + exitCode + "\nout -> " + out.toString() + "\nerr -> " + err.toString());
            if (out.length() > 0) {
                ctx.packIn.getNotifier().addFailureLine("out -> " + out.toString());
            }
            if (err.length() > 0) {
                ctx.packIn.getNotifier().addFailureLine("err -> " + err.toString());
            }
            throw new AdempiereException("Failed execution of shell script");
        }
        this.logImportDetail(ctx, impDetail, 1, SHELL_SCRIPT, exitCode, "Execute", script, "exitCode -> " + exitCode + "\nout -> " + out.toString() + "\nerr -> " + err.toString());
        if (out.length() > 0) {
            ctx.packIn.getNotifier().addSuccessLine("out -> " + out.toString());
        }
        if (err.length() > 0) {
            ctx.packIn.getNotifier().addSuccessLine("err -> " + err.toString());
        }
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        String execCode = Env.getContext((Properties)ctx.ctx, (String)"ExecCode");
        AttributesImpl atts = new AttributesImpl();
        this.addTypeName(atts, "custom");
        document.startElement("", "", SHELL_SCRIPT, atts);
        this.createShellScriptBinding(document, execCode);
        document.endElement("", "", SHELL_SCRIPT);
    }

    private void createShellScriptBinding(TransformerHandler document, String execCode) throws SAXException {
        document.startElement("", "", SHELL_SCRIPT, new AttributesImpl());
        char[] contents = execCode.toCharArray();
        document.startCDATA();
        document.characters(contents, 0, contents.length);
        document.endCDATA();
        document.endElement("", "", SHELL_SCRIPT);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        PackoutItem detail = packout.getCurrentPackoutItem();
        Env.setContext((Properties)packout.getCtx().ctx, (String)"ExecCode", (String)((String)detail.getProperty("ExecCode")));
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("ExecCode");
    }
}

