/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RequisitionTest
extends AbstractTestCase {
    @Test
    public void testComplete() {
        int purchaseRequisition = DictionaryIDs.C_DocType.PURCHASE_REQUISITION.id;
        int standardPriceList = DictionaryIDs.M_PriceList.STANDARD.id;
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        MRequisition requisition = new MRequisition(Env.getCtx(), 0, this.getTrxName());
        requisition.setC_DocType_ID(purchaseRequisition);
        requisition.setDateDoc(today);
        requisition.setDateRequired(today);
        requisition.setDocAction("CO");
        requisition.setDocStatus("DR");
        requisition.setM_Warehouse_ID(this.getM_Warehouse_ID());
        requisition.setAD_User_ID(this.getAD_User_ID());
        requisition.setAD_Org_ID(this.getAD_Org_ID());
        requisition.setM_PriceList_ID(standardPriceList);
        requisition.setPriorityRule("5");
        requisition.saveEx();
        int seeder = DictionaryIDs.M_Product.SEEDER.id;
        int each = DictionaryIDs.C_UOM.EACH.id;
        MRequisitionLine line = new MRequisitionLine(requisition);
        line.setM_Product_ID(seeder);
        line.setC_UOM_ID(each);
        line.setQty(new BigDecimal("1"));
        line.setPrice();
        line.saveEx();
        ProcessInfo pi = MWorkflow.runDocumentActionWorkflow((PO)requisition, (String)"CO");
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        requisition.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)requisition.getDocStatus());
    }
}

