/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.util;

import java.io.Serializable;
import java.util.Properties;
import org.compiere.model.MPreference;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Util;

public final class UserPreference
implements Serializable {
    private static final long serialVersionUID = -5225476997340598606L;
    public static final String P_LANGUAGE = "Language";
    private static final String DEFAULT_LANGUAGE = Language.getName((String)(System.getProperty("user.language") + "_" + System.getProperty("user.country")));
    public static final String P_ROLE = "Role";
    private static final String DEFAULT_ROLE = "";
    public static final String P_CLIENT = "Client";
    private static final String DEFAULT_CLIENT = "";
    public static final String P_ORG = "Organization";
    private static final String DEFAULT_ORG = "";
    public static final String P_WAREHOUSE = "Warehouse";
    private static final String DEFAULT_WAREHOUSE = "";
    public static final String LANGUAGE_NAME = "#LanguageName";
    public static final String P_MENU_COLLAPSED = "MenuCollapsed";
    public static final String DEFAULT_MENU_COLLAPSED = "N";
    public static final String P_HELP_COLLAPSED = "HelpCollapsed";
    public static final String DEFAULT_HELP_COLLAPSED = "N";
    public static final String P_HEADER_COLLAPSED = "HeaderCollapsed";
    public static final String DEFAULT_HEADER_COLLAPSED = "N";
    private static final String[] PROPERTIES = new String[]{"Language", "Role", "Client", "Organization", "Warehouse", "MenuCollapsed", "HelpCollapsed", "HeaderCollapsed"};
    private static final String[] VALUES = new String[]{DEFAULT_LANGUAGE, "", "", "", "", "N", "N", "N"};
    private Properties props = new Properties();
    private int m_AD_User_ID = -1;
    final String whereClause = "AD_User_ID=? AND Attribute=? AND AD_Window_ID IS NULL AND AD_Process_ID IS NULL AND PreferenceFor='W' AND AD_Client_ID=(SELECT AD_Client_ID FROM AD_User WHERE AD_User_ID=?)";
    private static final CLogger log = CLogger.getCLogger((String)UserPreference.class.getName());

    public void savePreference() {
        if (this.m_AD_User_ID > 0) {
            Query query = new Query(Env.getCtx(), "AD_Preference", "AD_User_ID=? AND Attribute=? AND AD_Window_ID IS NULL AND AD_Process_ID IS NULL AND PreferenceFor='W' AND AD_Client_ID=(SELECT AD_Client_ID FROM AD_User WHERE AD_User_ID=?)", null);
            int i = 0;
            while (i < PROPERTIES.length) {
                String attribute = PROPERTIES[i];
                String value = this.props.getProperty(attribute);
                if (!Util.isEmpty((String)value)) {
                    String oldValue;
                    MPreference preference = (MPreference)query.setParameters(new Object[]{this.m_AD_User_ID, attribute, this.m_AD_User_ID}).firstOnly();
                    if (preference == null) {
                        preference = new MPreference(Env.getCtx(), 0, null);
                        MUser user = MUser.get((int)this.m_AD_User_ID);
                        preference.set_ValueNoCheck("AD_Client_ID", (Object)user.getAD_Client_ID());
                        preference.setAD_Org_ID(0);
                        preference.setAD_User_ID(this.m_AD_User_ID);
                        preference.setAttribute(attribute);
                    }
                    if (!value.equals(oldValue = preference.getValue())) {
                        preference.setValue(value);
                        preference.saveCrossTenantSafeEx();
                    }
                }
                ++i;
            }
        }
    }

    public void loadPreference(int AD_User_ID) {
        this.m_AD_User_ID = AD_User_ID;
        if (AD_User_ID >= 0) {
            this.props = new Properties();
            Query query = new Query(Env.getCtx(), "AD_Preference", "AD_User_ID=? AND Attribute=? AND AD_Window_ID IS NULL AND AD_Process_ID IS NULL AND PreferenceFor='W' AND AD_Client_ID=(SELECT AD_Client_ID FROM AD_User WHERE AD_User_ID=?)", null);
            int i = 0;
            while (i < PROPERTIES.length) {
                String attribute = PROPERTIES[i];
                String value = VALUES[i];
                MPreference preference = (MPreference)query.setParameters(new Object[]{this.m_AD_User_ID, attribute, this.m_AD_User_ID}).firstOnly();
                if (preference != null && preference.getValue() != null) {
                    value = preference.getValue();
                }
                this.props.setProperty(attribute, value);
                ++i;
            }
        }
    }

    public void deletePreference() {
        if (this.m_AD_User_ID > 0) {
            this.props = new Properties();
            Query query = new Query(Env.getCtx(), "AD_Preference", "AD_User_ID=? AND Attribute=? AND AD_Window_ID IS NULL AND AD_Process_ID IS NULL AND PreferenceFor='W' AND AD_Client_ID=(SELECT AD_Client_ID FROM AD_User WHERE AD_User_ID=?)", null);
            int i = 0;
            while (i < PROPERTIES.length) {
                String attribute = PROPERTIES[i];
                MPreference preference = (MPreference)query.setParameters(new Object[]{this.m_AD_User_ID, attribute, this.m_AD_User_ID}).firstOnly();
                if (preference != null) {
                    preference.deleteEx(true);
                }
                ++i;
            }
        }
    }

    public void setProperty(String key, String value) {
        if (this.props == null) {
            this.props = new Properties();
        }
        if (value == null) {
            this.props.setProperty(key, "");
        } else {
            this.props.setProperty(key, value);
        }
    }

    public void setProperty(String key, boolean value) {
        this.setProperty(key, value ? "Y" : "N");
    }

    public void setProperty(String key, int value) {
        this.setProperty(key, String.valueOf(value));
    }

    public String getProperty(String key) {
        if (key == null) {
            return "";
        }
        String value = this.props.getProperty(key, "");
        if (value == null || value.length() == 0) {
            return "";
        }
        return value;
    }

    public boolean isPropertyBool(String key) {
        return this.getProperty(key).equals("Y");
    }
}

