/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.adempiere.util.Callback;
import org.adempiere.webui.AdempiereIdGenerator;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ComboItem;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.UserPreference;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.LoginWindow;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.model.SystemProperties;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.WebUtil;
import org.zkoss.util.Locales;
import org.zkoss.zhtml.Table;
import org.zkoss.zhtml.Td;
import org.zkoss.zhtml.Tr;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Deferrable;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Div;
import org.zkoss.zul.Image;

public class RolePanel
extends Window
implements EventListener<Event>,
Deferrable {
    private static final long serialVersionUID = -8077156023041816851L;
    protected LoginWindow wndLogin;
    protected Login login;
    protected Combobox lstRole;
    protected Combobox lstClient;
    protected Combobox lstOrganisation;
    protected Combobox lstWarehouse;
    protected Label lblRole;
    protected Label lblClient;
    protected Label lblDef;
    protected Label lblOrganisation;
    protected Label lblWarehouse;
    protected Label lblDate;
    protected Label lblLanguage;
    protected WDateEditor lstDate;
    protected Combobox lstLanguage;
    protected String validLstLanguage = null;
    protected ConfirmPanel pnlButtons;
    protected Properties m_ctx;
    protected String m_userName;
    protected KeyNamePair[] m_clientKNPairs;
    protected UserPreference m_userpreference = null;
    protected boolean m_showRolePanel = true;
    private RolePanel component;
    private boolean isChangeRole = false;
    private boolean m_isClientDefined;
    private Properties ctxBeforeChangeRole = null;
    private static final String ON_DEFER_LOGOUT = "onDeferLogout";

    public boolean isChangeRole() {
        return this.isChangeRole;
    }

    public void setChangeRole(boolean isChangeRole) {
        this.isChangeRole = isChangeRole;
    }

    public RolePanel(Properties ctx, LoginWindow loginWindow, String userName, boolean show, KeyNamePair[] clientsKNPairs, boolean isClientDefined) {
        this.wndLogin = loginWindow;
        this.m_ctx = ctx;
        this.m_userName = userName;
        this.login = new Login(ctx);
        this.m_showRolePanel = show;
        this.m_isClientDefined = isClientDefined;
        this.m_clientKNPairs = clientsKNPairs;
        this.m_userpreference = SessionManager.getSessionApplication().getUserPreference();
        if (this.m_clientKNPairs.length == 1 && !this.m_showRolePanel) {
            Env.setContext((Properties)this.m_ctx, (String)"#AD_Client_ID", (String)this.m_clientKNPairs[0].getID());
            MUser user = MUser.get((Properties)this.m_ctx, (String)Login.getAppUser((String)this.m_userName));
            this.m_userpreference.loadPreference(user.get_ID());
        } else {
            this.m_userpreference.loadPreference(-1);
        }
        this.initComponents();
        this.init();
        this.setId("rolePanel");
        this.setSclass("login-box");
        if (!(this.m_showRolePanel || this.lstRole.getSelectedItem() != null && this.lstRole.getSelectedItem().getValue() != null && this.lstClient.getSelectedItem() != null && this.lstClient.getSelectedItem().getValue() != null && this.lstOrganisation.getSelectedItem() != null && this.lstOrganisation.getSelectedItem().getValue() != null)) {
            this.m_showRolePanel = true;
        }
        if (this.m_showRolePanel) {
            AuFocus auf = null;
            auf = this.lstClient.getItemCount() > 1 ? new AuFocus((Component)this.lstClient) : (this.lstRole.getItemCount() > 1 ? new AuFocus((Component)this.lstRole) : new AuFocus((Component)this.lstOrganisation));
            Clients.response((AuResponse)auf);
        }
    }

    private void init() {
        Clients.response((AuResponse)new AuScript("zAu.cmd0.clearBusy()"));
        this.createUI();
    }

    protected void createUI() {
        Div div = new Div();
        div.setSclass("login-box-header");
        Label label = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"SelectRole"));
        label.setSclass("login-box-header-txt");
        div.appendChild((Component)label);
        this.appendChild((Component)div);
        Table table = new Table();
        table.setId("grdChooseRole");
        table.setDynamicProperty("cellpadding", (Object)"0");
        table.setDynamicProperty("cellspacing", (Object)"5");
        table.setSclass("login-box-body");
        this.appendChild((Component)table);
        Tr tr = new Tr();
        table.appendChild((Component)tr);
        Td td = new Td();
        td.setSclass("login-box-header-logo");
        tr.appendChild((Component)td);
        td.setDynamicProperty("colspan", (Object)"2");
        Image image = new Image();
        image.setSrc(ThemeManager.getLargeLogo());
        td.appendChild((Component)image);
        tr = new Tr();
        tr.setId("rowclient");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild(this.lblClient.rightAlign());
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.lstClient);
        tr = new Tr();
        tr.setId("rowRole");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild(this.lblRole.rightAlign());
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.lstRole);
        tr = new Tr();
        tr.setId("rowLabelDefault");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        div = new Div();
        div.setStyle("text-align: right; text-decoration: underline");
        div.appendChild((Component)this.lblDef);
        td.appendChild((Component)div);
        tr = new Tr();
        tr.setId("rowOrganisation");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild(this.lblOrganisation.rightAlign());
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.lstOrganisation);
        tr = new Tr();
        tr.setId("rowWarehouse");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild(this.lblWarehouse.rightAlign());
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.lstWarehouse);
        tr = new Tr();
        tr.setId("rowLanguage");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild(this.lblLanguage.rightAlign());
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.lstLanguage);
        tr = new Tr();
        tr.setId("rowDate");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild(this.lblDate.rightAlign());
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.lstDate.getComponent());
        div = new Div();
        div.setSclass("login-box-footer");
        this.pnlButtons = new ConfirmPanel(true, false, false, false, false, false, true);
        this.pnlButtons.addActionListener(this);
        Button okBtn = this.pnlButtons.getButton("Ok");
        okBtn.setWidgetListener("onClick", "zAu.cmd0.showBusy(null)");
        okBtn.addCallback("afterPageDetached", (org.zkoss.zk.ui.util.Callback & Serializable)t -> {
            String string = ((AbstractComponent)t).setWidgetListener("onClick", null);
        });
        Button helpButton = this.pnlButtons.createButton("Help");
        helpButton.addEventListener("onClick", this);
        helpButton.setSclass("login-btn");
        this.pnlButtons.addComponentsRight(helpButton);
        LayoutUtils.addSclass("login-box-footer-pnl", (HtmlBasedComponent)this.pnlButtons);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.pnlButtons, null);
        this.pnlButtons.getButton("Ok").setSclass("login-btn");
        this.pnlButtons.getButton("Cancel").setSclass("login-btn");
        div.appendChild((Component)this.pnlButtons);
        this.appendChild((Component)div);
        if (this.validLstLanguage != null) {
            this.languageChanged(this.validLstLanguage);
        }
    }

    private void initComponents() {
        String[] availableLanguages;
        Language language = Env.getLanguage((Properties)this.m_ctx);
        this.lblClient = new Label();
        this.lblClient.setId("lblClient");
        this.lblClient.setValue(Msg.getMsg((Language)language, (String)"Client"));
        this.lblRole = new Label();
        this.lblRole.setId("lblRole");
        this.lblRole.setValue(Msg.getMsg((Language)language, (String)"Role"));
        this.lblDef = new Label();
        this.lblDef.setId("lblDef");
        this.lblDef.setValue(Msg.getMsg((Language)language, (String)"Defaults"));
        this.lblOrganisation = new Label();
        this.lblOrganisation.setId("lblOrganisation");
        this.lblOrganisation.setValue(Msg.getMsg((Language)language, (String)"Organization"));
        this.lblWarehouse = new Label();
        this.lblWarehouse.setId("lblWarehouse");
        this.lblWarehouse.setValue(Msg.getMsg((Language)language, (String)"Warehouse"));
        this.lblLanguage = new Label();
        this.lblLanguage.setId("lblLanguage");
        this.lblLanguage.setValue("Language");
        this.lblDate = new Label();
        this.lblDate.setId("lblDate");
        this.lblDate.setValue(Msg.getMsg((Language)language, (String)"Date"));
        this.lstRole = new Combobox();
        this.lstRole.setAutocomplete(true);
        this.lstRole.setAutodrop(true);
        this.lstRole.setId("lstRole");
        this.lstRole.addEventListener("onSelect", this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.lstRole, "220px");
        this.lstClient = new Combobox();
        this.lstClient.setAutocomplete(true);
        this.lstClient.setAutodrop(true);
        this.lstClient.setId("lstClient");
        this.lstClient.addEventListener("onSelect", this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.lstClient, "220px");
        this.lstOrganisation = new Combobox();
        this.lstOrganisation.setAutocomplete(true);
        this.lstOrganisation.setAutodrop(true);
        this.lstOrganisation.setId("lstOrganisation");
        this.lstOrganisation.addEventListener("onSelect", this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.lstOrganisation, "220px");
        this.lstWarehouse = new Combobox();
        this.lstWarehouse.setAutocomplete(true);
        this.lstWarehouse.setAutodrop(true);
        this.lstWarehouse.setId("lstWarehouse");
        this.lstWarehouse.addEventListener("onSelect", this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.lstWarehouse, "220px");
        this.lstDate = new WDateEditor();
        this.lstDate.setValue(new Timestamp(System.currentTimeMillis()));
        this.lstDate.getComponent().setId("loginDate");
        UserPreference userPreference = SessionManager.getSessionApplication().getUserPreference();
        String initDefault = userPreference.getProperty("Client");
        if (initDefault.length() == 0 && !this.m_showRolePanel && this.m_userpreference != null) {
            initDefault = this.m_userpreference.getProperty("Client");
        }
        if (this.m_clientKNPairs != null && this.m_clientKNPairs.length > 0) {
            int i = 0;
            while (i < this.m_clientKNPairs.length) {
                String id;
                ComboItem ci = new ComboItem(this.m_clientKNPairs[i].getName(), this.m_clientKNPairs[i].getID());
                if (SystemProperties.isZkUnitTest() && this.lstClient.getFellowIfAny(id = AdempiereIdGenerator.escapeId(ci.getLabel())) == null) {
                    ci.setId(id);
                }
                this.lstClient.appendChild((Component)ci);
                if (this.m_clientKNPairs[i].getID().equals(initDefault)) {
                    this.lstClient.setSelectedItem(ci);
                }
                ++i;
            }
            if (this.lstClient.getSelectedIndex() == -1 && this.lstClient.getItemCount() > 0) {
                this.m_showRolePanel = true;
                this.lstClient.setSelectedIndex(0);
            }
        }
        if (this.m_clientKNPairs != null && this.m_clientKNPairs.length == 1) {
            this.lstClient.setSelectedIndex(0);
            this.lstClient.setEnabled(false);
        } else {
            this.lstClient.setEnabled(true);
        }
        if (!MSysConfig.getBooleanValue((String)"ALogin_ShowDate", (boolean)true)) {
            this.lstDate.setReadWrite(false);
        }
        this.lstLanguage = new Combobox();
        this.lstLanguage.setAutocomplete(true);
        this.lstLanguage.setAutodrop(true);
        this.lstLanguage.setId("lstLanguage");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.lstLanguage, "220px");
        this.lstLanguage.getItems().clear();
        ArrayList supported = Env.getLoginLanguages();
        String[] stringArray = availableLanguages = Language.getNames();
        int n = availableLanguages.length;
        int n2 = 0;
        while (n2 < n) {
            String langName = stringArray[n2];
            Language lang = Language.getLanguage((String)langName);
            if (supported.contains(lang.getAD_Language())) {
                this.lstLanguage.appendItem(langName, lang.getAD_Language());
            }
            ++n2;
        }
        if (language != null) {
            this.validLstLanguage = language.getName();
            this.lstLanguage.setValue(this.validLstLanguage);
        } else if (this.lstLanguage.getItems().size() > 0) {
            this.validLstLanguage = ((Comboitem)this.lstLanguage.getItems().get(0)).getLabel();
            this.lstLanguage.setValue(this.validLstLanguage);
        }
        this.lstLanguage.addEventListener("onSelect", this);
        this.setUserID();
        this.updateRoleList();
        this.component = this;
        this.component.addEventListener(ON_DEFER_LOGOUT, this);
    }

    private void updateRoleList() {
        this.lstRole.getItems().clear();
        this.lstRole.setText("");
        this.setUserID();
        UserPreference userPreference = SessionManager.getSessionApplication().getUserPreference();
        Comboitem lstItemClient = this.lstClient.getSelectedItem();
        if (lstItemClient != null) {
            int clientId;
            KeyNamePair clientKNPair;
            KeyNamePair[] roleKNPairs;
            userPreference.loadPreference(Env.getContextAsInt((Properties)this.m_ctx, (String)"#AD_User_ID"));
            String initDefault = userPreference.getProperty("Role");
            if (initDefault.length() == 0 && !this.m_showRolePanel && this.m_userpreference != null) {
                initDefault = this.m_userpreference.getProperty("Role");
            }
            if ((roleKNPairs = this.login.getRoles(this.m_userName, clientKNPair = new KeyNamePair(clientId = Integer.valueOf((String)lstItemClient.getValue()).intValue(), lstItemClient.getLabel()), "NULL,ZK,SS")) != null && roleKNPairs.length > 0) {
                int i = 0;
                while (i < roleKNPairs.length) {
                    String id;
                    ComboItem ci = new ComboItem(roleKNPairs[i].getName(), roleKNPairs[i].getID());
                    if (SystemProperties.isZkUnitTest() && this.lstRole.getFellowIfAny(id = AdempiereIdGenerator.escapeId(ci.getLabel())) == null) {
                        ci.setId(id);
                    }
                    this.lstRole.appendChild((Component)ci);
                    if (roleKNPairs[i].getID().equals(initDefault)) {
                        this.lstRole.setSelectedItem(ci);
                    }
                    ++i;
                }
                if (this.lstRole.getSelectedIndex() == -1 && this.lstRole.getItemCount() > 0) {
                    this.m_showRolePanel = true;
                    this.lstRole.setSelectedIndex(0);
                }
            }
            if (this.lstRole.getItemCount() == 1) {
                this.lstRole.setSelectedIndex(0);
                this.lstRole.setEnabled(false);
            } else {
                this.lstRole.setEnabled(true);
            }
        }
        this.updateOrganisationList();
        this.updateLanguage();
        if (this.lstClient.getChildren().size() > 1) {
            userPreference.loadPreference(Env.getContextAsInt((Properties)this.m_ctx, (String)"#AD_User_ID"));
            Comboitem lstItemRole = this.lstRole.getSelectedItem();
            Comboitem lstItemOrg = this.lstOrganisation.getSelectedItem();
            Comboitem lstItemWarehouse = this.lstWarehouse.getSelectedItem();
            Comboitem lstItemLanguage = this.lstLanguage.getSelectedItem();
            if (lstItemLanguage != null && lstItemLanguage.getValue() != null) {
                userPreference.setProperty("Language", (String)lstItemLanguage.getValue());
            } else {
                userPreference.setProperty("Language", Env.getContext((Properties)this.m_ctx, (String)"#LanguageName"));
            }
            if (lstItemRole != null && lstItemRole.getValue() != null) {
                userPreference.setProperty("Role", (String)lstItemRole.getValue());
            }
            if (lstItemClient != null && lstItemClient.getValue() != null) {
                userPreference.setProperty("Client", (String)lstItemClient.getValue());
            }
            if (lstItemOrg != null && lstItemOrg.getValue() != null) {
                userPreference.setProperty("Organization", (String)lstItemOrg.getValue());
            }
            if (lstItemWarehouse != null && lstItemWarehouse.getValue() != null) {
                userPreference.setProperty("Warehouse", (String)lstItemWarehouse.getValue());
            }
            userPreference.savePreference();
        }
    }

    private void updateLanguage() {
        UserPreference userPreference = SessionManager.getSessionApplication().getUserPreference();
        String initDefault = userPreference.getProperty("Language");
        int i = 0;
        while (i < this.lstLanguage.getItemCount()) {
            Comboitem li = this.lstLanguage.getItemAtIndex(i);
            if (li.getLabel().equals(initDefault)) {
                this.lstLanguage.setSelectedIndex(i);
                this.languageChanged(li.getLabel());
                break;
            }
            ++i;
        }
        if (this.lstLanguage.getItemCount() == 1) {
            this.lstLanguage.setSelectedIndex(0);
            this.lstLanguage.setEnabled(false);
        } else {
            this.lstLanguage.setEnabled(true);
        }
    }

    private void languageChanged(String langName) {
        Language language = this.findLanguage(langName);
        this.lblClient.setValue(Msg.getMsg((Language)language, (String)"Client"));
        this.lblRole.setValue(Msg.getMsg((Language)language, (String)"Role"));
        this.lblDef.setValue(Msg.getMsg((Language)language, (String)"Defaults"));
        this.lblOrganisation.setValue(Msg.getMsg((Language)language, (String)"Organization"));
        this.lblWarehouse.setValue(Msg.getMsg((Language)language, (String)"Warehouse"));
        this.lblLanguage.setValue(Msg.getMsg((Language)language, (String)"Language"));
        this.lblDate.setValue(Msg.getMsg((Language)language, (String)"Date"));
        if (this.pnlButtons != null) {
            this.pnlButtons.getButton("Ok").setLabel(Util.cleanAmp((String)Msg.getMsg((Language)language, (String)"Ok")));
            this.pnlButtons.getButton("Help").setLabel(Util.cleanAmp((String)Msg.getMsg((Language)language, (String)"Help")));
            this.pnlButtons.getButton("Cancel").setLabel(Util.cleanAmp((String)Msg.getMsg((Language)language, (String)"Cancel")));
        }
    }

    private Language findLanguage(String langName) {
        Language tmp = Language.getLanguage((String)langName);
        Language language = new Language(tmp.getName(), tmp.getAD_Language(), tmp.getLocale(), Boolean.valueOf(tmp.isDecimalPoint()), tmp.getDateFormat().toPattern(), tmp.getMediaSize());
        Env.verifyLanguage((Properties)this.m_ctx, (Language)language);
        Env.setContext((Properties)this.m_ctx, (String)"#AD_Language", (String)language.getAD_Language());
        Env.setContext((Properties)this.m_ctx, (String)"#Locale", (String)language.getLocale().toString());
        Locale locale = language.getLocale();
        try {
            Clients.reloadMessages((Locale)locale);
        }
        catch (IOException e) {
            Dialog.warn(0, e.getLocalizedMessage(), e.getMessage());
        }
        Locales.setThreadLocal((Locale)locale);
        return language;
    }

    private void updateOrganisationList() {
        this.lstOrganisation.getItems().clear();
        this.lstOrganisation.setText("");
        Comboitem lstItemRole = this.lstRole.getSelectedItem();
        if (lstItemRole != null) {
            KeyNamePair RoleKNPair;
            KeyNamePair[] orgKNPairs;
            UserPreference userPreference = SessionManager.getSessionApplication().getUserPreference();
            String initDefault = userPreference.getProperty("Organization");
            if (initDefault.length() == 0 && !this.m_showRolePanel && this.m_userpreference != null) {
                initDefault = this.m_userpreference.getProperty("Organization");
            }
            if ((orgKNPairs = this.login.getOrgs(RoleKNPair = new KeyNamePair(Integer.valueOf((String)lstItemRole.getValue()).intValue(), lstItemRole.getLabel()))) != null && orgKNPairs.length > 0) {
                int i = 0;
                while (i < orgKNPairs.length) {
                    String id;
                    ComboItem ci = new ComboItem(orgKNPairs[i].getName(), orgKNPairs[i].getID());
                    if (SystemProperties.isZkUnitTest() && this.lstOrganisation.getFellowIfAny(id = AdempiereIdGenerator.escapeId(ci.getLabel())) == null) {
                        ci.setId(id);
                    }
                    this.lstOrganisation.appendChild((Component)ci);
                    if (orgKNPairs[i].getID().equals(initDefault)) {
                        this.lstOrganisation.setSelectedItem(ci);
                    }
                    ++i;
                }
                if (this.lstOrganisation.getSelectedIndex() == -1 && this.lstOrganisation.getItemCount() > 0) {
                    this.m_showRolePanel = true;
                    this.lstOrganisation.setSelectedIndex(0);
                }
            }
            if (this.lstOrganisation.getItemCount() == 1) {
                this.lstOrganisation.setSelectedIndex(0);
                this.lstOrganisation.setEnabled(false);
            } else {
                this.lstOrganisation.setEnabled(true);
            }
        }
        this.updateWarehouseList();
    }

    private void updateWarehouseList() {
        this.lstWarehouse.getItems().clear();
        this.lstWarehouse.setText("");
        Comboitem lstItemOrganisation = this.lstOrganisation.getSelectedItem();
        if (lstItemOrganisation != null) {
            KeyNamePair organisationKNPair;
            KeyNamePair[] warehouseKNPairs;
            UserPreference userPreference = SessionManager.getSessionApplication().getUserPreference();
            String initDefault = userPreference.getProperty("Warehouse");
            if (initDefault.length() == 0 && !this.m_showRolePanel && this.m_userpreference != null) {
                initDefault = this.m_userpreference.getProperty("Warehouse");
            }
            if ((warehouseKNPairs = this.login.getWarehouses(organisationKNPair = new KeyNamePair(Integer.valueOf((String)lstItemOrganisation.getValue()).intValue(), lstItemOrganisation.getLabel()))) != null && warehouseKNPairs.length > 0) {
                int i = 0;
                while (i < warehouseKNPairs.length) {
                    ComboItem ci = new ComboItem(warehouseKNPairs[i].getName(), warehouseKNPairs[i].getID());
                    ci.setLabel(ci.getLabel());
                    this.lstWarehouse.appendChild((Component)ci);
                    if (warehouseKNPairs[i].getID().equals(initDefault)) {
                        this.lstWarehouse.setSelectedItem(ci);
                    }
                    ++i;
                }
                if (this.lstWarehouse.getSelectedIndex() == -1 && this.lstWarehouse.getItemCount() > 0) {
                    this.lstWarehouse.setSelectedIndex(0);
                }
            }
        }
    }

    public void onEvent(Event event) {
        String eventCompId = event.getTarget().getId();
        String eventName = event.getName();
        if (eventName.equals("onSelect")) {
            if (eventCompId.equals(this.lstClient.getId())) {
                this.checkMandatoryField(this.lstClient, this.lblClient);
                this.updateRoleList();
            } else if (eventCompId.equals(this.lstRole.getId())) {
                this.checkMandatoryField(this.lstRole, this.lblRole);
                this.setUserID();
                this.updateOrganisationList();
            } else if (eventCompId.equals(this.lstOrganisation.getId())) {
                this.checkMandatoryField(this.lstOrganisation, this.lblOrganisation);
                this.updateWarehouseList();
            } else if (eventCompId.equals(this.lstLanguage.getId())) {
                if (this.lstLanguage.getSelectedItem() == null) {
                    this.lstLanguage.setValue(this.validLstLanguage);
                } else {
                    this.validLstLanguage = this.lstLanguage.getSelectedItem().getLabel();
                }
                this.languageChanged(this.validLstLanguage);
            }
        }
        if (event.getTarget().getId().equals("Ok")) {
            this.validateRoles(false);
        } else if (event.getTarget().getId().equals("Help")) {
            this.openLoginHelp();
        } else if (event.getTarget().getId().equals("Cancel")) {
            if (this.isChangeRole()) {
                this.changeRole(this.ctxBeforeChangeRole);
                this.validateRoles(false);
            } else {
                this.ctxBeforeChangeRole = null;
                SessionManager.logoutSession();
            }
        } else if (ON_DEFER_LOGOUT.equals(event.getName())) {
            SessionManager.logoutSession();
        }
    }

    private void openLoginHelp() {
        String lang = Env.getContext((Properties)Env.getCtx(), (String)"#AD_Language");
        lang = lang.substring(0, 2);
        String helpURL = MSysConfig.getValue((String)"LOGIN_SELECT_ROLE_HELP_URL", (String)"https://wiki.idempiere.org/{lang}/Login_Select_Role_Help");
        if (helpURL.contains("{lang}")) {
            String rawURL = helpURL;
            helpURL = Util.replace((String)rawURL, (String)"{lang}", (String)lang);
            if (!"en".equals(lang) && !WebUtil.isUrlOk((String)helpURL)) {
                helpURL = Util.replace((String)rawURL, (String)"{lang}", (String)"en");
            }
        }
        try {
            Executions.getCurrent().sendRedirect(helpURL, "_blank");
        }
        catch (Exception e) {
            String message = e.getMessage();
            Dialog.warn(0, "URLnotValid", message);
        }
    }

    private void setUserID() {
        if (this.lstClient.getSelectedItem() != null) {
            Env.setContext((Properties)this.m_ctx, (String)"#AD_Client_ID", (String)((String)this.lstClient.getSelectedItem().getValue()));
        } else {
            Env.setContext((Properties)this.m_ctx, (String)"#AD_Client_ID", null);
        }
        MUser user = MUser.get((Properties)this.m_ctx, (String)Login.getAppUser((String)this.m_userName));
        if (user != null) {
            Env.setContext((Properties)this.m_ctx, (String)"#AD_User_ID", (int)user.getAD_User_ID());
            Env.setContext((Properties)this.m_ctx, (String)"#AD_User_Name", (String)user.getName());
            Env.setContext((Properties)this.m_ctx, (String)"#SalesRep_ID", (int)user.getAD_User_ID());
        }
    }

    public void changeRole(Properties ctx) {
        this.ctxBeforeChangeRole = new Properties();
        this.ctxBeforeChangeRole.putAll((Map<?, ?>)ctx);
        int AD_Client_ID = Env.getAD_Client_ID((Properties)ctx);
        this.lstClient.setValue(AD_Client_ID);
        this.updateRoleList();
        int AD_Role_ID = Env.getAD_Role_ID((Properties)ctx);
        this.lstRole.setValue(AD_Role_ID);
        this.updateOrganisationList();
        int AD_Org_ID = Env.getContextAsInt((Properties)ctx, (String)"#AD_Org_ID_ChangeRole");
        this.lstOrganisation.setValue(AD_Org_ID);
        this.updateWarehouseList();
        int M_Warehouse_ID = Env.getContextAsInt((Properties)ctx, (String)"#M_Warehouse_ID");
        this.lstWarehouse.setValue(M_Warehouse_ID);
    }

    public void validateRoles(boolean isMFAValidated) {
        Timestamp date;
        String msg;
        Clients.clearBusy();
        Comboitem lstItemRole = this.lstRole.getSelectedItem();
        Comboitem lstItemClient = this.lstClient.getSelectedItem();
        Comboitem lstItemOrg = this.lstOrganisation.getSelectedItem();
        Comboitem lstItemWarehouse = this.lstWarehouse.getSelectedItem();
        Comboitem lstItemLanguage = this.lstLanguage.getSelectedItem();
        this.checkMandatoryField(this.lstClient, this.lblClient);
        this.checkMandatoryField(this.lstRole, this.lblRole);
        this.checkMandatoryField(this.lstOrganisation, this.lblOrganisation);
        int orgId = 0;
        int warehouseId = 0;
        orgId = Integer.parseInt((String)lstItemOrg.getValue());
        KeyNamePair orgKNPair = new KeyNamePair(orgId, lstItemOrg.getLabel());
        KeyNamePair warehouseKNPair = null;
        if (lstItemWarehouse != null && lstItemWarehouse.getValue() != null) {
            warehouseId = Integer.parseInt((String)lstItemWarehouse.getValue());
            warehouseKNPair = new KeyNamePair(warehouseId, lstItemWarehouse.getLabel());
        }
        if (!Util.isEmpty((String)(msg = this.login.loadPreferences(orgKNPair, warehouseKNPair, date = this.lstDate.getValue(), null)))) {
            Env.getCtx().clear();
            Dialog.error(0, "Error", msg, new Callback<Integer>(){

                public void onCallback(Integer result) {
                    Events.echoEvent((Event)new Event(RolePanel.ON_DEFER_LOGOUT, (Component)RolePanel.this.component));
                }
            });
            return;
        }
        UserPreference userPreference = SessionManager.getSessionApplication().getUserPreference();
        if (lstItemLanguage != null && lstItemLanguage.getValue() != null) {
            userPreference.setProperty("Language", (String)lstItemLanguage.getValue());
        } else {
            userPreference.setProperty("Language", Env.getContext((Properties)this.m_ctx, (String)"#LanguageName"));
        }
        userPreference.setProperty("Role", (String)lstItemRole.getValue());
        userPreference.setProperty("Client", (String)lstItemClient.getValue());
        userPreference.setProperty("Organization", (String)lstItemOrg.getValue());
        userPreference.setProperty("Warehouse", lstItemWarehouse != null ? (String)lstItemWarehouse.getValue() : "0");
        userPreference.savePreference();
        if (this.lstClient.getChildren().size() > 1) {
            MRole.getDefault((Properties)this.m_ctx, (boolean)true);
        }
        String langName = null;
        langName = this.lstLanguage.getSelectedItem() != null ? this.lstLanguage.getSelectedItem().getLabel() : Language.getBaseLanguage().getName();
        Language language = this.findLanguage(langName);
        Env.setContext((Properties)this.m_ctx, (String)"#LanguageName", (String)language.getName());
        Locale locale = language.getLocale();
        Desktop desktop = Executions.getCurrent().getDesktop();
        desktop.getSession().setAttribute("org.zkoss.web.preferred.locale", (Object)locale);
        try {
            Clients.reloadMessages((Locale)locale);
        }
        catch (IOException e) {
            Dialog.warn(0, e.getLocalizedMessage(), e.getMessage());
        }
        Locales.setThreadLocal((Locale)locale);
        if (this.m_isClientDefined || isMFAValidated) {
            this.wndLogin.loginCompleted(this.login, orgKNPair, this);
        } else {
            this.wndLogin.validateMFA(orgKNPair, this.m_isClientDefined, this.m_userName, this.m_showRolePanel, this.m_clientKNPairs);
        }
        desktop.getSession().setAttribute("ISCHANGEROLE_REQUEST", (Object)false);
    }

    private void checkMandatoryField(Combobox lst, Label lbl) {
        Comboitem item = lst.getSelectedItem();
        if (item == null || item.getValue() == null) {
            throw new WrongValueException((Component)lst, Msg.getMsg((Properties)this.m_ctx, (String)"FillMandatory") + lbl.getValue());
        }
    }

    public boolean isDeferrable() {
        return false;
    }

    public boolean show() {
        return this.m_showRolePanel;
    }
}

