/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Datebox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.NumberBox;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Timebox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.InfoSchedule;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUOMConversion;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Div;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Window;

public class WAssignmentDialog
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -1762339564864115852L;
    private boolean isUseEscForTabClosing = MSysConfig.getBooleanValue((String)"USE_ESC_FOR_TAB_CLOSING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    private MResourceAssignment m_mAssignment;
    private boolean m_setting = false;
    private static final CLogger log = CLogger.getCLogger(WAssignmentDialog.class);
    private HashMap<KeyNamePair, KeyNamePair> m_lookup = new HashMap();
    private Grid mainPanel = new Grid();
    private Label lResource = new Label(Msg.translate((Properties)Env.getCtx(), (String)"S_Resource_ID"));
    private Listbox fResource = new Listbox(this.getResources());
    private Label lDate = new Label(Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
    private Datebox fDateFrom = new Datebox();
    private Timebox fTimeFrom = new Timebox();
    private Label lQty = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Qty"));
    private NumberBox fQty = new NumberBox(false);
    private Label lUOM = new Label();
    private Label lName = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Name"));
    private Label lDescription = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
    private Textbox fName = new Textbox();
    private Textbox fDescription = new Textbox();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true, false, false, false, false, true);
    private Button delete = this.confirmPanel.createButton("Delete");
    private boolean m_cancel = true;
    private boolean m_zoom;

    public WAssignmentDialog(MResourceAssignment mAssignment, boolean allowZoom, boolean allowDelete) {
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"VAssignmentDialog"));
        this.setBorder("normal");
        this.setAttribute("mode", "highlighted");
        if (log.isLoggable(Level.CONFIG)) {
            log.config(mAssignment.toString());
        }
        this.m_mAssignment = mAssignment;
        try {
            this.init();
            if (!allowZoom) {
                this.confirmPanel.getButton("Zoom").setVisible(false);
            }
            this.delete.setVisible(allowDelete);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
        this.setDisplay();
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 600);
        }
        this.setSizable(true);
        this.setMaximizable(true);
        this.setSclass("assignment-dialog");
    }

    private void init() throws Exception {
        this.fResource.setMold("select");
        this.fResource.addEventListener("onSelect", this);
        this.delete.addEventListener("onClick", this);
        this.confirmPanel.addComponentsLeft(this.delete);
        this.confirmPanel.addActionListener("onClick", this);
        this.appendChild((Component)this.mainPanel);
        this.mainPanel.makeNoStrip();
        this.mainPanel.setStyle("background-color: transparent");
        Rows rows = new Rows();
        this.mainPanel.appendChild((Component)rows);
        Row row = new Row();
        row.appendChild(LayoutUtils.makeRightAlign(this.lResource));
        row.appendChild((Component)this.fResource);
        row.appendChild((Component)new Label(" "));
        rows.appendChild((Component)row);
        row = new Row();
        row.appendCellChild(LayoutUtils.makeRightAlign(this.lDate), 1);
        Div div = new Div();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)div, "1");
        div.appendChild((Component)this.fDateFrom);
        this.fDateFrom.setCols(10);
        div.appendChild((Component)this.fTimeFrom);
        this.fTimeFrom.setCols(10);
        this.fTimeFrom.setStyle("margin-left: 1px");
        row.appendCellChild((Component)div, 2);
        rows.appendChild((Component)row);
        row = new Row();
        row.appendChild(LayoutUtils.makeRightAlign(this.lQty));
        row.appendChild((Component)this.fQty);
        row.appendChild((Component)this.lUOM);
        rows.appendChild((Component)row);
        row = new Row();
        row.appendCellChild(LayoutUtils.makeRightAlign(this.lName), 1);
        row.appendCellChild((Component)this.fName, 2);
        this.fName.setStyle("width: 100%");
        rows.appendChild((Component)row);
        row = new Row();
        row.appendCellChild(LayoutUtils.makeRightAlign(this.lDescription), 1);
        row.appendCellChild((Component)this.fDescription, 2);
        this.fDescription.setMultiline(true);
        this.fDescription.setRows(3);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fDescription, "100%");
        rows.appendChild((Component)row);
        row = new Row();
        row.appendCellChild((Component)new Label(" "), 3);
        rows.appendChild((Component)row);
        row = new Row();
        row.appendCellChild((Component)this.confirmPanel, 3);
        rows.appendChild((Component)row);
        this.addEventListener("onCancel", e -> this.onCancel());
    }

    private void setDisplay() {
        this.m_setting = true;
        int S_Resource_ID = this.m_mAssignment.getS_Resource_ID();
        for (Listitem item : this.fResource.getItems()) {
            if ((Integer)item.getValue() != S_Resource_ID) continue;
            this.fResource.setSelectedItem(item);
            break;
        }
        ListItem listItem = this.fResource.getSelectedItem();
        KeyNamePair check = new KeyNamePair(((Integer)listItem.getValue()).intValue(), listItem.getLabel());
        if (check == null || check.getKey() != S_Resource_ID) {
            if (this.m_mAssignment.getS_ResourceAssignment_ID() == 0) {
                this.fResource.setSelectedItem(this.fResource.getSelectedItem());
            } else {
                log.log(Level.SEVERE, "Resource not found ID=" + S_Resource_ID);
            }
        }
        this.fDateFrom.setValue(this.m_mAssignment.getAssignDateFrom());
        this.fTimeFrom.setValue(this.m_mAssignment.getAssignDateFrom());
        this.fQty.setValue(this.m_mAssignment.getQty());
        this.fName.setValue(this.m_mAssignment.getName());
        this.fDescription.setValue(this.m_mAssignment.getDescription());
        boolean readWrite = true;
        if (this.m_mAssignment.isConfirmed()) {
            readWrite = false;
        }
        this.confirmPanel.getButton("Cancel").setVisible(readWrite);
        this.fResource.setEnabled(readWrite);
        this.fDateFrom.setReadonly(!readWrite);
        this.fQty.setEnabled(readWrite);
        this.m_setting = false;
    }

    public MResourceAssignment getMResourceAssignment() {
        return this.m_mAssignment;
    }

    private boolean cmd_save() {
        GregorianCalendar date = new GregorianCalendar();
        this.getDateAndTimeFrom(date);
        Timestamp assignDateFrom = new Timestamp(date.getTimeInMillis());
        BigDecimal qty = this.fQty.getValue();
        ListItem listItem = this.fResource.getSelectedItem();
        KeyNamePair resource = listItem != null ? new KeyNamePair(((Integer)listItem.getValue()).intValue(), listItem.getLabel()) : null;
        KeyNamePair uom = this.m_lookup.get(resource);
        int minutes = MUOMConversion.convertToMinutes((Properties)Env.getCtx(), (int)uom.getKey(), (BigDecimal)qty);
        Timestamp assignDateTo = TimeUtil.addMinutess((Timestamp)assignDateFrom, (int)minutes);
        this.m_mAssignment.setAssignDateTo(assignDateTo);
        return this.m_mAssignment.save();
    }

    private KeyNamePair[] getResources() {
        block8: {
            if (this.m_lookup.size() == 0) {
                String sql = MRole.getDefault().addAccessSQL("SELECT r.S_Resource_ID, r.Name, r.IsActive,uom.C_UOM_ID,uom.UOMSymbol FROM S_Resource r, S_ResourceType rt, C_UOM uom WHERE r.S_ResourceType_ID=rt.S_ResourceType_ID AND rt.C_UOM_ID=uom.C_UOM_ID", "r", true, false);
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, null);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            StringBuilder sb = new StringBuilder(rs.getString(2));
                            if (!"Y".equals(rs.getString(3))) {
                                sb.insert(0, '~').append('~');
                            }
                            KeyNamePair key = new KeyNamePair(rs.getInt(1), sb.toString());
                            KeyNamePair value = new KeyNamePair(rs.getInt(4), rs.getString(5).trim());
                            this.m_lookup.put(key, value);
                        }
                    }
                    catch (SQLException e) {
                        log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                Object var2_2 = null;
            }
        }
        Object[] retValue = new KeyNamePair[this.m_lookup.size()];
        this.m_lookup.keySet().toArray(retValue);
        Arrays.sort(retValue);
        return retValue;
    }

    public void onEvent(Event e) throws Exception {
        KeyNamePair resource;
        if (this.m_setting) {
            return;
        }
        ListItem listItem = this.fResource.getSelectedItem();
        KeyNamePair keyNamePair = resource = listItem != null ? new KeyNamePair(((Integer)listItem.getValue()).intValue(), listItem.getLabel()) : null;
        if (resource != null) {
            int S_Resource_ID = resource.getKey();
            this.m_mAssignment.setS_Resource_ID(S_Resource_ID);
        }
        GregorianCalendar date = new GregorianCalendar();
        this.getDateAndTimeFrom(date);
        Timestamp assignDateFrom = new Timestamp(date.getTimeInMillis());
        if (assignDateFrom != null) {
            this.m_mAssignment.setAssignDateFrom(assignDateFrom);
        }
        if (this.fQty.getValue() != null) {
            BigDecimal qty = this.fQty.getValue();
            this.m_mAssignment.setQty(qty);
        }
        this.m_mAssignment.setName(this.fName.getValue());
        this.m_mAssignment.setDescription(this.fDescription.getValue());
        if (e.getTarget() == this.fResource) {
            KeyNamePair o = this.m_lookup.get(resource);
            if (o == null) {
                this.lUOM.setValue(" ? ");
            } else {
                this.lUOM.setValue(o.toString());
            }
        } else if (e.getTarget().getId().equals("Zoom")) {
            this.m_zoom = true;
            this.setVisible(false);
            Events.echoEvent((String)"onShowSchedule", (Component)this, null);
        } else if (e.getTarget().getId().equals("Cancel")) {
            this.onCancel();
        } else if (e.getTarget().getId().equals("Delete")) {
            if (this.m_mAssignment.delete(true)) {
                this.m_mAssignment = null;
                this.detach();
            } else {
                Dialog.error(0, "ResourceAssignmentNotDeleted");
            }
        } else if (e.getTarget().getId().equals("Ok")) {
            this.m_cancel = false;
            if (this.cmd_save()) {
                this.detach();
            }
        }
    }

    private void onCancel() {
        if (this.isUseEscForTabClosing) {
            SessionManager.getAppDesktop().setCloseTabWithShortcut(false);
        }
        this.m_cancel = true;
        this.detach();
    }

    public void onShowSchedule() {
        InfoSchedule is = new InfoSchedule(this.m_mAssignment, true, (Component)this, new Callback<MResourceAssignment>(){

            public void onCallback(MResourceAssignment result) {
                WAssignmentDialog.this.m_zoom = false;
                if (result != null) {
                    WAssignmentDialog.this.m_mAssignment = result;
                    WAssignmentDialog.this.setDisplay();
                }
                WAssignmentDialog.this.setVisible(true);
                WAssignmentDialog.this.focus();
            }
        });
        AEnv.showWindow(is);
        is.focus();
    }

    private void getDateAndTimeFrom(Calendar date) {
        Date dateFrom = this.fDateFrom.getValue();
        Date timeFrom = this.fTimeFrom.getValue();
        date.setTime(dateFrom);
        GregorianCalendar time = new GregorianCalendar();
        time.setTime(timeFrom);
        date.set(11, time.get(11));
        date.set(12, time.get(12));
    }

    public boolean isCancelled() {
        return this.m_cancel;
    }

    public Datebox getDateFrom() {
        return this.fDateFrom;
    }

    public boolean setVisible(boolean visible) {
        boolean b = super.setVisible(visible);
        if (!this.m_zoom && b && !visible && this.getModeType() == Window.Mode.POPUP) {
            this.detach();
        }
        return b;
    }
}

