/*
 * Decompiled with CFR 0.152.
 */
package fi.jawsy.jawwa.zk.atmosphere;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Library;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuEcho;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.impl.ExecutionCarryOver;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.Scheduler;
import org.zkoss.zk.ui.sys.ServerPush;
import org.zkoss.zk.ui.util.Clients;

public class AtmosphereServerPush
implements ServerPush {
    private static final String ATMOSPHERE_SERVER_PUSH_ECHO = "AtmosphereServerPush.Echo";
    private static final String ON_ACTIVATE_DESKTOP = "onActivateDesktop";
    public static final int DEFAULT_TIMEOUT = 120000;
    private final AtomicReference<Desktop> desktop = new AtomicReference();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<AtmosphereResource> resource = new AtomicReference();
    private final int timeout;
    private ThreadInfo _active;
    private ExecutionCarryOver _carryOver;
    private final Object _mutex = new Object();
    private List<Schedule<Event>> schedules = new ArrayList<Schedule<Event>>();

    public AtmosphereServerPush() {
        String timeoutString = Library.getProperty((String)"fi.jawsy.jawwa.zk.atmosphere.timeout");
        this.timeout = timeoutString == null || timeoutString.trim().length() == 0 ? 120000 : Integer.valueOf(timeoutString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activate(long timeout) throws InterruptedException, DesktopUnavailableException {
        Thread curr = Thread.currentThread();
        if (this._active != null && this._active.thread.equals(curr)) {
            ++this._active.nActive;
            return true;
        }
        final ThreadInfo info = new ThreadInfo(curr);
        EventListener<Event> task = new EventListener<Event>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onEvent(Event event) throws Exception {
                if (event.getName().equals(AtmosphereServerPush.ON_ACTIVATE_DESKTOP)) {
                    Object object = AtmosphereServerPush.this._mutex;
                    synchronized (object) {
                        AtmosphereServerPush.this._carryOver = new ExecutionCarryOver(AtmosphereServerPush.this.desktop.get());
                        ThreadInfo threadInfo = info;
                        synchronized (threadInfo) {
                            info.nActive = 1;
                            info.notifyAll();
                        }
                        try {
                            AtmosphereServerPush.this._mutex.wait();
                        }
                        catch (InterruptedException ex) {
                            throw UiException.Aide.wrap((Throwable)ex);
                        }
                    }
                }
            }
        };
        ThreadInfo threadInfo = info;
        synchronized (threadInfo) {
            Executions.schedule((Desktop)this.desktop.get(), (EventListener)task, (Event)new Event(ON_ACTIVATE_DESKTOP));
            if (info.nActive == 0) {
                info.wait(timeout <= 0L ? 600000L : timeout);
            }
        }
        this._carryOver.carryOver();
        this._active = info;
        return true;
    }

    public void clearResource(AtmosphereResource resource) {
        this.resource.compareAndSet(resource, null);
    }

    private boolean commitResponse() throws IOException {
        AtmosphereResource resource = this.resource.getAndSet(null);
        if (resource != null) {
            resource.resume();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deactivate(boolean stop) {
        boolean stopped = false;
        if (this._active != null && Thread.currentThread().equals(this._active.thread) && --this._active.nActive <= 0) {
            if (stop) {
                this.stop();
                stopped = true;
            }
            this._carryOver.cleanup();
            this._carryOver = null;
            this._active.nActive = 0;
            this._active = null;
            Object object = this._mutex;
            synchronized (object) {
                this._mutex.notifyAll();
            }
        }
        return stopped;
    }

    public boolean isActive() {
        return this._active != null && this._active.nActive > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPiggyback() {
        if (Executions.getCurrent() != null && Executions.getCurrent().getAttribute(ATMOSPHERE_SERVER_PUSH_ECHO) != null) {
            return;
        }
        Schedule[] pendings = null;
        List<Schedule<Event>> list = this.schedules;
        synchronized (list) {
            if (!this.schedules.isEmpty()) {
                pendings = this.schedules.toArray(new Schedule[0]);
                this.schedules = new ArrayList<Schedule<Event>>();
            }
        }
        if (pendings != null && pendings.length > 0) {
            Schedule[] scheduleArray = pendings;
            int n = pendings.length;
            int n2 = 0;
            while (n2 < n) {
                Schedule p = scheduleArray[n2];
                p.scheduler.schedule(p.task, p.event);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Event> void schedule(EventListener<T> task, T event, Scheduler<T> scheduler) {
        if (Executions.getCurrent() == null) {
            scheduler.schedule(task, event);
            try {
                this.commitResponse();
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            List<Schedule<Event>> list = this.schedules;
            synchronized (list) {
                this.schedules.add(new Schedule(this, task, event, scheduler));
            }
            if (Executions.getCurrent().getAttribute(ATMOSPHERE_SERVER_PUSH_ECHO) == null) {
                Executions.getCurrent().setAttribute(ATMOSPHERE_SERVER_PUSH_ECHO, (Object)Boolean.TRUE);
                Clients.response((AuResponse)new AuEcho());
            }
        }
    }

    public void start(Desktop desktop) {
        Desktop oldDesktop = this.desktop.getAndSet(desktop);
        if (oldDesktop != null) {
            this.log.warn("Server push already started for desktop " + desktop.getId());
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting server push for " + String.valueOf(desktop));
        }
        this.startClientPush(desktop);
    }

    private void startClientPush(Desktop desktop) {
        Clients.response((String)"jawwa.atmosphere.serverpush", (AuResponse)new AuScript(null, "jawwa.atmosphere.startServerPush('" + desktop.getId() + "', " + this.timeout + ");"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Desktop desktop = this.desktop.getAndSet(null);
        if (desktop == null) {
            this.log.warn("Server push hasn't been started or has already stopped");
            return;
        }
        AtmosphereResource currentResource = this.resource.getAndSet(null);
        List<Schedule<Event>> list = this.schedules;
        synchronized (list) {
            this.schedules.clear();
        }
        if (currentResource != null) {
            try {
                currentResource.close();
            }
            catch (IOException iOException) {}
        }
        if (Executions.getCurrent() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Stopping server push for " + String.valueOf(desktop));
            }
            Clients.response((String)"jawwa.atmosphere.serverpush", (AuResponse)new AuScript(null, "jawwa.atmosphere.stopServerPush('" + desktop.getId() + "');"));
        }
    }

    public void onRequest(AtmosphereResource resource) {
        AtmosphereResource oldResource;
        DesktopCtrl desktopCtrl;
        if (this.log.isTraceEnabled()) {
            this.log.trace(resource.transport().name());
        }
        if ((desktopCtrl = (DesktopCtrl)this.desktop.get()) == null) {
            this.log.error("No desktop available");
            return;
        }
        if (!resource.isSuspended()) {
            resource.suspend(5L, TimeUnit.MINUTES);
        }
        if ((oldResource = this.resource.getAndSet(resource)) != null) {
            try {
                if (!oldResource.isCancelled()) {
                    oldResource.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public void resume() {
        if (this.desktop == null || this.desktop.get() == null) {
            throw new IllegalStateException("ServerPush cannot be resumed without desktop, or has been stopped!call #start(desktop)} instead");
        }
        this.startClientPush(this.desktop.get());
    }

    public boolean hasAtmosphereResource() {
        return this.resource.get() != null;
    }

    private static class Schedule<T extends Event> {
        private EventListener<T> task;
        private T event;
        private Scheduler<T> scheduler;
        final /* synthetic */ AtmosphereServerPush this$0;

        private Schedule(EventListener<T> task, T event, Scheduler<T> scheduler) {
            this.this$0 = var1_1;
            this.task = task;
            this.event = event;
            this.scheduler = scheduler;
        }
    }

    private static class ThreadInfo {
        private final Thread thread;
        private int nActive;

        private ThreadInfo(Thread thread) {
            this.thread = thread;
        }

        public String toString() {
            return "[" + String.valueOf(this.thread) + "," + this.nActive + "]";
        }
    }
}

