-- IDEMPIERE-5785 Review of tables/columns that should/should not be logged
SELECT register_migration_script('202307162318_IDEMPIERE-5785_DisableChangeLog.sql') FROM dual;

-- disable changelog in table
UPDATE ad_table SET ischangelog='N'
WHERE ischangelog='Y' AND tablename IN (
'AD_Wlistbox_Customization'
)
;

-- disable logging in all *_Trl, *Log, I_*, T_*, read-only tables
UPDATE ad_column SET isallowlogging='N'
WHERE isallowlogging='Y'
AND ad_table_id IN
(SELECT ad_table_id 
 FROM ad_table
 WHERE tablename IN (
'A_Asset_Group_Trl',
'AD_AccessLog',
'AD_AlertProcessorLog',
'AD_BroadcastMessage_Trl',
'AD_ChangeLog',
'AD_Chart_Trl',
'AD_ChartDatasource_Trl',
'AD_Color_Trl',
'AD_Column_Trl',
'AD_CtxHelpMsg_Trl',
'AD_Element_Trl',
'AD_Field_Trl',
'AD_FieldGroup_Trl',
'AD_Form_Trl',
'AD_InfoColumn_Trl',
'AD_InfoWindow_Trl',
'AD_Issue',
'AD_LdapAccess',
'AD_LdapProcessorLog',
'AD_Menu_Trl',
'AD_Message_Trl',
'AD_Package_Imp_Backup',
'AD_Package_Imp_Detail',
'AD_Package_Imp_Proc',
'AD_Package_UUID_Map',
'AD_Password_History',
'AD_PInstance_Log',
'AD_PrintColor_Trl',
'AD_PrintFormat_Trl',
'AD_PrintFormatItem_Trl',
'AD_PrintLabelLine_Trl',
'AD_Process_DrillRule_Trl',
'AD_Process_Para_Trl',
'AD_Process_Trl',
'AD_RecentItem',
'AD_Ref_List_Trl',
'AD_Reference_Trl',
'AD_Replication_Log',
'AD_SchedulerLog',
'AD_Session',
'AD_Tab_Trl',
'AD_Table_Trl',
'AD_Task_Trl',
'AD_Tree_Favorite',
'AD_Tree_Favorite_Node',
'AD_TreeNode',
'AD_TreeNodeBP',
'AD_TreeNodeCMC',
'AD_TreeNodeCMM',
'AD_TreeNodeCMS',
'AD_TreeNodeCMT',
'AD_TreeNodeMM',
'AD_TreeNodePR',
'AD_TreeNodeU1',
'AD_TreeNodeU2',
'AD_TreeNodeU3',
'AD_TreeNodeU4',
'AD_WF_Activity',
'AD_WF_EventAudit',
'AD_WF_Node_Trl',
'AD_WF_Process',
'AD_Window_Trl',
'AD_Wlistbox_Customization',
'AD_Workflow_Trl',
'AD_WorkflowProcessorLog',
'C_AcctProcessorLog',
'C_Activity_Trl',
'C_Campaign_Trl',
'C_Charge_Trl',
'C_Country_Trl',
'C_CountryGroup_Trl',
'C_Currency_Trl',
'C_DocType_Trl',
'C_DunningLevel_Trl',
'C_ElementValue_Trl',
'C_Greeting_Trl',
'C_InvoiceTax',
'C_OnlineTrxHistory',
'C_OrderTax',
'C_PaymentTerm_Trl',
'C_Region_Trl',
'C_SalesRegion_Trl',
'C_SalesStage_Trl',
'C_Tax_Trl',
'C_TaxCategory_Trl',
'C_UOM_Trl',
'Fact_Acct',
'Fact_Acct_Summary',
'GL_Category_Trl',
'I_Asset',
'I_BankStatement',
'I_BPartner',
'I_Conversion_Rate',
'I_ElementValue',
'I_FAJournal',
'I_FixedAsset',
'I_GLJournal',
'I_HR_Movement',
'I_InOutLineConfirm',
'I_Inventory',
'I_Invoice',
'I_Movement',
'I_Order',
'I_Payment',
'I_PriceList',
'I_Product',
'I_ProductPlanning',
'I_ReportLine',
'IMP_ProcessorLog',
'M_CostDetail',
'M_PriceList_Trl',
'M_PriceList_Version_Trl',
'M_Product_Category_Trl',
'M_Product_Trl',
'M_StorageOnHand',
'M_StorageReservation',
'M_StorageReservationLog',
'PA_DashboardContent_Trl',
'PA_DocumentStatus_Trl',
'PA_ReportColumn_Trl',
'PP_Order_BOM_Trl',
'PP_Order_BOMLine_Trl',
'PP_Order_Node_Trl',
'PP_Order_Workflow_Trl',
'PP_Product_BOM_Trl',
'PP_Product_BOMLine_Trl',
'R_MailText_Trl',
'R_RequestProcessorLog',
'T_1099Extract',
'T_Aging',
'T_BankRegister',
'T_BOM_Indented',
'T_BOMLine',
'T_CashFlow',
'T_DistributionRunDetail',
'T_InventoryValue',
'T_InvoiceGL',
'T_MRP_CRP',
'T_Reconciliation',
'T_Replenish',
'T_Report',
'T_ReportStatement',
'T_Transaction',
'T_TrialBalance',
'W_MailMsg_Trl',
'W_Store_Trl'
 )
)
;

-- disallow logging from DocAction, ProcessedOn, DateNextRun, DateLastRun, and some unnecessary columns
UPDATE ad_column SET isallowlogging='N'
WHERE isallowlogging='Y'
AND (SELECT tablename FROM ad_table WHERE ad_table_id=ad_column.ad_table_id)||'.'||columnname IN (
'A_Asset_Addition.DocAction',
'A_Asset_Addition.ProcessedOn',
'A_Asset_Disposed.DocAction',
'A_Asset_Disposed.ProcessedOn',
'A_Asset_Reval.DocAction',
'A_Asset_Reval.ProcessedOn',
'A_Asset_Transfer.DocAction',
'A_Asset_Transfer.ProcessedOn',
'AD_AlertProcessor.DateLastRun',
'AD_AlertProcessor.DateNextRun',
'A_Depreciation_Entry.DocAction',
'A_Depreciation_Entry.ProcessedOn',
'AD_LdapProcessor.DateLastRun',
'AD_LdapProcessor.DateNextRun',
'AD_PInstance.AD_Language_ID',
'AD_PInstance.AD_PInstance_ID',
'AD_PInstance.AD_PrintFormat_ID',
'AD_PInstance.ErrorMsg',
'AD_PInstance.IsProcessing',
'AD_PInstance.ReportType',
'AD_PInstance.Result',
'AD_Replication.DateLastRun',
'AD_Scheduler.DateLastRun',
'AD_Scheduler.DateNextRun',
'AD_User.LastContact',
'AD_User.LastResult',
'AD_WorkflowProcessor.DateLastRun',
'AD_WorkflowProcessor.DateNextRun',
'C_AcctProcessor.DateLastRun',
'C_AcctProcessor.DateNextRun',
'C_AllocationHdr.DocAction',
'C_AllocationHdr.ProcessedOn',
'C_BankStatement.DocAction',
'C_BankStatementLoader.DateLastRun',
'C_BankStatement.ProcessedOn',
'C_BankTransfer.DocAction',
'C_BPartner.ActualLifeTimeValue',
'C_BPartner.SO_CreditUsed',
'C_BPartner.TotalOpenBalance',
'C_Cash.DocAction',
'C_Cash.ProcessedOn',
'C_Commission.DateLastRun',
'C_CommissionRun.GrandTotal',
'C_Invoice.DocAction',
'C_Invoice.GrandTotal',
'C_Invoice.ProcessedOn',
'C_Order.DocAction',
'C_Order.ProcessedOn',
'C_Payment.DocAction',
'C_Payment.IsAllocated',
'C_Payment.ProcessedOn',
'C_ProjectIssue.DocAction',
'C_ProjectIssue.ProcessedOn',
'C_Recurring.DateLastRun',
'C_Recurring.DateNextRun',
'DD_Order.DocAction',
'DD_Order.ProcessedOn',
'GL_JournalBatch.DocAction',
'GL_Journal.DocAction',
'GL_Journal.ProcessedOn',
'HR_Process.DocAction',
'HR_Process.ProcessedOn',
'IMP_Processor.DateLastRun',
'IMP_Processor.DateNextRun',
'M_InOutConfirm.DocAction',
'M_InOut.DocAction',
'M_InOutLine.IsInvoiced',
'M_InOut.ProcessedOn',
'M_Inventory.DocAction',
'M_Inventory.ProcessedOn',
'M_MatchInv.ProcessedOn',
'M_MatchPO.ProcessedOn',
'M_MovementConfirm.DocAction',
'M_Movement.DocAction',
'M_Movement.ProcessedOn',
'M_PerpetualInv.DateLastRun',
'M_PerpetualInv.DateNextRun',
'M_Production.DocAction',
'M_Production.ProcessedOn',
'M_Requisition.DocAction',
'M_Requisition.ProcessedOn',
'M_RMA.DocAction',
'M_Transaction.M_Transaction_ID',
'PA_Goal.DateLastRun',
'PA_SLA_Goal.DateLastRun',
'PP_Cost_Collector.DocAction',
'PP_Cost_Collector.ProcessedOn',
'PP_Order.DocAction',
'PP_Order.ProcessedOn',
'R_RequestProcessor.DateLastRun',
'R_RequestProcessor.DateNextRun',
'S_TimeExpense.DocAction'
)
;

-- change the default to not log on insert
UPDATE ad_sysconfig SET value='N' WHERE name='SYSTEM_INSERT_CHANGELOG' AND ad_client_id=0
;

/*
-- Recommended to execute the following two deletes in your instance if you want to clear your AD_ChangeLog

-- delete change log from tables not logged
DELETE FROM ad_changelog WHERE ad_table_id IN (SELECT ad_table_id FROM ad_table WHERE ischangelog='N')
;

-- delete change log from columns not logged
DELETE FROM ad_changelog WHERE ad_column_id IN (SELECT ad_column_id FROM ad_column WHERE isallowlogging='N')
;

-- delete change log from inserts when not logged
DELETE FROM ad_changelog WHERE EventChangeLog='I'
AND 
'N' = (SELECT value FROM ad_sysconfig WHERE name='SYSTEM_INSERT_CHANGELOG' AND ad_client_id=0 
         AND NOT EXISTS (SELECT 1 FROM ad_sysconfig WHERE name='SYSTEM_INSERT_CHANGELOG' AND ad_client_id!=0))
;

*/
