/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackIn;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.DatabaseAccessException;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.adempiere.pipo2.handler.ColumnElementHandler;
import org.adempiere.pipo2.handler.TableIndexElementHandler;
import org.adempiere.pipo2.handler.ViewComponentElementHandler;
import org.compiere.model.MColumn;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MTableIndex;
import org.compiere.model.MViewComponent;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.model.X_AD_Table;
import org.compiere.process.DatabaseViewValidate;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.TrxEventListener;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class TableElementHandler
extends AbstractElementHandler {
    private ColumnElementHandler columnHandler = new ColumnElementHandler();
    private TableIndexElementHandler tableIndexHandler = new TableIndexElementHandler();
    private ViewComponentElementHandler viewComponentHandler = new ViewComponentElementHandler();
    private List<Integer> tables = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        PoFiller filler;
        List notfounds;
        PackIn packIn = ctx.packIn;
        List excludes = this.defaultExcludeList("AD_Table");
        String entitytype = this.getStringValue(element, "EntityType");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        MTable mTable = (MTable)this.findPO(ctx, element);
        if (mTable == null) {
            mTable = new MTable(ctx.ctx, 0, this.getTrxName(ctx));
        }
        if ((notfounds = (filler = new PoFiller(ctx, (PO)mTable, element, (AbstractElementHandler)this)).autoFill(excludes)).size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        if (!mTable.is_new()) {
            if (!mTable.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Table", 100);
        String action = null;
        if (!mTable.is_new()) {
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_Table", (PO)mTable);
            action = "Update";
        } else {
            action = "New";
        }
        if (mTable.save(this.getTrxName(ctx))) {
            this.logImportDetail(ctx, impDetail, 1, mTable.getName(), mTable.get_ID(), action);
            this.tables.add(mTable.getAD_Table_ID());
            packIn.addTable(mTable.getTableName(), mTable.getAD_Table_ID());
            element.recordId = mTable.getAD_Table_ID();
            return;
        }
        this.logImportDetail(ctx, impDetail, 0, mTable.getName(), mTable.get_ID(), action);
        throw new POSaveFailedException("Failed to save Table " + mTable.getName());
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
        Trx trx;
        final MTable mTable = (MTable)this.findPO(ctx, element);
        if (element.defer && mTable == null) {
            return;
        }
        boolean isValidateView = false;
        MViewComponent[] m_vcs = mTable.getViewComponent(true);
        if (m_vcs != null && m_vcs.length > 0) {
            isValidateView = true;
        }
        if (mTable.isView() && isValidateView) {
            int success = this.validateDatabaseView(ctx, mTable);
            X_AD_Package_Imp_Detail dbDetail = this.createImportDetail(ctx, "dbView", "AD_Table", 100);
            if (success == 1) {
                this.logImportDetail(ctx, dbDetail, 1, mTable.getName(), mTable.get_ID(), "Validate");
            } else {
                this.logImportDetail(ctx, dbDetail, 0, mTable.getName(), mTable.get_ID(), "Validate");
                throw new DatabaseAccessException("Failed to validate view for " + mTable.getName());
            }
        }
        if ((trx = Trx.get((String)this.getTrxName(ctx), (boolean)false)) != null && !mTable.isView()) {
            trx.addTrxEventListener(new TrxEventListener(){

                public void afterRollback(Trx trx, boolean success) {
                }

                public void afterCommit(Trx trx, boolean success) {
                    if (success) {
                        CacheMgt.get().reset("AD_Table", mTable.get_ID());
                    }
                }

                public void afterClose(Trx trx) {
                }
            });
        }
    }

    private int validateDatabaseView(PIPOContext ctx, MTable table) {
        Trx trx = Trx.get((String)this.getTrxName(ctx), (boolean)true);
        if (MSysConfig.getBooleanValue((String)"2PACK_COMMIT_DDL", (boolean)false) && !trx.commit()) {
            return 0;
        }
        try {
            DatabaseViewValidate.validateDatabaseView((Properties)ctx.ctx, (MTable)table, (String)trx.getTrxName(), null);
            if (MSysConfig.getBooleanValue((String)"2PACK_COMMIT_DDL", (boolean)false)) {
                trx.commit(true);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            trx.rollback();
            return 0;
        }
        return 1;
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int AD_Table_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Table_ID");
        if (ctx.packOut.isExported("AD_Table_ID|" + AD_Table_ID)) {
            return;
        }
        PackOut packOut = ctx.packOut;
        AttributesImpl atts = new AttributesImpl();
        X_AD_Table m_Table = new X_AD_Table(ctx.ctx, AD_Table_ID, null);
        boolean createElement = this.isPackOutElement(ctx, (PO)m_Table);
        if (createElement) {
            this.verifyPackOutRequirement((PO)m_Table);
            this.addTypeName(atts, "table");
            document.startElement("", "", "AD_Table", atts);
            this.createTableBinding(ctx, document, m_Table);
        }
        try {
            List cols = new Query(ctx.ctx, "AD_Column", "AD_Table_ID=?", this.getTrxName(ctx)).setParameters(new Object[]{AD_Table_ID}).setOrderBy("IsKey DESC, AD_Column_ID").list();
            for (MColumn col : cols) {
                ElementHandler handler = packOut.getHandler("AD_Element");
                handler.packOut(packOut, document, null, col.getAD_Element_ID());
                if (col.getAD_Reference_ID() > 0) {
                    handler = packOut.getHandler("AD_Reference");
                    handler.packOut(packOut, document, null, col.getAD_Reference_ID());
                }
                if (col.getAD_Reference_Value_ID() > 0) {
                    handler = packOut.getHandler("AD_Reference");
                    handler.packOut(packOut, document, null, col.getAD_Reference_Value_ID());
                }
                if (col.getAD_Process_ID() > 0) {
                    handler = packOut.getHandler("AD_Process");
                    handler.packOut(packOut, document, null, col.getAD_Process_ID());
                }
                if (col.getAD_InfoWindow_ID() > 0) {
                    handler = packOut.getHandler("AD_InfoWindow");
                    handler.packOut(packOut, document, null, col.getAD_InfoWindow_ID());
                }
                if (col.getAD_Val_Rule_ID() > 0) {
                    handler = packOut.getHandler("AD_Val_Rule");
                    handler.packOut(packOut, document, null, col.getAD_Val_Rule_ID());
                }
                this.createColumn(ctx, document, col.getAD_Column_ID());
            }
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        try {
            List tis = new Query(ctx.ctx, "AD_TableIndex", "AD_Table_ID=?", this.getTrxName(ctx)).setParameters(new Object[]{AD_Table_ID}).setOrderBy("AD_TableIndex_ID").list();
            for (MTableIndex ti : tis) {
                this.createTableIndex(ctx, document, ti.getAD_TableIndex_ID());
            }
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        try {
            List vcs = new Query(ctx.ctx, "AD_ViewComponent", "AD_Table_ID=?", this.getTrxName(ctx)).setParameters(new Object[]{AD_Table_ID}).setOrderBy("SeqNo, AD_ViewComponent_ID").list();
            for (MViewComponent vc : vcs) {
                this.createViewComponent(ctx, document, vc.getAD_ViewComponent_ID());
            }
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        if (createElement) {
            document.endElement("", "", "AD_Table");
        }
    }

    private void createColumn(PIPOContext ctx, TransformerHandler document, int AD_Column_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_Column_ID", (int)AD_Column_ID);
        this.columnHandler.create(ctx, document);
        ctx.ctx.remove("AD_Column_ID");
    }

    private void createTableIndex(PIPOContext ctx, TransformerHandler document, int AD_TableIndex_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_TableIndex_ID", (int)AD_TableIndex_ID);
        this.tableIndexHandler.create(ctx, document);
        ctx.ctx.remove("AD_TableIndex_ID");
    }

    private void createViewComponent(PIPOContext ctx, TransformerHandler document, int AD_ViewComponent_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_ViewComponent_ID", (int)AD_ViewComponent_ID);
        this.viewComponentHandler.create(ctx, document);
        ctx.ctx.remove("AD_ViewComponent_ID");
    }

    private void createTableBinding(PIPOContext ctx, TransformerHandler document, X_AD_Table m_Table) {
        PoExporter filler = new PoExporter(ctx, document, (PO)m_Table);
        if (m_Table.getAD_Table_ID() <= 999999) {
            filler.add("AD_Table_ID", new AttributesImpl());
        }
        List excludes = this.defaultExcludeList("AD_Table");
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Table_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Table_ID");
    }
}

