/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import com.sun.mail.smtp.SMTPMessage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.compiere.Adempiere;
import org.compiere.model.MClient;
import org.compiere.model.MSysConfig;
import org.compiere.util.ByteArrayDataSource;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.EMailAuthenticator;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public final class EMail
implements Serializable {
    private static final long serialVersionUID = -8982983766981221312L;
    public static final String HTML_MAIL_MARKER = "ContentType=text/html;";
    public static final String EMAIL_SEND_MSG = "EmailSendMsg";
    private InternetAddress m_from;
    private ArrayList<InternetAddress> m_to;
    private ArrayList<InternetAddress> m_cc;
    private ArrayList<InternetAddress> m_bcc;
    private InternetAddress m_replyTo;
    private String m_subject;
    private String m_messageText;
    private String m_messageHTML;
    private String m_smtpHost;
    private int m_smtpPort;
    private boolean m_secureSmtp;
    private boolean m_acknowledgementReceipt;
    private ArrayList<DataSource> m_attachments;
    private transient EMailAuthenticator m_auth = null;
    private SMTPMessage m_msg = null;
    private Properties m_ctx;
    private boolean m_valid = false;
    private String m_sentMsg = null;
    private List<ValueNamePair> additionalHeaders = new ArrayList<ValueNamePair>();
    public static final String SENT_OK = "OK";
    protected static transient CLogger log = CLogger.getCLogger(EMail.class);
    private boolean m_forceUseTenantSmtp = false;

    public EMail(MClient client, String from, String to, String subject, String message) {
        this(client.getCtx(), client.getSMTPHost(), client.getSMTPPort(), client.isSecureSMTP(), from, to, subject, message, false);
    }

    public EMail(MClient client, String from, String to, String subject, String message, boolean html2) {
        this(client.getCtx(), client.getSMTPHost(), client.getSMTPPort(), client.isSecureSMTP(), from, to, subject, message, html2);
    }

    public EMail(Properties ctx, String smtpHost, String from, String to, String subject, String message) {
        this(ctx, smtpHost, 0, false, from, to, subject, message, false);
    }

    public EMail(Properties ctx, String smtpHost, String from, String to, String subject, String message, boolean html2) {
        this(ctx, smtpHost, 0, false, from, to, subject, message, html2);
    }

    public EMail(Properties ctx, String smtpHost, int smtpPort, boolean isSecureSmtp, String from, String to, String subject, String message, boolean html2) {
        this.setSmtpHost(smtpHost);
        this.setFrom(from);
        String bccAddressForAllMails = null;
        if (DB.isConnected()) {
            bccAddressForAllMails = MSysConfig.getValue("MAIL_SEND_BCC_TO_ADDRESS", Env.getAD_Client_ID(Env.getCtx()));
        }
        if (!Util.isEmpty(bccAddressForAllMails, true)) {
            this.addBcc(bccAddressForAllMails);
        }
        this.addTo(to);
        this.m_ctx = ctx;
        if (subject == null || subject.length() == 0) {
            this.setSubject(".");
        } else {
            this.setSubject(subject);
        }
        if (message != null && message.length() > 0) {
            if (html2) {
                this.setMessageHTML(subject, message);
            } else {
                this.setMessageText(message);
            }
        }
        this.m_valid = this.isValid(true);
        this.setSmtpPort(smtpPort);
        this.setSecureSmtp(isSecureSmtp);
    }

    private void setSecureSmtp(boolean isSecureSmtp) {
        this.m_secureSmtp = isSecureSmtp;
    }

    private void setSmtpPort(int smtpPort) {
        this.m_smtpPort = smtpPort;
    }

    public void setAcknoledgmentReceipt(boolean ar) {
        this.m_acknowledgementReceipt = ar;
    }

    public String send() {
        String msg;
        try {
            msg = this.send(false);
        }
        catch (Exception e) {
            msg = e.getLocalizedMessage();
        }
        return msg;
    }

    public String sendEx() throws Exception {
        return this.send(true);
    }

    /*
     * Exception decompiling
     */
    public String send(boolean throwException) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 21[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getCommaSeparatedString(InternetAddress[] recs) {
        StringBuilder retValue = new StringBuilder();
        InternetAddress[] internetAddressArray = recs;
        int n = recs.length;
        int n2 = 0;
        while (n2 < n) {
            InternetAddress rec = internetAddressArray[n2];
            if (retValue.length() > 0) {
                retValue.append(",");
            }
            retValue.append(rec.getAddress());
            ++n2;
        }
        return retValue.toString();
    }

    public String getSentMsg() {
        return this.m_sentMsg;
    }

    public boolean isSentOK() {
        return this.m_sentMsg != null && SENT_OK.equals(this.m_sentMsg);
    }

    private void dumpMessage() {
        if (this.m_msg == null || !log.isLoggable(Level.FINEST)) {
            return;
        }
        try {
            Enumeration e = this.m_msg.getAllHeaderLines();
            while (e.hasMoreElements()) {
                log.finest("- " + String.valueOf(e.nextElement()));
            }
        }
        catch (MessagingException ex) {
            log.log(Level.WARNING, this.m_msg.toString(), ex);
        }
    }

    protected MimeMessage getMimeMessage() {
        return this.m_msg;
    }

    public String getMessageID() {
        try {
            if (this.m_msg != null) {
                return this.m_msg.getMessageID();
            }
        }
        catch (MessagingException ex) {
            log.log(Level.SEVERE, "", ex);
        }
        return null;
    }

    public EMailAuthenticator createAuthenticator(String username, String password) {
        if (username == null || password == null) {
            log.fine("Ignored - " + username + "/" + password);
            this.m_auth = null;
        } else {
            this.m_auth = new EMailAuthenticator(username, password);
        }
        return this.m_auth;
    }

    public InternetAddress getFrom() {
        return this.m_from;
    }

    public void setFrom(String newFrom) {
        if (newFrom == null) {
            this.m_valid = false;
            return;
        }
        try {
            this.m_from = EMail.createInternetAddress(newFrom);
            if (DB.isConnected() && MSysConfig.getBooleanValue("MAIL_SEND_BCC_TO_FROM", false, Env.getAD_Client_ID(Env.getCtx()))) {
                this.addBcc(newFrom);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, newFrom + ": " + e.toString());
            this.m_valid = false;
        }
    }

    public boolean addTo(String newTo) {
        if (newTo == null || newTo.length() == 0) {
            this.m_valid = false;
            return false;
        }
        InternetAddress ia = null;
        try {
            ia = EMail.createInternetAddress(newTo);
        }
        catch (Exception e) {
            log.log(Level.WARNING, newTo + ": " + e.toString());
            this.m_valid = false;
            return false;
        }
        if (this.m_to == null) {
            this.m_to = new ArrayList();
        }
        this.m_to.add(ia);
        return true;
    }

    public InternetAddress getTo() {
        if (this.m_to == null || this.m_to.size() == 0) {
            return null;
        }
        InternetAddress ia = this.m_to.get(0);
        return ia;
    }

    public InternetAddress[] getTos() {
        if (this.m_to == null || this.m_to.size() == 0) {
            return null;
        }
        InternetAddress[] ias = new InternetAddress[this.m_to.size()];
        this.m_to.toArray(ias);
        return ias;
    }

    public boolean addCc(String newCc) {
        if (newCc == null || newCc.length() == 0) {
            return false;
        }
        InternetAddress ia = null;
        try {
            ia = EMail.createInternetAddress(newCc);
        }
        catch (Exception e) {
            log.log(Level.WARNING, newCc + ": " + e.toString());
            return false;
        }
        if (this.m_cc == null) {
            this.m_cc = new ArrayList();
        }
        this.m_cc.add(ia);
        return true;
    }

    public InternetAddress[] getCcs() {
        if (this.m_cc == null || this.m_cc.size() == 0) {
            return null;
        }
        InternetAddress[] ias = new InternetAddress[this.m_cc.size()];
        this.m_cc.toArray(ias);
        return ias;
    }

    public boolean addBcc(String newBcc) {
        String[] addresses;
        if (newBcc == null || newBcc.length() == 0) {
            return false;
        }
        String[] stringArray = addresses = newBcc.split(", *");
        int n = addresses.length;
        int n2 = 0;
        while (n2 < n) {
            String bccAddress = stringArray[n2];
            InternetAddress ia = null;
            try {
                ia = EMail.createInternetAddress(bccAddress);
            }
            catch (Exception e) {
                log.log(Level.WARNING, bccAddress + ": " + e.getMessage());
                return false;
            }
            if (this.m_bcc == null) {
                this.m_bcc = new ArrayList();
            }
            this.m_bcc.add(ia);
            ++n2;
        }
        return true;
    }

    public InternetAddress[] getBccs() {
        if (this.m_bcc == null || this.m_bcc.size() == 0) {
            return null;
        }
        InternetAddress[] ias = new InternetAddress[this.m_bcc.size()];
        this.m_bcc.toArray(ias);
        return ias;
    }

    public boolean setReplyTo(String newTo) {
        if (newTo == null || newTo.length() == 0) {
            return false;
        }
        InternetAddress ia = null;
        try {
            ia = EMail.createInternetAddress(newTo);
        }
        catch (Exception e) {
            log.log(Level.WARNING, newTo + ": " + e.toString());
            return false;
        }
        this.m_replyTo = ia;
        return true;
    }

    public InternetAddress getReplyTo() {
        return this.m_replyTo;
    }

    public void setSubject(String newSubject) {
        if (newSubject == null || newSubject.length() == 0) {
            this.m_valid = false;
        } else {
            this.m_subject = newSubject;
        }
    }

    public String getSubject() {
        return this.m_subject;
    }

    public void setMessageText(String newMessage) {
        if (newMessage == null || newMessage.length() == 0) {
            this.m_valid = false;
        } else {
            this.m_messageText = newMessage;
            if (!this.m_messageText.endsWith("\n")) {
                this.m_messageText = String.valueOf(this.m_messageText) + "\n";
            }
        }
    }

    public String getMessageCRLF() {
        if (this.m_messageText == null) {
            return "";
        }
        char[] chars = this.m_messageText.toCharArray();
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < chars.length) {
            char c = chars[i2];
            if (c == '\n') {
                int previous = i2 - 1;
                if (previous >= 0 && chars[previous] == '\r') {
                    sb.append(c);
                } else {
                    sb.append("\r\n");
                }
            } else {
                sb.append(c);
            }
            ++i2;
        }
        return sb.toString();
    }

    public void setMessageHTML(String html2) {
        if (html2 == null || html2.length() == 0) {
            this.m_valid = false;
        } else {
            this.m_messageHTML = html2;
            if (!this.m_messageHTML.endsWith("\n")) {
                this.m_messageHTML = String.valueOf(this.m_messageHTML) + "\n";
            }
        }
    }

    public void setMessageHTML(String subject, String message) {
        this.m_subject = subject;
        StringBuilder sb = new StringBuilder("<HTML>\n").append("<HEAD>\n").append("<TITLE>\n").append(subject + "\n").append("</TITLE>\n").append("</HEAD>\n");
        sb.append("<BODY>\n").append(message).append("\n").append("</BODY>\n");
        sb.append("</HTML>\n");
        this.m_messageHTML = sb.toString();
    }

    public String getMessageHTML() {
        return this.m_messageHTML;
    }

    public void addAttachment(File file) {
        if (file == null) {
            return;
        }
        if (this.m_attachments == null) {
            this.m_attachments = new ArrayList();
        }
        this.m_attachments.add((DataSource)new FileDataSource(file));
    }

    public void addAttachments(Collection<File> files) {
        if (files == null || files.size() == 0) {
            return;
        }
        for (File f : files) {
            this.addAttachment(f);
        }
    }

    public void addAttachment(URI url) {
        if (url == null) {
            return;
        }
        if (this.m_attachments == null) {
            this.m_attachments = new ArrayList();
        }
        try {
            this.m_attachments.add((DataSource)new URLDataSource(url.toURL()));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void addAttachment(byte[] data, String type, String name) {
        ByteArrayDataSource byteArray = new ByteArrayDataSource(data, type).setName(name);
        this.addAttachment(byteArray);
    }

    public void addAttachment(DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        if (this.m_attachments == null) {
            this.m_attachments = new ArrayList();
        }
        this.m_attachments.add(dataSource);
    }

    /*
     * Unable to fully structure code
     */
    private void setContent() throws MessagingException, IOException {
        block13: {
            block12: {
                charSetName = Ini.getCharset().name();
                if (charSetName == null || charSetName.length() == 0) {
                    charSetName = "iso-8859-1";
                }
                this.m_msg.setSubject(this.getSubject(), charSetName);
                if (this.m_attachments != null && this.m_attachments.size() != 0) break block12;
                if (this.m_messageHTML == null || this.m_messageHTML.length() == 0) {
                    this.m_msg.setText(this.getMessageCRLF(), charSetName);
                } else {
                    this.m_msg.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.m_messageHTML, charSetName, "text/html")));
                }
                if (EMail.log.isLoggable(Level.FINE)) {
                    EMail.log.fine("(simple) " + this.getSubject());
                }
                break block13;
            }
            htmlPart = null;
            planPart = new MimeBodyPart();
            planPart.setText(this.getMessageCRLF(), charSetName);
            htmlPart = new MimeBodyPart();
            if (this.m_messageHTML == null) {
                this.m_messageHTML = "<html><body>" + this.getMessageCRLF() + "</body></html>";
            }
            htmlPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.m_messageHTML, charSetName, "text/html")));
            mainPart = new MimeMultipart("mixed");
            viewContentPart = new MimeMultipart("related");
            viewBodyPart = new MimeBodyPart();
            viewBodyPart.setContent((Multipart)viewContentPart);
            mainPart.addBodyPart((BodyPart)viewBodyPart);
            textAlternativePart = new MimeMultipart("alternative");
            textAlternativePart.addBodyPart((BodyPart)htmlPart);
            alternativeBodyPart = new MimeBodyPart();
            alternativeBodyPart.setContent((Multipart)textAlternativePart);
            viewContentPart.addBodyPart((BodyPart)alternativeBodyPart);
            if (EMail.log.isLoggable(Level.FINE)) {
                EMail.log.fine("(multi) " + this.getSubject() + " - " + String.valueOf(htmlPart));
            }
            i = 0;
            while (i < this.m_attachments.size()) {
                block16: {
                    block17: {
                        block14: {
                            block15: {
                                attachment = this.m_attachments.get(i);
                                ds = null;
                                if (!(attachment instanceof File)) break block14;
                                file = (File)attachment;
                                if (!file.exists()) break block15;
                                ds = new FileDataSource(file);
                                ** GOTO lbl55
                            }
                            EMail.log.log(Level.WARNING, "File does not exist: " + String.valueOf(file));
                            break block16;
                        }
                        if (!(attachment instanceof URI)) break block17;
                        url = (URI)attachment;
                        ds = new URLDataSource(url.toURL());
                        ** GOTO lbl55
                    }
                    if (!(attachment instanceof DataSource)) {
                        EMail.log.log(Level.WARNING, "Attachement type unknown: " + String.valueOf(attachment));
                    } else {
                        ds = attachment;
lbl55:
                        // 3 sources

                        mbp_2 = new MimeBodyPart();
                        mbp_2.setDataHandler(new DataHandler(ds));
                        mbp_2.setFileName(ds.getName());
                        if (EMail.log.isLoggable(Level.FINE)) {
                            EMail.log.fine("Added Attachment " + ds.getName() + " - " + String.valueOf(mbp_2));
                        }
                        if (this.m_messageHTML != null && this.m_messageHTML.contains("cid:" + ds.getName())) {
                            mbp_2.setContentID("<" + ds.getName() + ">");
                            mbp_2.setDisposition("inline");
                            viewContentPart.addBodyPart((BodyPart)mbp_2);
                        } else {
                            mainPart.addBodyPart((BodyPart)mbp_2);
                        }
                    }
                }
                ++i;
            }
            this.m_msg.setContent((Multipart)mainPart);
        }
    }

    public void setSmtpHost(String newSmtpHost) {
        if (newSmtpHost == null || newSmtpHost.length() == 0) {
            this.m_valid = false;
        } else {
            this.m_smtpHost = newSmtpHost;
        }
    }

    public String getSmtpHost() {
        return this.m_smtpHost;
    }

    public boolean isValid() {
        return this.m_valid;
    }

    public boolean isValid(boolean recheck) {
        if (!recheck) {
            return this.m_valid;
        }
        if (this.m_from == null || this.m_from.getAddress().length() == 0 || this.m_from.getAddress().indexOf(32) != -1) {
            log.warning("From is invalid=" + String.valueOf(this.m_from));
            return false;
        }
        InternetAddress[] ias = this.getTos();
        if (ias == null) {
            log.warning("No To");
            return false;
        }
        int i2 = 0;
        while (i2 < ias.length) {
            if (ias[i2] == null || ias[i2].getAddress().length() == 0 || ias[i2].getAddress().indexOf(32) != -1) {
                log.warning("To(" + i2 + ") is invalid=" + String.valueOf(ias[i2]));
                return false;
            }
            ++i2;
        }
        if (this.m_smtpHost == null || this.m_smtpHost.length() == 0) {
            log.warning("SMTP Host is invalid" + this.m_smtpHost);
            return false;
        }
        if (this.m_subject == null || this.m_subject.length() == 0) {
            log.warning("Subject is invalid=" + this.m_subject);
            return false;
        }
        return true;
    }

    public Object[] getAttachments() {
        if (this.m_attachments == null) {
            return new Object[0];
        }
        return this.m_attachments.toArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EMail[");
        sb.append("From:").append(this.m_from).append(",To:").append(this.getTo()).append(",Subject=").append(this.getSubject()).append("]");
        return sb.toString();
    }

    public static boolean validate(String email) {
        try {
            new InternetAddress(email, true);
        }
        catch (Exception e) {
            log.log(Level.WARNING, email + ": " + e.toString());
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        if (args.length != 5) {
            System.out.println("Parameters: smtpHost from to subject message");
            System.out.println("Example: java org.compiere.util.EMail mail.acme.com joe@acme.com sue@acme.com HiThere CheersJoe");
            System.exit(1);
        }
        EMail email = new EMail(System.getProperties(), args[0], args[1], args[2], args[3], args[4]);
        email.send();
    }

    public void setHeader(String name, String value) {
        this.additionalHeaders.add(new ValueNamePair(value, name));
    }

    public static InternetAddress createInternetAddress(String email) throws Exception {
        int idx;
        String personal;
        InternetAddress ia = new InternetAddress(email, true);
        if (email.contains("<") && email.contains(">") && !(personal = email.substring(0, idx = email.lastIndexOf("<")).trim()).isEmpty()) {
            ia.setPersonal(personal);
        }
        return ia;
    }

    public void setForTenantSmtp(boolean forceTenantSmtp) {
        this.m_forceUseTenantSmtp = forceTenantSmtp;
    }
}

