/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MPeriod;
import org.compiere.model.MPeriodControl;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRefList;
import org.compiere.model.MSysConfig;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

@Process
public class PeriodControlStatus
extends SvrProcess {
    private List<Integer> p_C_PeriodControl_IDs;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null && !name.equals("*RecordIDs*")) {
                MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
            }
            ++i;
        }
        this.p_C_PeriodControl_IDs = this.getRecord_IDs();
        if (this.p_C_PeriodControl_IDs == null || this.p_C_PeriodControl_IDs.size() == 0) {
            this.p_C_PeriodControl_IDs = new ArrayList<Integer>();
            this.p_C_PeriodControl_IDs.add(this.getRecord_ID());
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_PeriodControl_ID=" + String.valueOf(this.p_C_PeriodControl_IDs));
        }
        boolean hasUnpostedDocs = false;
        ArrayList<MPeriodControl> skipped = new ArrayList<MPeriodControl>();
        for (int p_C_PeriodControl_ID : this.p_C_PeriodControl_IDs) {
            MPeriodControl pc = new MPeriodControl(this.getCtx(), p_C_PeriodControl_ID, this.get_TrxName());
            if (pc.get_ID() == 0) {
                throw new AdempiereUserError("@NotFound@  @C_PeriodControl_ID@=" + p_C_PeriodControl_ID);
            }
            if ("P".equals(pc.getPeriodStatus())) {
                throw new AdempiereUserError("@PeriodStatus@ = " + pc.getPeriodStatus());
            }
            MPeriod p = MPeriod.get((int)pc.getC_Period_ID());
            if (("C".equalsIgnoreCase(pc.getPeriodAction()) || "P".equalsIgnoreCase(pc.getPeriodAction())) && MSysConfig.getBooleanValue((String)"FORCE_POSTING_PRIOR_TO_PERIOD_CLOSE", (boolean)true, (int)this.getAD_Client_ID()) && p.hasUnpostedDocs(p_C_PeriodControl_ID)) {
                hasUnpostedDocs = true;
                skipped.add(pc);
                continue;
            }
            if ("O".equals(pc.getPeriodAction())) {
                pc.setPeriodStatus("O");
            }
            if ("C".equals(pc.getPeriodAction())) {
                pc.setPeriodStatus("C");
            }
            if ("P".equals(pc.getPeriodAction())) {
                pc.setPeriodStatus("P");
            }
            pc.setPeriodAction("N");
            boolean ok = pc.save();
            CacheMgt.get().reset("C_Period", pc.getC_Period_ID());
            if (ok) continue;
            return "@Error@";
        }
        String returnVal = "@OK";
        if (hasUnpostedDocs) {
            returnVal = Msg.getMsg((Properties)this.getCtx(), (String)"CouldNotClosePeriodControl");
            for (MPeriodControl pc : skipped) {
                String displayValue = "a";
                ValueNamePair[] valueNamePairArray = MRefList.getList((Properties)Env.getCtx(), (int)183, (boolean)false);
                int n = valueNamePairArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ValueNamePair vnp = valueNamePairArray[n2];
                    if (vnp.getValue().equals(pc.getDocBaseType())) {
                        displayValue = vnp.getName();
                        break;
                    }
                    ++n2;
                }
                this.addLog(pc.getC_PeriodControl_ID(), null, null, displayValue, 229, pc.getC_PeriodControl_ID());
            }
        }
        CacheMgt.get().reset("C_PeriodControl", 0);
        return returnVal;
    }
}

